/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.attributeactors;

import freemind.controller.Controller;
import freemind.controller.MapModuleManager;
import freemind.controller.filter.util.SortedListModel;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MapRegistry;
import freemind.modes.Mode;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.mindmapmode.attributeactors.AttributeRegistryTable;
import freemind.modes.mindmapmode.attributeactors.ImportAttributesDialog;
import freemind.modes.mindmapmode.attributeactors.ListDialog;
import freemind.view.MapModule;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;

public class AttributeManagerDialog
extends JDialog
implements MapModuleManager.MapModuleChangeObserver {
    private JTable view;
    private MapRegistry registry;
    private AttributeRegistry model;
    private static final String[] fontSizes = new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "24"};
    private JComboBox size;
    private ImportAttributesDialog importDialog = null;
    private Controller c;
    static final Icon editButtonImage = new ImageIcon(Resources.getInstance().getResource("images/edit12.png"));

    private void applyChanges() {
        Object size = this.size.getSelectedItem();
        int iSize = Integer.parseInt(size.toString());
        this.model.getAttributeController().performSetFontSize(this.model, iSize);
        this.model.applyChanges();
    }

    private void resetChanges() {
        int iSize = this.model.getFontSize();
        this.size.setSelectedItem(Integer.toString(iSize));
        this.model.resetChanges();
    }

    public AttributeManagerDialog(Controller c) {
        super(c.getJFrame(), Resources.getInstance().getResourceString("attributes_dialog_title"), true);
        this.c = c;
        this.view = new AttributeRegistryTable(new EditListAction());
        this.registry = c.getMap().getRegistry();
        this.model = this.registry.getAttributes();
        this.view.setModel(this.model.getTableModel());
        this.view.getSelectionModel().setSelectionMode(0);
        this.view.getTableHeader().setReorderingAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.view);
        this.getContentPane().add((Component)scrollPane, "Center");
        Box southButtons = Box.createHorizontalBox();
        southButtons.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)southButtons, "South");
        southButtons.add(Box.createHorizontalGlue());
        JButton ok = new JButton(new OKAction());
        southButtons.add(ok);
        southButtons.add(Box.createHorizontalGlue());
        JButton apply = new JButton(new ApplyAction());
        southButtons.add(apply);
        southButtons.add(Box.createHorizontalGlue());
        JButton cancel = new JButton(new CancelAction());
        southButtons.add(cancel);
        southButtons.add(Box.createHorizontalGlue());
        this.size = new JComboBox<String>(fontSizes);
        this.size.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AttributeManagerDialog.this.model.setAttributeLayoutChanged();
            }
        });
        this.size.setToolTipText(Resources.getInstance().getResourceString("attribute_font_size_tooltip"));
        southButtons.add(this.size);
        southButtons.add(Box.createHorizontalGlue());
        JButton importBtn = new JButton(new ImportAction());
        importBtn.setToolTipText(Resources.getInstance().getResourceString("attributes_import_tooltip"));
        southButtons.add(importBtn);
        southButtons.add(Box.createHorizontalGlue());
        Tools.addEscapeActionToDialog(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new ClosingListener());
        c.getMapModuleManager().addListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AttributeManagerDialog.this.size.setSelectedItem(Integer.toString(AttributeManagerDialog.this.model.getFontSize()));
            }
        });
    }

    @Override
    public boolean isMapModuleChangeAllowed(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        return !this.isVisible();
    }

    @Override
    public void beforeMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
    }

    @Override
    public void afterMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        if (newMapModule != null) {
            this.registry = newMapModule.getModel().getRegistry();
            this.model = this.registry.getAttributes();
            this.view.setModel(this.registry.getAttributes().getTableModel());
        }
    }

    @Override
    public void numberOfOpenMapInformation(int number) {
    }

    @Override
    public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
    }

    private class ClosingListener
    extends WindowAdapter {
        private ClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AttributeManagerDialog.this.resetChanges();
            super.windowClosing(e);
            AttributeManagerDialog.this.setVisible(false);
        }
    }

    class EditListAction
    extends AbstractAction {
        private int row;
        private SortedListModel listBoxModel;
        private String title;
        private String labelText;

        public EditListAction() {
            super("", editButtonImage);
            this.row = 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListDialog.showDialog((Component)e.getSource(), AttributeManagerDialog.this, this.labelText, this.title, this.listBoxModel, "xxxxxxxxxxxxxxxxxxxxx");
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public void setListBoxModel(String title, String labelText, SortedListModel listBoxModel) {
            this.title = title;
            this.labelText = labelText;
            this.listBoxModel = listBoxModel;
        }
    }

    private class ImportAction
    extends AbstractAction {
        ImportAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("attributes_import"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AttributeManagerDialog.this.importDialog == null) {
                AttributeManagerDialog.this.importDialog = new ImportAttributesDialog(AttributeManagerDialog.this.c, AttributeManagerDialog.this);
            }
            AttributeManagerDialog.this.importDialog.show();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeManagerDialog.this.resetChanges();
            AttributeManagerDialog.this.setVisible(false);
        }
    }

    private class OKAction
    extends AbstractAction {
        OKAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("ok"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeManagerDialog.this.applyChanges();
            AttributeManagerDialog.this.setVisible(false);
        }
    }

    private class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            Tools.setLabelAndMnemonic(this, Resources.getInstance().getResourceString("apply"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AttributeManagerDialog.this.applyChanges();
        }
    }
}

