/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.RevertXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Resources;
import freemind.modes.MindMap;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JOptionPane;

public class RevertAction
extends FreemindAction
implements ActorXml {
    private final MindMapController controller;

    public RevertAction(MindMapController modeController) {
        super("RevertAction", (String)null, modeController);
        this.controller = modeController;
        this.addActor(this);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        try {
            File file = this.controller.getMap().getFile();
            if (file == null) {
                JOptionPane.showMessageDialog(this.controller.getView(), this.controller.getText("map_not_saved"), "FreeMind", 0);
                return;
            }
            RevertXmlAction doAction = this.createRevertXmlAction(file);
            RevertXmlAction undoAction = this.createRevertXmlAction(this.controller.getMap(), null, file.getName());
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
    }

    public void openXmlInsteadOfMap(String xmlFileContent) {
        try {
            RevertXmlAction doAction = this.createRevertXmlAction(xmlFileContent, null, null);
            RevertXmlAction undoAction = this.createRevertXmlAction(this.controller.getMap(), null, null);
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
    }

    public RevertXmlAction createRevertXmlAction(File file) throws IOException {
        int c;
        String fileName = file.getAbsolutePath();
        FileReader f = new FileReader(file);
        StringBuffer buffer = new StringBuffer();
        while ((c = f.read()) != -1) {
            buffer.append((char)c);
        }
        f.close();
        return this.createRevertXmlAction(buffer.toString(), fileName, null);
    }

    public RevertXmlAction createRevertXmlAction(MindMap map, String fileName, String filePrefix) throws IOException {
        StringWriter writer = new StringWriter();
        map.getXml(writer);
        return this.createRevertXmlAction(writer.getBuffer().toString(), fileName, filePrefix);
    }

    public RevertXmlAction createRevertXmlAction(String xmlPackedFile, String fileName, String filePrefix) {
        RevertXmlAction revertXmlAction = new RevertXmlAction();
        revertXmlAction.setLocalFileName(fileName);
        revertXmlAction.setMap(xmlPackedFile);
        revertXmlAction.setFilePrefix(filePrefix);
        return revertXmlAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof RevertXmlAction) {
            try {
                RevertXmlAction revertAction = (RevertXmlAction)action;
                this.controller.getController().close(true);
                if (revertAction.getLocalFileName() != null) {
                    this.controller.load(new File(revertAction.getLocalFileName()));
                } else {
                    String filePrefix = this.controller.getText("freemind_reverted");
                    if (revertAction.getFilePrefix() != null) {
                        filePrefix = revertAction.getFilePrefix();
                    }
                    File tempFile = File.createTempFile(filePrefix, ".mm", new File(this.controller.getFrame().getFreemindDirectory()));
                    FileWriter fw = new FileWriter(tempFile);
                    fw.write(revertAction.getMap());
                    fw.close();
                    this.controller.load(tempFile);
                }
            }
            catch (Exception e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    @Override
    public Class getDoActionClass() {
        return RevertXmlAction.class;
    }
}

