/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.RemoveAllIconsXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.IconInformation;
import freemind.modes.MindIcon;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.IconAction;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class RemoveAllIconsAction
extends NodeGeneralAction
implements NodeActorXml,
IconInformation {
    private final IconAction addIconAction;

    public RemoveAllIconsAction(MindMapController modeController, IconAction addIconAction) {
        super(modeController, "remove_all_icons", "images/edittrash.png");
        this.addIconAction = addIconAction;
        this.addActor(this);
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        CompoundAction undoAction = new CompoundAction();
        for (MindIcon icon : selected.getIcons()) {
            undoAction.addChoice((Object)this.addIconAction.createAddIconAction(selected, icon, -1));
        }
        return new ActionPair((XmlAction)this.createRemoveAllIconsXmlAction(selected), (XmlAction)undoAction);
    }

    public RemoveAllIconsXmlAction createRemoveAllIconsXmlAction(MindMapNode node) {
        RemoveAllIconsXmlAction action = new RemoveAllIconsXmlAction();
        action.setNode(node.getObjectId(this.modeController));
        return action;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof RemoveAllIconsXmlAction) {
            RemoveAllIconsXmlAction removeAction = (RemoveAllIconsXmlAction)action;
            NodeAdapter node = this.modeController.getNodeFromID(removeAction.getNode());
            while (node.getIcons().size() > 0) {
                node.removeIcon(-1);
            }
            this.modeController.nodeChanged(node);
        }
    }

    public void removeAllIcons(MindMapNode node) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.apply(this.modeController.getMap(), node));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    @Override
    public Class getDoActionClass() {
        return RemoveAllIconsXmlAction.class;
    }

    @Override
    public String getDescription() {
        return (String)this.getValue("ShortDescription");
    }

    @Override
    public ImageIcon getIcon() {
        return (ImageIcon)this.getValue("SmallIcon");
    }

    @Override
    public KeyStroke getKeyStroke() {
        return Tools.getKeyStroke(this.getMindMapController().getFrame().getAdjustableProperty(this.getKeystrokeResourceName()));
    }

    @Override
    public String getKeystrokeResourceName() {
        return "keystroke_remove_all_icons";
    }
}

