/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.Controller;
import freemind.controller.actions.generated.instance.NodeBackgroundColorFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.SingleNodeOperation;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;

public class NodeBackgroundColorAction
extends FreemindAction
implements ActorXml {
    private final MindMapController controller;

    public NodeBackgroundColorAction(MindMapController controller) {
        super("node_background_color", (String)null, controller);
        this.controller = controller;
        this.addActor(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_node_background_color"), this.controller.getSelected().getBackgroundColor());
        if (color == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setNodeBackgroundColor(selected, color);
        }
    }

    public void setNodeBackgroundColor(MindMapNode node, Color color) {
        NodeBackgroundColorFormatAction doAction = this.createNodeBackgroundColorFormatAction(node, color);
        NodeBackgroundColorFormatAction undoAction = this.createNodeBackgroundColorFormatAction(node, node.getBackgroundColor());
        this.controller.getActionFactory().startTransaction(this.getClass().getName());
        this.controller.getActionFactory().executeAction(new ActionPair((XmlAction)doAction, (XmlAction)undoAction));
        this.controller.getActionFactory().endTransaction(this.getClass().getName());
    }

    public NodeBackgroundColorFormatAction createNodeBackgroundColorFormatAction(MindMapNode node, Color color) {
        NodeBackgroundColorFormatAction nodeAction = new NodeBackgroundColorFormatAction();
        nodeAction.setNode(node.getObjectId(this.controller));
        nodeAction.setColor(Tools.colorToXml(color));
        return nodeAction;
    }

    @Override
    public void act(XmlAction action) {
        NodeAdapter node;
        Color oldColor;
        NodeBackgroundColorFormatAction nodeColorAction;
        Color color;
        if (action instanceof NodeBackgroundColorFormatAction && !Tools.safeEquals(color = Tools.xmlToColor((nodeColorAction = (NodeBackgroundColorFormatAction)action).getColor()), oldColor = (node = this.controller.getNodeFromID(nodeColorAction.getNode())).getBackgroundColor())) {
            node.setBackgroundColor(color);
            this.controller.nodeChanged(node);
        }
    }

    @Override
    public Class getDoActionClass() {
        return NodeBackgroundColorFormatAction.class;
    }

    public static class RemoveNodeBackgroundColorAction
    extends NodeGeneralAction {
        private final MindMapController controller;

        public RemoveNodeBackgroundColorAction(final MindMapController controller) {
            super(controller, "remove_node_background_color", (String)null);
            this.controller = controller;
            this.setSingleNodeOperation(new SingleNodeOperation(){

                @Override
                public void apply(MindMapMapModel map, MindMapNodeModel node) {
                    controller.setNodeBackgroundColor(node, null);
                }
            });
        }
    }
}

