/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.EdgeStyleFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.EdgeAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapEdge;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;

public class EdgeStyleAction
extends NodeGeneralAction
implements NodeActorXml {
    private String mStyle;

    public EdgeStyleAction(MindMapController controller, String style) {
        super(controller, null, null);
        this.setName(controller.getText(style));
        this.mStyle = style;
        this.addActor(this);
    }

    @Override
    public ActionPair apply(MindMap model, MindMapNode selected) {
        return this.getActionPair(selected, this.mStyle);
    }

    @Override
    public Class getDoActionClass() {
        return EdgeStyleFormatAction.class;
    }

    public void setEdgeStyle(MindMapNode node, String style) {
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getActionPair(node, style));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private ActionPair getActionPair(MindMapNode selected, String style) {
        EdgeStyleFormatAction styleAction = this.createNodeStyleFormatAction(selected, style);
        String oldStyle = selected.getEdge().getStyle();
        if (!selected.getEdge().hasStyle()) {
            oldStyle = null;
        }
        EdgeStyleFormatAction undoStyleAction = this.createNodeStyleFormatAction(selected, oldStyle);
        return new ActionPair((XmlAction)styleAction, (XmlAction)undoStyleAction);
    }

    private EdgeStyleFormatAction createNodeStyleFormatAction(MindMapNode selected, String style) {
        EdgeStyleFormatAction edgeStyleAction = new EdgeStyleFormatAction();
        edgeStyleAction.setNode(this.getNodeID(selected));
        edgeStyleAction.setStyle(style);
        return edgeStyleAction;
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof EdgeStyleFormatAction) {
            EdgeStyleFormatAction edgeStyleAction = (EdgeStyleFormatAction)action;
            NodeAdapter node = this.getNodeFromID(edgeStyleAction.getNode());
            String newStyle = edgeStyleAction.getStyle();
            MindMapEdge edge = node.getEdge();
            if (!Tools.safeEquals(edge.hasStyle() ? edge.getStyle() : null, newStyle)) {
                ((EdgeAdapter)edge).setStyle(newStyle);
                this.modeController.nodeChanged(node);
            }
        }
    }
}

