/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.number;

import de.intarsys.tools.number.NumberInstance;
import de.intarsys.tools.number.NumberInterval;
import de.intarsys.tools.number.NumberList;
import de.intarsys.tools.number.NumberWrapper;
import java.io.IOException;
import java.io.StringReader;

public class NumberParser {
    private StringReader r;

    public static NumberWrapper parse(String numberstring) throws IOException {
        if (numberstring == null) {
            return null;
        }
        return new NumberParser(numberstring).parse();
    }

    protected NumberParser(String numberstring) {
        this.r = new StringReader(numberstring);
    }

    public int getChar() throws IOException {
        int i = this.r.read();
        return i;
    }

    private NumberWrapper makeWrapperObject(String numberValueInString) {
        int trenner = numberValueInString.indexOf(NumberInterval.SEPARATOR, 1);
        if (trenner == -1) {
            double zahl = Double.parseDouble(numberValueInString);
            NumberInstance instance = new NumberInstance(zahl);
            return instance;
        }
        if (trenner == 0) {
            throw new NumberFormatException("Missing parameter FROM in interval");
        }
        if (trenner == numberValueInString.length() - 1) {
            throw new NumberFormatException("Missing parameter TO in interval");
        }
        NumberInterval interval = new NumberInterval();
        String stringFrom = numberValueInString.substring(0, trenner);
        String stringTo = numberValueInString.substring(trenner + 1);
        Double from = new Double(Double.parseDouble(stringFrom));
        Double to = new Double(Double.parseDouble(stringTo));
        interval.setFrom(from);
        interval.setTo(to);
        return interval;
    }

    private NumberWrapper parse() throws IOException {
        NumberList numberList = new NumberList();
        numberList = this.parseNumberString(numberList);
        return numberList;
    }

    private NumberList parseNumberString(NumberList numberList) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean spaceFoundInNumber = false;
        int i = this.getChar();
        while (i > -1) {
            char c = (char)i;
            if (Character.isWhitespace(c)) {
                if (sb.length() != 0 && sb.charAt(sb.length() - 1) != '-') {
                    spaceFoundInNumber = true;
                }
            } else if (c == NumberList.SEPARATOR) {
                if (sb.length() != 0) {
                    numberList.add(this.makeWrapperObject(sb.toString()));
                    sb.setLength(0);
                    spaceFoundInNumber = false;
                }
            } else if (spaceFoundInNumber) {
                if (c != NumberInterval.SEPARATOR) {
                    throw new NumberFormatException("Space found in between number");
                }
                sb.append(c);
                spaceFoundInNumber = false;
            } else {
                sb.append(c);
            }
            i = this.getChar();
        }
        if (sb.length() > 0) {
            numberList.add(this.makeWrapperObject(sb.toString()));
        }
        return numberList;
    }
}

