/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.factory.PACKAGE;
import de.intarsys.tools.reflect.ObjectTools;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactoryTools {
    private static final Logger Log = PACKAGE.Log;

    public static IFactory lookupFactory(Class clazz) {
        String id = clazz.getName();
        IFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                factory = ObjectTools.createObject(clazz, IFactory.class);
                Outlet.get().registerFactory(factory);
                Log.log(Level.INFO, "created default factory '" + id + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factory;
    }

    public static IFactory lookupFactory(String id, ClassLoader classLoader) {
        IFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                factory = ObjectTools.createObject(id, IFactory.class, classLoader);
                Outlet.get().registerFactory(factory);
                Log.log(Level.INFO, "created default factory '" + id + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factory;
    }

    public static IFactory lookupFactoryFor(Class clazz) {
        IFactory[] factories = Outlet.get().lookupFactories(clazz);
        if (factories.length > 0) {
            return factories[0];
        }
        String id = String.valueOf(clazz.getName()) + "Factory";
        IFactory factory = Outlet.get().lookupFactory(id);
        if (factory == null) {
            try {
                factory = ObjectTools.createObject(id, IFactory.class, clazz.getClassLoader());
                Outlet.get().registerFactory(factory);
                Log.log(Level.INFO, "created default factory '" + id + "'");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return factory;
    }
}

