/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.PACKAGE;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFutureTask<R>
implements Runnable,
Future {
    protected static final Logger Log = PACKAGE.Log;
    private static int COUNTER = 0;
    private final Object lockTask = new Object();
    private Throwable exception;
    private R result;
    private boolean cancelled = false;
    private boolean computed = false;
    private final int id = COUNTER++;
    private boolean active = false;

    protected AbstractFutureTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Throwable basicGetException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    protected R basicGetResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean interrupt) {
        Object object = this.lockTask;
        synchronized (object) {
            block9: {
                block8: {
                    if (!this.cancelled) break block8;
                    if (Log.isLoggable(Level.FINEST)) {
                        Log.finest(this + " can't cancel, already canceled");
                    }
                    return false;
                }
                if (!this.computed) break block9;
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " can't cancel, already computed");
                }
                return false;
            }
            if (Log.isLoggable(Level.FINEST)) {
                Log.finest(this + " cancel " + (this.active ? "active" : "inactive") + " task");
            }
            this.cancelled = true;
            this.active = false;
            this.lockTask.notifyAll();
            return true;
        }
    }

    protected abstract R compute() throws Exception;

    protected void computeAsync() {
        new Thread((Runnable)this, "Task computation " + this.id).start();
    }

    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.get(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new InterruptedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R get(long pMillisecTimeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long millisecTimeout = pMillisecTimeout;
        long lastTime = System.currentTimeMillis();
        Object object = this.lockTask;
        synchronized (object) {
            long now;
            do {
                if (this.cancelled) {
                    return null;
                }
                if (this.computed) {
                    if (this.exception == null) return this.result;
                    throw new ExecutionException(this.exception);
                }
                if (pMillisecTimeout < 0L) return null;
                this.lockTask.wait(millisecTimeout);
            } while (pMillisecTimeout == 0L || (millisecTimeout -= (now = System.currentTimeMillis()) - (lastTime = now)) > 0L);
            throw new TimeoutException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getException() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception;
        }
    }

    protected final void handleException() {
        try {
            if (this.cancelled) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " exception after cancel");
                }
                this.undo();
                this.taskCancelled();
            } else {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " exception, propagate");
                }
                this.taskFailed();
            }
        }
        catch (Exception e) {
            Log.log(Level.SEVERE, this + " exception in exception handling", e);
        }
    }

    protected final void handleFinally() {
        try {
            if (Log.isLoggable(Level.FINEST)) {
                Log.finest(this + " finally, propagate");
            }
            this.taskFinally();
        }
        catch (Exception e) {
            Log.log(Level.SEVERE, this + " exception in finally handling", e);
        }
    }

    protected final void handleResult() {
        try {
            if (this.cancelled) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " computed after cancel, undo");
                }
                this.undo();
                this.taskCancelled();
            } else {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " computed, propagate");
                }
                this.taskFinished();
            }
        }
        catch (Exception e) {
            Log.log(Level.SEVERE, this + " exception in result handling", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.computed || this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFailed() {
        Object object = this.lockTask;
        synchronized (object) {
            return this.exception != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lockTask;
        synchronized (object) {
            this.active = false;
            this.computed = false;
            this.exception = null;
            this.result = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.lockTask;
        synchronized (object) {
            if (this.active || this.cancelled || this.computed) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " will not run" + (this.cancelled ? " (canceled)" : ""));
                }
                return;
            }
            this.active = true;
        }
        this.taskStarted();
        try {
            try {
                this.setResult(this.compute());
            }
            catch (Throwable e) {
                this.setException(e);
                this.handleFinally();
            }
        }
        finally {
            this.handleFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAsync() {
        AbstractFutureTask abstractFutureTask = this;
        synchronized (abstractFutureTask) {
            if (this.active || this.cancelled || this.computed) {
                if (Log.isLoggable(Level.FINEST)) {
                    Log.finest(this + " will not run" + (this.cancelled ? " (canceled)" : ""));
                }
                return;
            }
            this.active = true;
        }
        this.computeAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setException(Throwable e) {
        Object object = this.lockTask;
        synchronized (object) {
            this.computed = true;
            this.active = false;
            this.exception = e;
            this.lockTask.notifyAll();
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.finest(this + " computation failed");
        }
        this.handleException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(R object) {
        Object object2 = this.lockTask;
        synchronized (object2) {
            this.computed = true;
            this.active = false;
            this.result = object;
            this.lockTask.notifyAll();
        }
        if (Log.isLoggable(Level.FINEST)) {
            Log.finest(this + " computation ready");
        }
        this.handleResult();
    }

    protected void taskCancelled() {
    }

    protected void taskFailed() {
    }

    protected void taskFinally() {
    }

    protected void taskFinished() {
    }

    protected void taskStarted() {
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " - " + this.id;
    }

    protected void undo() {
    }
}

