/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

public class ByteArrayTools {
    public static byte[] concat(byte[] array1, byte[] array2) {
        byte[] concat = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, concat, 0, array1.length);
        System.arraycopy(array2, 0, concat, array1.length, array2.length);
        return concat;
    }

    public static byte[] copy(byte[] bytes) {
        byte[] newbuf = new byte[bytes.length];
        System.arraycopy(bytes, 0, newbuf, 0, bytes.length);
        return newbuf;
    }

    public static byte[] copy(byte[] bytes, int offset, int length) {
        byte[] newbuf = new byte[length];
        System.arraycopy(bytes, offset, newbuf, 0, length);
        return newbuf;
    }

    public static int indexOf(byte[] source, int sourceOffset, int sourceLen, byte[] pattern, int patternOffset, int patternLen, int fromIndex) {
        if (fromIndex >= sourceLen) {
            return patternLen == 0 ? sourceLen : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (patternLen == 0) {
            return fromIndex;
        }
        byte first = pattern[patternOffset];
        int max = sourceOffset + (sourceLen - patternLen);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + patternLen - 1;
                int k = patternOffset + 1;
                while (j < end && source[j] == pattern[k]) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public static boolean startsWith(byte[] bytes, byte[] pattern) {
        if (bytes == null) {
            return false;
        }
        if (pattern == null) {
            return true;
        }
        int length = pattern.length;
        int i = 0;
        while (i < length) {
            if (bytes[i] != pattern[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

