/*
 * Decompiled with CFR 0.152.
 */
package wsi.ra.tool;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    private static ResourceLoader resourceLoader;

    private ResourceLoader() {
    }

    public static synchronized ResourceLoader instance() {
        if (resourceLoader == null) {
            resourceLoader = new ResourceLoader();
        }
        return resourceLoader;
    }

    public byte[] getBytesFromResourceLocation(String resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        if ((resourceLocation = resourceLocation.trim()).startsWith("..") || resourceLocation.startsWith("/") || resourceLocation.startsWith("\\") || resourceLocation.length() > 1 && resourceLocation.charAt(1) == ':') {
            return this.getBytesFromFile(resourceLocation);
        }
        InputStream in = ClassLoader.getSystemResourceAsStream(resourceLocation);
        if (in == null) {
            in = this.getClass().getClassLoader().getResourceAsStream(resourceLocation);
        }
        if (in == null) {
            return null;
        }
        byte[] bytes = this.getBytesFromStream(in);
        return bytes;
    }

    public static Vector<String> readLines(String resourceFile) {
        return ResourceLoader.readLines(resourceFile, false);
    }

    public static Vector<String> readLines(String resourceFile, boolean ignoreCommentedLines) {
        if (resourceFile == null) {
            return null;
        }
        byte[] bytes = ResourceLoader.instance().getBytesFromResourceLocation(resourceFile);
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream sReader = new ByteArrayInputStream(bytes);
        LineNumberReader lnr = new LineNumberReader(new InputStreamReader(sReader));
        Vector<String> vector = new Vector<String>(100);
        try {
            String line;
            while ((line = lnr.readLine()) != null) {
                if (!ignoreCommentedLines) {
                    if (line.charAt(0) == '#') continue;
                    vector.add(line);
                    continue;
                }
                vector.add(line);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return vector;
    }

    private byte[] getBytesFromFile(String fileName) {
        if (fileName.startsWith("/cygdrive/")) {
            int length = "/cygdrive/".length();
            fileName = fileName.substring(length, length + 1) + ":" + fileName.substring(length + 1);
        }
        File file = new File(fileName);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (Exception e) {
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        int size = (int)file.length();
        byte[] b = new byte[size];
        int rb = 0;
        int chunk = 0;
        try {
            while (size - rb > 0 && (chunk = bis.read(b, rb, size - rb)) != -1) {
                rb += chunk;
            }
        }
        catch (Exception e) {
            return null;
        }
        return b;
    }

    private byte[] getBytesFromStream(InputStream stream) {
        BufferedInputStream bis = new BufferedInputStream(stream);
        try {
            int size = bis.available();
            byte[] b = new byte[size];
            int rb = 0;
            int chunk = 0;
            while (size - rb > 0 && (chunk = bis.read(b, rb, size - rb)) != -1) {
                rb += chunk;
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }
}

