/*
 * Decompiled with CFR 0.152.
 */
package spl.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import spl.listener.LabelLinkListener;
import spl.localization.LocalizationSupport;

public class ImportDialog
extends JDialog {
    private JPanel contentPane;
    private JLabel labelSubHeadline;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JRadioButton radioButtonXmp;
    private JRadioButton radioButtonMrDlib;
    private JRadioButton radioButtonNoMeta;
    private JLabel labelHeadline;
    private JLabel labelFileName;
    private JRadioButton radioButtononlyAttachPDF;
    private JRadioButton radioButtonUpdateEmptyFields;
    private JPanel panelUpdateEntry;
    private JLabel labelMrDlib1;
    private JLabel labelMrDlib2;
    private JPanel panelNewEntry;
    private int result;
    private int dropRow;
    private String fileName;

    public ImportDialog(int dropRow, String fileName) {
        this.dropRow = dropRow;
        this.$$$setupUI$$$();
        this.setText();
        if (this.dropRow < 0) {
            this.radioButtononlyAttachPDF.setEnabled(false);
            this.radioButtonUpdateEmptyFields.setEnabled(false);
            this.labelMrDlib2.setEnabled(false);
        }
        this.fileName = fileName;
        String name = new File(this.fileName).getName();
        if (name.length() < 34) {
            this.labelFileName.setText(name);
        } else {
            this.labelFileName.setText(new File(this.fileName).getName().substring(0, 33) + "...");
        }
        this.labelMrDlib1.addMouseListener(new LabelLinkListener(this.labelMrDlib1, "www.mr-dlib.org/docs/pdf_metadata_extraction.php"));
        this.labelMrDlib2.addMouseListener(new LabelLinkListener(this.labelMrDlib2, "www.mr-dlib.org/docs/pdf_metadata_extraction.php"));
        this.setTitle(LocalizationSupport.message("Import_Metadata_From_PDF"));
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onCancel();
            }
        });
        this.radioButtonXmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onXmp();
            }
        });
        this.radioButtonMrDlib.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onMrDlib();
            }
        });
        this.radioButtonNoMeta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onNoMeta();
            }
        });
        this.radioButtononlyAttachPDF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onAttachPDF();
            }
        });
        this.radioButtonUpdateEmptyFields.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onUpdateEntry();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.radioButtonMrDlib.setSelected(true);
        this.radioButtonMrDlib.requestFocus();
        this.setSize(555, 371);
    }

    private void onOK() {
        this.result = 0;
        this.dispose();
    }

    private void onCancel() {
        this.result = 2;
        this.dispose();
    }

    private void onXmp() {
        this.setSelection(this.radioButtonXmp);
    }

    private void onAttachPDF() {
        this.setSelection(this.radioButtononlyAttachPDF);
    }

    private void onUpdateEntry() {
        this.setSelection(this.radioButtonUpdateEmptyFields);
    }

    private void onMrDlib() {
        this.setSelection(this.radioButtonMrDlib);
    }

    private void onNoMeta() {
        this.setSelection(this.radioButtonNoMeta);
    }

    private void setSelection(JRadioButton button) {
        if (button != this.radioButtonMrDlib) {
            this.radioButtonMrDlib.setSelected(false);
        }
        if (button != this.radioButtonUpdateEmptyFields) {
            this.radioButtonUpdateEmptyFields.setSelected(false);
        }
        if (button != this.radioButtononlyAttachPDF) {
            this.radioButtononlyAttachPDF.setSelected(false);
        }
        if (button != this.radioButtonXmp) {
            this.radioButtonXmp.setSelected(false);
        }
        if (button != this.radioButtonNoMeta) {
            this.radioButtonNoMeta.setSelected(false);
        }
    }

    public void showDialog() {
        this.pack();
        this.setVisible(true);
    }

    public JRadioButton getRadioButtonXmp() {
        return this.radioButtonXmp;
    }

    public JRadioButton getRadioButtonMrDlib() {
        return this.radioButtonMrDlib;
    }

    public JRadioButton getRadioButtonNoMeta() {
        return this.radioButtonNoMeta;
    }

    public JRadioButton getRadioButtononlyAttachPDF() {
        return this.radioButtononlyAttachPDF;
    }

    public JRadioButton getRadioButtonUpdateEmptyFields() {
        return this.radioButtonUpdateEmptyFields;
    }

    public int getResult() {
        return this.result;
    }

    private void setText() {
        this.labelHeadline.setText(LocalizationSupport.message("Import_Metadata_from:"));
        this.labelSubHeadline.setText(LocalizationSupport.message("Choose_the_source_for_the_metadata_import"));
        this.buttonOK.setText(LocalizationSupport.message("Ok"));
        this.buttonCancel.setText(LocalizationSupport.message("Cancel"));
        this.radioButtonXmp.setText(LocalizationSupport.message("Create_entry_based_on_XMP_data"));
        this.radioButtonUpdateEmptyFields.setText(LocalizationSupport.message("Update_empty_fields_with_data_fetched_from"));
        this.radioButtonMrDlib.setText(LocalizationSupport.message("Create_entry_based_on_data_fetched_from"));
        this.radioButtonNoMeta.setText(LocalizationSupport.message("Create_blank_entry_linking_the_PDF"));
        this.radioButtononlyAttachPDF.setText(LocalizationSupport.message("Only_attach_PDF"));
        this.labelMrDlib1.setText(LocalizationSupport.message("Mr._dLib"));
        this.labelMrDlib2.setText(LocalizationSupport.message("Mr._dLib"));
        this.panelNewEntry.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LocalizationSupport.message("Create_New_Entry"), 0, 0, new Font(this.panelNewEntry.getFont().getName(), this.panelNewEntry.getFont().getStyle(), 12), new Color(-16777216)));
        this.panelUpdateEntry.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LocalizationSupport.message("Update_Existing_Entry"), 0, 0, new Font(this.panelUpdateEntry.getFont().getName(), this.panelUpdateEntry.getFont().getStyle(), 12), new Color(-16777216)));
    }

    private void createUIComponents() {
    }

    private void $$$setupUI$$$() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel1 = new JPanel();
        panel1.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(5, 0, 20, 0), -1, -1));
        panel1.setBackground(new Color(-1643275));
        this.contentPane.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        JPanel panel2 = new JPanel();
        panel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 0, 0, 0), -1, -1));
        panel2.setBackground(new Color(-1643275));
        panel1.add((Component)panel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.labelSubHeadline = new JLabel();
        this.labelSubHeadline.setFont(new Font(this.labelSubHeadline.getFont().getName(), this.labelSubHeadline.getFont().getStyle(), 13));
        this.labelSubHeadline.setText("");
        panel2.add((Component)this.labelSubHeadline, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 4, false));
        Spacer spacer1 = new Spacer();
        panel2.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1));
        panel3.setBackground(new Color(-1643275));
        panel1.add((Component)panel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, new Dimension(600, -1), 0, false));
        this.labelHeadline = new JLabel();
        this.labelHeadline.setFont(new Font(this.labelHeadline.getFont().getName(), 1, 14));
        this.labelHeadline.setText("");
        panel3.add((Component)this.labelHeadline, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1, false));
        this.labelFileName = new JLabel();
        this.labelFileName.setFont(new Font(this.labelFileName.getFont().getName(), 1, 14));
        this.labelFileName.setText("[fileName]");
        panel3.add((Component)this.labelFileName, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, new Dimension(300, -1), 0, false));
        Spacer spacer2 = new Spacer();
        panel1.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel4 = new JPanel();
        panel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.contentPane.add((Component)panel4, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null, 0, false));
        Spacer spacer3 = new Spacer();
        panel4.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 10, 10), -1, -1, true, false));
        panel4.add((Component)panel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonOK = new JButton();
        this.buttonOK.setText("");
        panel5.add((Component)this.buttonOK, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("");
        panel5.add((Component)this.buttonCancel, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        JPanel panel6 = new JPanel();
        panel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 5, 0, 5), -1, -1));
        this.contentPane.add((Component)panel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.panelNewEntry = new JPanel();
        this.panelNewEntry.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 5, 0, 5), 0, -1));
        this.panelNewEntry.setFont(new Font(this.panelNewEntry.getFont().getName(), this.panelNewEntry.getFont().getStyle(), 11));
        panel6.add((Component)this.panelNewEntry, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.panelNewEntry.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, new Font(this.panelNewEntry.getFont().getName(), this.panelNewEntry.getFont().getStyle(), 12), new Color(-16777216)));
        JPanel panel7 = new JPanel();
        panel7.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(10, 0, 0, 10), 2, -1));
        this.panelNewEntry.add((Component)panel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.radioButtonXmp = new JRadioButton();
        this.radioButtonXmp.setFont(new Font(this.radioButtonXmp.getFont().getName(), this.radioButtonXmp.getFont().getStyle(), 13));
        this.radioButtonXmp.setText("");
        panel7.add((Component)this.radioButtonXmp, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1, false));
        Spacer spacer4 = new Spacer();
        panel7.add((Component)spacer4, new GridConstraints(1, 2, 1, 1, 0, 1, 4, 1, new Dimension(100, -1), null, null, 0, false));
        this.radioButtonMrDlib = new JRadioButton();
        this.radioButtonMrDlib.setFont(new Font(this.radioButtonMrDlib.getFont().getName(), this.radioButtonMrDlib.getFont().getStyle(), 13));
        this.radioButtonMrDlib.setText("");
        panel7.add((Component)this.radioButtonMrDlib, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1, false));
        this.radioButtonNoMeta = new JRadioButton();
        this.radioButtonNoMeta.setFont(new Font(this.radioButtonNoMeta.getFont().getName(), this.radioButtonNoMeta.getFont().getStyle(), 13));
        this.radioButtonNoMeta.setText("");
        panel7.add((Component)this.radioButtonNoMeta, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1, false));
        this.labelMrDlib1 = new JLabel();
        this.labelMrDlib1.setFont(new Font(this.labelMrDlib1.getFont().getName(), 1, 13));
        this.labelMrDlib1.setForeground(new Color(-16776961));
        this.labelMrDlib1.setHorizontalAlignment(2);
        this.labelMrDlib1.setHorizontalTextPosition(2);
        this.labelMrDlib1.setText("");
        panel7.add((Component)this.labelMrDlib1, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer5 = new Spacer();
        panel6.add((Component)spacer5, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
        this.panelUpdateEntry = new JPanel();
        this.panelUpdateEntry.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 5, 0, 5), 3, -1));
        this.panelUpdateEntry.setFont(new Font(this.panelUpdateEntry.getFont().getName(), this.panelUpdateEntry.getFont().getStyle(), 11));
        panel6.add((Component)this.panelUpdateEntry, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.panelUpdateEntry.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, new Font(this.panelUpdateEntry.getFont().getName(), this.panelUpdateEntry.getFont().getStyle(), 12), new Color(-16777216)));
        this.radioButtononlyAttachPDF = new JRadioButton();
        this.radioButtononlyAttachPDF.setFont(new Font(this.radioButtononlyAttachPDF.getFont().getName(), this.radioButtononlyAttachPDF.getFont().getStyle(), 13));
        this.radioButtononlyAttachPDF.setText("");
        this.panelUpdateEntry.add((Component)this.radioButtononlyAttachPDF, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 1, false));
        this.radioButtonUpdateEmptyFields = new JRadioButton();
        this.radioButtonUpdateEmptyFields.setFont(new Font(this.radioButtonUpdateEmptyFields.getFont().getName(), this.radioButtonUpdateEmptyFields.getFont().getStyle(), 13));
        this.radioButtonUpdateEmptyFields.setText("");
        this.panelUpdateEntry.add((Component)this.radioButtonUpdateEmptyFields, new GridConstraints(1, 0, 1, 1, 0, 0, 3, 0, null, null, null, 1, false));
        Spacer spacer6 = new Spacer();
        this.panelUpdateEntry.add((Component)spacer6, new GridConstraints(1, 2, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.labelMrDlib2 = new JLabel();
        this.labelMrDlib2.setFont(new Font(this.labelMrDlib2.getFont().getName(), 1, 13));
        this.labelMrDlib2.setForeground(new Color(-16776961));
        this.labelMrDlib2.setHorizontalAlignment(10);
        this.labelMrDlib2.setHorizontalTextPosition(10);
        this.labelMrDlib2.setText("");
        this.labelMrDlib2.setVerticalAlignment(0);
        this.panelUpdateEntry.add((Component)this.labelMrDlib2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer7 = new Spacer();
        this.contentPane.add((Component)spacer7, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, new Dimension(-1, 10), null, null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

