/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.ResourceLoader;
import org.pdfbox.util.TextPosition;
import org.pdfbox.util.TextPositionComparator;

public class PDFTextStripper
extends PDFStreamEngine {
    private int currentPageNo = 0;
    private int startPage = 1;
    private int endPage = Integer.MAX_VALUE;
    private PDOutlineItem startBookmark = null;
    private int startBookmarkPageNumber = -1;
    private PDOutlineItem endBookmark = null;
    private int endBookmarkPageNumber = -1;
    private PDDocument document;
    private boolean suppressDuplicateOverlappingText = true;
    private boolean shouldSeparateByBeads = true;
    private boolean sortByPosition = false;
    private List pageArticles = null;
    protected Vector charactersByArticle = new Vector();
    private Map characterListMapping = new HashMap();
    private String lineSeparator = System.getProperty("line.separator");
    private String pageSeparator = System.getProperty("line.separator");
    private String wordSeparator = " ";
    protected Writer output;

    public PDFTextStripper() throws IOException {
        super(ResourceLoader.loadProperties("Resources/PDFTextStripper.properties"));
    }

    public PDFTextStripper(Properties props) throws IOException {
        super(props);
    }

    public String getText(PDDocument doc) throws IOException {
        StringWriter outputStream = new StringWriter();
        this.writeText(doc, (Writer)outputStream);
        return outputStream.toString();
    }

    public String getText(COSDocument doc) throws IOException {
        return this.getText(new PDDocument(doc));
    }

    public void writeText(COSDocument doc, Writer outputStream) throws IOException {
        this.writeText(new PDDocument(doc), outputStream);
    }

    public void writeText(PDDocument doc, Writer outputStream) throws IOException {
        this.resetEngine();
        this.currentPageNo = 0;
        this.document = doc;
        this.output = outputStream;
        this.startDocument(this.document);
        if (this.document.isEncrypted()) {
            try {
                this.document.decrypt("");
            }
            catch (CryptographyException e) {
                throw new IOException("Error decrypting document, details: " + e.getMessage());
            }
            catch (InvalidPasswordException e) {
                throw new IOException("Error: document is encrypted");
            }
        }
        this.processPages(this.document.getDocumentCatalog().getAllPages());
        this.endDocument(this.document);
    }

    protected void processPages(List pages) throws IOException {
        if (this.startBookmark != null) {
            this.startBookmarkPageNumber = this.getPageNumber(this.startBookmark, pages);
        }
        if (this.endBookmark != null) {
            this.endBookmarkPageNumber = this.getPageNumber(this.endBookmark, pages);
        }
        if (this.startBookmarkPageNumber == -1 && this.startBookmark != null && this.endBookmarkPageNumber == -1 && this.endBookmark != null && this.startBookmark.getCOSObject() == this.endBookmark.getCOSObject()) {
            this.startBookmarkPageNumber = 0;
            this.endBookmarkPageNumber = 0;
        }
        Iterator pageIter = pages.iterator();
        while (pageIter.hasNext()) {
            PDPage nextPage = (PDPage)pageIter.next();
            PDStream contentStream = nextPage.getContents();
            if (contentStream == null) continue;
            COSStream contents = contentStream.getStream();
            this.processPage(nextPage, contents);
        }
    }

    private int getPageNumber(PDOutlineItem bookmark, List allPages) throws IOException {
        int pageNumber = -1;
        PDPage page = bookmark.findDestinationPage(this.document);
        if (page != null) {
            pageNumber = allPages.indexOf(page) + 1;
        }
        return pageNumber;
    }

    protected void startDocument(PDDocument pdf) throws IOException {
    }

    protected void endDocument(PDDocument pdf) throws IOException {
    }

    protected void processPage(PDPage page, COSStream content) throws IOException {
        ++this.currentPageNo;
        if (!(this.currentPageNo < this.startPage || this.currentPageNo > this.endPage || this.startBookmarkPageNumber != -1 && this.currentPageNo < this.startBookmarkPageNumber || this.endBookmarkPageNumber != -1 && this.currentPageNo > this.endBookmarkPageNumber)) {
            this.startPage(page);
            this.pageArticles = page.getThreadBeads();
            int numberOfArticleSections = 1 + this.pageArticles.size() * 2;
            if (!this.shouldSeparateByBeads) {
                numberOfArticleSections = 1;
            }
            int originalSize = this.charactersByArticle.size();
            this.charactersByArticle.setSize(numberOfArticleSections);
            for (int i = 0; i < numberOfArticleSections; ++i) {
                if (numberOfArticleSections < originalSize) {
                    ((List)this.charactersByArticle.get(i)).clear();
                    continue;
                }
                this.charactersByArticle.set(i, new ArrayList());
            }
            this.characterListMapping.clear();
            this.processStream(page, page.findResources(), content);
            this.flushText();
            this.endPage(page);
        }
    }

    protected void startParagraph() throws IOException {
    }

    protected void endParagraph() throws IOException {
    }

    protected void startPage(PDPage page) throws IOException {
    }

    protected void endPage(PDPage page) throws IOException {
    }

    protected void flushText() throws IOException {
        float currentY = -1.0f;
        float lastBaselineFontSize = -1.0f;
        float endOfLastTextX = -1.0f;
        float startOfNextWordX = -1.0f;
        float lastWordSpacing = -1.0f;
        TextPosition lastProcessedCharacter = null;
        for (int i = 0; i < this.charactersByArticle.size(); ++i) {
            this.startParagraph();
            List textList = (List)this.charactersByArticle.get(i);
            if (this.sortByPosition) {
                TextPositionComparator comparator = new TextPositionComparator(this.getCurrentPage());
                Collections.sort(textList, comparator);
            }
            Iterator textIter = textList.iterator();
            while (textIter.hasNext()) {
                TextPosition position = (TextPosition)textIter.next();
                String characterValue = position.getCharacter();
                float wordSpacing = 0.0f;
                if (wordSpacing == 0.0f && (wordSpacing = position.getWidthOfSpace()) == 0.0f) {
                    wordSpacing = position.getWidth();
                }
                startOfNextWordX = lastWordSpacing <= 0.0f ? endOfLastTextX + wordSpacing * 0.5f : endOfLastTextX + (wordSpacing + lastWordSpacing) / 2.0f * 0.5f;
                lastWordSpacing = wordSpacing;
                int verticalScaling = 1;
                if (lastBaselineFontSize < 0.0f || position.getFontSize() < 0.0f) {
                    verticalScaling = -1;
                }
                if (currentY != -1.0f && (position.getY() < currentY - lastBaselineFontSize * 0.9f * (float)verticalScaling || position.getY() > currentY + position.getFontSize() * 0.9f * (float)verticalScaling)) {
                    this.output.write(this.lineSeparator);
                    endOfLastTextX = -1.0f;
                    startOfNextWordX = -1.0f;
                    currentY = -1.0f;
                    lastBaselineFontSize = -1.0f;
                }
                if (startOfNextWordX != -1.0f && startOfNextWordX < position.getX() && lastProcessedCharacter != null && lastProcessedCharacter.getCharacter() != null && !lastProcessedCharacter.getCharacter().endsWith(" ")) {
                    this.output.write(this.wordSeparator);
                }
                if (currentY == -1.0f) {
                    currentY = position.getY();
                }
                if (currentY == position.getY()) {
                    lastBaselineFontSize = position.getFontSize();
                }
                endOfLastTextX = position.getX() + position.getWidth();
                if (characterValue != null) {
                    this.writeCharacters(position);
                }
                lastProcessedCharacter = position;
            }
            this.endParagraph();
        }
        this.output.write(this.pageSeparator);
        this.output.flush();
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        this.output.write(text.getCharacter());
    }

    private boolean within(float first, float second, float variance) {
        return second > first - variance && second < first + variance;
    }

    protected void showCharacter(TextPosition text) {
        int i;
        boolean showCharacter = true;
        if (this.suppressDuplicateOverlappingText) {
            showCharacter = false;
            String textCharacter = text.getCharacter();
            float textX = text.getX();
            float textY = text.getY();
            ArrayList<TextPosition> sameTextCharacters = (ArrayList<TextPosition>)this.characterListMapping.get(textCharacter);
            if (sameTextCharacters == null) {
                sameTextCharacters = new ArrayList<TextPosition>();
                this.characterListMapping.put(textCharacter, sameTextCharacters);
            }
            boolean suppressCharacter = false;
            float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
            for (i = 0; i < sameTextCharacters.size() && textCharacter != null; ++i) {
                TextPosition character = (TextPosition)sameTextCharacters.get(i);
                String charCharacter = character.getCharacter();
                float charX = character.getX();
                float charY = character.getY();
                if (charCharacter == null || !this.within(charX, textX, tolerance) || !this.within(charY, textY, tolerance)) continue;
                suppressCharacter = true;
            }
            if (!suppressCharacter) {
                sameTextCharacters.add(text);
                showCharacter = true;
            }
        }
        if (showCharacter) {
            int foundArticleDivisionIndex = -1;
            int notFoundButFirstLeftAndAboveArticleDivisionIndex = -1;
            int notFoundButFirstLeftArticleDivisionIndex = -1;
            int notFoundButFirstAboveArticleDivisionIndex = -1;
            float x = text.getX();
            float y = text.getY();
            if (this.shouldSeparateByBeads) {
                for (i = 0; i < this.pageArticles.size() && foundArticleDivisionIndex == -1; ++i) {
                    PDThreadBead bead = (PDThreadBead)this.pageArticles.get(i);
                    if (bead != null) {
                        PDRectangle rect = bead.getRectangle();
                        if (rect.contains(x, y)) {
                            foundArticleDivisionIndex = i * 2 + 1;
                            continue;
                        }
                        if ((x < rect.getLowerLeftX() || y < rect.getUpperRightY()) && notFoundButFirstLeftAndAboveArticleDivisionIndex == -1) {
                            notFoundButFirstLeftAndAboveArticleDivisionIndex = i * 2;
                            continue;
                        }
                        if (x < rect.getLowerLeftX() && notFoundButFirstLeftArticleDivisionIndex == -1) {
                            notFoundButFirstLeftArticleDivisionIndex = i * 2;
                            continue;
                        }
                        if (!(y < rect.getUpperRightY()) || notFoundButFirstAboveArticleDivisionIndex != -1) continue;
                        notFoundButFirstAboveArticleDivisionIndex = i * 2;
                        continue;
                    }
                    foundArticleDivisionIndex = 0;
                }
            } else {
                foundArticleDivisionIndex = 0;
            }
            int articleDivisionIndex = -1;
            articleDivisionIndex = foundArticleDivisionIndex != -1 ? foundArticleDivisionIndex : (notFoundButFirstLeftAndAboveArticleDivisionIndex != -1 ? notFoundButFirstLeftAndAboveArticleDivisionIndex : (notFoundButFirstLeftArticleDivisionIndex != -1 ? notFoundButFirstLeftArticleDivisionIndex : (notFoundButFirstAboveArticleDivisionIndex != -1 ? notFoundButFirstAboveArticleDivisionIndex : this.charactersByArticle.size() - 1)));
            List textList = (List)this.charactersByArticle.get(articleDivisionIndex);
            textList.add(text);
        }
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPageValue) {
        this.startPage = startPageValue;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPageValue) {
        this.endPage = endPageValue;
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setPageSeparator(String separator) {
        this.pageSeparator = separator;
    }

    public String getWordSeparator() {
        return this.wordSeparator;
    }

    public void setWordSeparator(String separator) {
        this.wordSeparator = separator;
    }

    public String getPageSeparator() {
        return this.pageSeparator;
    }

    public boolean shouldSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    protected int getCurrentPageNo() {
        return this.currentPageNo;
    }

    protected Writer getOutput() {
        return this.output;
    }

    protected List getCharactersByArticle() {
        return this.charactersByArticle;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingTextValue) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingTextValue;
    }

    public boolean shouldSeparateByBeads() {
        return this.shouldSeparateByBeads;
    }

    public void setShouldSeparateByBeads(boolean aShouldSeparateByBeads) {
        this.shouldSeparateByBeads = aShouldSeparateByBeads;
    }

    public PDOutlineItem getEndBookmark() {
        return this.endBookmark;
    }

    public void setEndBookmark(PDOutlineItem aEndBookmark) {
        this.endBookmark = aEndBookmark;
    }

    public PDOutlineItem getStartBookmark() {
        return this.startBookmark;
    }

    public void setStartBookmark(PDOutlineItem aStartBookmark) {
        this.startBookmark = aStartBookmark;
    }

    public boolean shouldSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean newSortByPosition) {
        this.sortByPosition = newSortByPosition;
    }
}

