/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.Util;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPSchemaBibtex
extends XMPSchema {
    public static final String NAMESPACE = "http://jabref.sourceforge.net/bibteXMP/";
    public static final String KEY = "bibtex";
    public static HashSet<String> preserveWhiteSpace = new HashSet();

    public XMPSchemaBibtex(XMPMetadata parent) {
        super(parent, KEY, NAMESPACE);
    }

    public XMPSchemaBibtex(Element e, String namespace) {
        super(e, KEY);
    }

    protected String makeProperty(String propertyName) {
        return "bibtex:" + propertyName;
    }

    public List<String> getPersonList(String field) {
        return this.getSequenceList(field);
    }

    public void setPersonList(String field, String value) {
        AuthorList list = AuthorList.getAuthorList(value);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addSequenceValue(field, list.getAuthor(i).getFirstLast(false));
        }
    }

    @Override
    public String getTextProperty(String field) {
        return super.getTextProperty(this.makeProperty(field));
    }

    @Override
    public void setTextProperty(String field, String value) {
        super.setTextProperty(this.makeProperty(field), value);
    }

    @Override
    public List<String> getBagList(String bagName) {
        return super.getBagList(this.makeProperty(bagName));
    }

    @Override
    public void removeBagValue(String bagName, String value) {
        super.removeBagValue(this.makeProperty(bagName), value);
    }

    @Override
    public void addBagValue(String bagName, String value) {
        super.addBagValue(this.makeProperty(bagName), value);
    }

    @Override
    public List<String> getSequenceList(String seqName) {
        return super.getSequenceList(this.makeProperty(seqName));
    }

    @Override
    public void removeSequenceValue(String seqName, String value) {
        super.removeSequenceValue(this.makeProperty(seqName), value);
    }

    @Override
    public void addSequenceValue(String seqName, String value) {
        super.addSequenceValue(this.makeProperty(seqName), value);
    }

    @Override
    public List<String> getSequenceDateList(String seqName) throws IOException {
        return super.getSequenceDateList(this.makeProperty(seqName));
    }

    @Override
    public void removeSequenceDateValue(String seqName, Calendar date) {
        super.removeSequenceDateValue(this.makeProperty(seqName), date);
    }

    @Override
    public void addSequenceDateValue(String field, Calendar date) {
        super.addSequenceDateValue(this.makeProperty(field), date);
    }

    public static String getContents(NodeList seqList) {
        Element seqNode = (Element)seqList.item(0);
        StringBuffer seq = null;
        NodeList items = seqNode.getElementsByTagName("rdf:li");
        for (int j = 0; j < items.getLength(); ++j) {
            Element li = (Element)items.item(j);
            if (seq == null) {
                seq = new StringBuffer();
            } else {
                seq.append(" and ");
            }
            seq.append(XMPSchemaBibtex.getTextContent(li));
        }
        if (seq != null) {
            return seq.toString();
        }
        return null;
    }

    public static Map<String, String> getAllProperties(XMPSchema schema, String namespaceName) {
        NodeList nodes = schema.getElement().getChildNodes();
        HashMap<String, String> result = new HashMap<String, String>();
        if (nodes == null) {
            return result;
        }
        int n = nodes.getLength();
        for (int i = 0; i < n; ++i) {
            String nodeName;
            String[] stringArray;
            Node node = nodes.item(i);
            if (node.getNodeType() != 2 && node.getNodeType() != 1 || (stringArray = (nodeName = node.getNodeName()).split(":")).length != 2 || !stringArray[0].equals(namespaceName)) continue;
            NodeList seqList = ((Element)node).getElementsByTagName("rdf:Seq");
            if (seqList.getLength() > 0) {
                String seq = XMPSchemaBibtex.getContents(seqList);
                if (seq == null) continue;
                result.put(stringArray[1], seq);
                continue;
            }
            NodeList bagList = ((Element)node).getElementsByTagName("rdf:Bag");
            if (bagList.getLength() > 0) {
                String seq = XMPSchemaBibtex.getContents(bagList);
                if (seq == null) continue;
                result.put(stringArray[1], seq);
                continue;
            }
            result.put(stringArray[1], XMPSchemaBibtex.getTextContent(node));
        }
        NamedNodeMap attrs = schema.getElement().getAttributes();
        int m = attrs.getLength();
        for (int j = 0; j < m; ++j) {
            Node node = attrs.item(j);
            String nodeName = node.getNodeName();
            String[] split = nodeName.split(":");
            if (split.length != 2 || !split[0].equals(namespaceName)) continue;
            result.put(split[1], node.getNodeValue());
        }
        for (Map.Entry entry : result.entrySet()) {
            String key = (String)entry.getKey();
            if (preserveWhiteSpace.contains(key)) continue;
            entry.setValue(((String)entry.getValue()).replaceAll("\\s+", " ").trim());
        }
        return result;
    }

    public void setBibtexEntry(BibtexEntry entry) {
        this.setBibtexEntry(entry, null);
    }

    public void setBibtexEntry(BibtexEntry entry, BibtexDatabase database) {
        Set<String> fields = entry.getAllFields();
        JabRefPreferences prefs = JabRefPreferences.getInstance();
        if (prefs.getBoolean("useXmpPrivacyFilter")) {
            TreeSet<String> filters = new TreeSet<String>(Arrays.asList(prefs.getStringArray("xmpPrivacyFilters")));
            fields.removeAll(filters);
        }
        for (String field : fields) {
            String value = BibtexDatabase.getResolvedField(field, entry, database);
            if (field.equals("author") || field.equals("editor")) {
                this.setPersonList(field, value);
                continue;
            }
            this.setTextProperty(field, value);
        }
        this.setTextProperty("entrytype", entry.getType().getName());
    }

    public BibtexEntry getBibtexEntry() {
        String type = this.getTextProperty("entrytype");
        BibtexEntryType t = type != null ? BibtexEntryType.getStandardType(type) : BibtexEntryType.OTHER;
        BibtexEntry e = new BibtexEntry(Util.createNeutralId(), t);
        Map<String, String> text = XMPSchemaBibtex.getAllProperties(this, KEY);
        text.remove("entrytype");
        e.setField(text);
        return e;
    }

    public static String getTextContent(Node node) {
        boolean hasTextContent = false;
        StringBuffer buffer = new StringBuffer();
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 3) continue;
            buffer.append(child.getNodeValue());
            hasTextContent = true;
        }
        return hasTextContent ? buffer.toString() : "";
    }

    static {
        preserveWhiteSpace.add("abstract");
        preserveWhiteSpace.add("note");
        preserveWhiteSpace.add("review");
    }
}

