/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.sql.DBStrings;

public class DBConnectDialog
extends JDialog {
    JLabel lblServerType = new JLabel();
    JLabel lblServerHostname = new JLabel();
    JLabel lblDatabase = new JLabel();
    JLabel lblUsername = new JLabel();
    JLabel lblPassword = new JLabel();
    JComboBox cmbServerType = new JComboBox();
    JTextField txtServerHostname = new JTextField(40);
    JTextField txtDatabase = new JTextField(40);
    JTextField txtUsername = new JTextField(40);
    JPasswordField pwdPassword = new JPasswordField(40);
    JButton btnConnect = new JButton();
    JButton btnCancel = new JButton();
    ArrayList<JLabel> lhs = new ArrayList();
    ArrayList<JComponent> rhs = new ArrayList();
    DBStrings dbStrings = new DBStrings();
    private boolean connectToDB = false;

    public DBConnectDialog(JFrame parent, DBStrings dbs) {
        super(parent, Globals.lang("Connect to SQL Database"), true);
        this.setResizable(false);
        this.setLocationRelativeTo(parent);
        this.dbStrings = dbs;
        this.lhs.add(this.lblServerType);
        this.lhs.add(this.lblServerHostname);
        this.lhs.add(this.lblDatabase);
        this.lhs.add(this.lblUsername);
        this.lhs.add(this.lblPassword);
        this.rhs.add(this.cmbServerType);
        this.rhs.add(this.txtServerHostname);
        this.rhs.add(this.txtDatabase);
        this.rhs.add(this.txtUsername);
        this.rhs.add(this.pwdPassword);
        this.lblServerType.setText(Globals.lang("Server Type :"));
        this.lblServerHostname.setText(Globals.lang("Server Hostname :"));
        this.lblDatabase.setText(Globals.lang("Database :"));
        this.lblUsername.setText(Globals.lang("Username :"));
        this.lblPassword.setText(Globals.lang("Password :"));
        for (JLabel label : this.lhs) {
            label.setHorizontalAlignment(4);
        }
        this.btnConnect.setText(Globals.lang("Connect"));
        this.btnCancel.setText(Globals.lang("Cancel"));
        String[] srv = this.dbStrings.getServerTypes();
        for (int i = 0; i < srv.length; ++i) {
            this.cmbServerType.addItem(srv[i]);
        }
        this.txtServerHostname.setText(this.dbStrings.getServerHostname());
        this.txtDatabase.setText(this.dbStrings.getDatabase());
        this.txtUsername.setText(this.dbStrings.getUsername());
        this.pwdPassword.setText(this.dbStrings.getPassword());
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("right:pref, 4dlu, fill:pref", ""));
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        builder.append(this.lblServerType);
        builder.append(this.cmbServerType);
        builder.nextLine();
        builder.append(this.lblServerHostname);
        builder.append(this.txtServerHostname);
        builder.nextLine();
        builder.append(this.lblDatabase);
        builder.append(this.txtDatabase);
        builder.nextLine();
        builder.append(this.lblUsername);
        builder.append(this.txtUsername);
        builder.nextLine();
        builder.append(this.lblPassword);
        builder.append(this.pwdPassword);
        builder.nextLine();
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addGridded(this.btnConnect);
        bb.addGridded(this.btnCancel);
        bb.addGlue();
        this.getContentPane().add((Component)bb.getPanel(), "South");
        this.pack();
        ActionListener connectAction = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String errorMessage = DBConnectDialog.this.checkInput();
                if (errorMessage == null) {
                    DBConnectDialog.this.storeSettings();
                    DBConnectDialog.this.setVisible(false);
                    DBConnectDialog.this.setConnectToDB(true);
                } else {
                    JOptionPane.showMessageDialog(null, errorMessage, "Input Error", 0);
                }
            }
        };
        this.btnConnect.addActionListener(connectAction);
        this.txtDatabase.addActionListener(connectAction);
        this.txtServerHostname.addActionListener(connectAction);
        this.txtUsername.addActionListener(connectAction);
        this.pwdPassword.addActionListener(connectAction);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBConnectDialog.this.setVisible(false);
                DBConnectDialog.this.dispose();
                DBConnectDialog.this.setConnectToDB(false);
            }
        });
    }

    private String checkInput() {
        String[] fields = new String[]{"Server Hostname", "Database", "Username"};
        String[] errors = new String[fields.length];
        int cnt = 0;
        if (this.txtServerHostname.getText().trim().equals("")) {
            errors[cnt] = fields[0];
            ++cnt;
        }
        if (this.txtDatabase.getText().trim().equals("")) {
            errors[cnt] = fields[1];
            ++cnt;
        }
        if (this.txtUsername.getText().trim().equals("")) {
            errors[cnt] = fields[2];
            ++cnt;
        }
        String errMsg = Globals.lang("Please specify the ");
        switch (cnt) {
            case 0: {
                errMsg = null;
                break;
            }
            case 1: {
                errMsg = errMsg + errors[0] + ".";
                break;
            }
            case 2: {
                errMsg = errMsg + errors[0] + " and " + errors[1] + ".";
                break;
            }
            case 3: {
                errMsg = errMsg + errors[0] + ", " + errors[1] + ", and " + errors[2] + ".";
                break;
            }
        }
        return errMsg;
    }

    private void storeSettings() {
        this.dbStrings.setServerType(this.cmbServerType.getSelectedItem().toString());
        this.dbStrings.setServerHostname(this.txtServerHostname.getText());
        this.dbStrings.setDatabase(this.txtDatabase.getText());
        this.dbStrings.setUsername(this.txtUsername.getText());
        char[] pwd = this.pwdPassword.getPassword();
        String tmp = "";
        for (int i = 0; i < pwd.length; ++i) {
            tmp = tmp + pwd[i];
        }
        this.dbStrings.setPassword(tmp);
        tmp = "";
        Arrays.fill(pwd, '0');
    }

    public DBStrings getDBStrings() {
        return this.dbStrings;
    }

    public void setDBStrings(DBStrings dbStrings) {
        this.dbStrings = dbStrings;
    }

    public boolean getConnectToDB() {
        return this.connectToDB;
    }

    public void setConnectToDB(boolean connectToDB) {
        this.connectToDB = connectToDB;
    }
}

