/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.SearchRule;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSearch
implements SearchRule {
    private boolean caseSensitive;
    private boolean regExp;
    Pattern[] pattern;
    static RemoveLatexCommands removeBrackets = new RemoveLatexCommands();

    public BasicSearch(boolean caseSensitive, boolean regExp) {
        this.caseSensitive = caseSensitive;
        this.regExp = regExp;
    }

    public int applyRule(String query, BibtexEntry bibtexEntry) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1", query);
        return this.applyRule(map, bibtexEntry);
    }

    @Override
    public int applyRule(Map<String, String> searchStrings, BibtexEntry bibtexEntry) {
        int flags = 0;
        String searchString = searchStrings.values().iterator().next();
        if (!this.caseSensitive) {
            searchString = searchString.toLowerCase();
            flags = 2;
        }
        ArrayList<String> words = this.parseQuery(searchString);
        if (this.regExp) {
            this.pattern = new Pattern[words.size()];
            for (int i = 0; i < this.pattern.length; ++i) {
                this.pattern[i] = Pattern.compile(words.get(i), flags);
            }
        }
        boolean[] matchFound = new boolean[words.size()];
        for (String field : bibtexEntry.getAllFields()) {
            String fieldContentAsObject = bibtexEntry.getField(field);
            if (fieldContentAsObject == null) continue;
            String fieldContent = removeBrackets.format(fieldContentAsObject.toString());
            if (!this.caseSensitive) {
                fieldContent = fieldContent.toLowerCase();
            }
            int index = 0;
            for (int j = 0; j < words.size(); ++j) {
                if (!this.regExp) {
                    String s = words.get(j);
                    matchFound[index] = matchFound[index] || fieldContent.indexOf(s) >= 0;
                } else if (fieldContent != null) {
                    Matcher m = this.pattern[j].matcher(removeBrackets.format(fieldContent));
                    matchFound[index] = matchFound[index] || m.find();
                }
                ++index;
            }
        }
        for (int i = 0; i < matchFound.length; ++i) {
            if (matchFound[i]) continue;
            return 0;
        }
        return 1;
    }

    private ArrayList<String> parseQuery(String query) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> result = new ArrayList<String>();
        boolean escaped = false;
        boolean quoted = false;
        for (int i = 0; i < query.length(); ++i) {
            char c = query.charAt(i);
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && !quoted && Character.isWhitespace(c)) {
                if (sb.length() > 0) {
                    result.add(sb.toString());
                    sb = new StringBuffer();
                }
            } else if (c == '\"') {
                if (sb.length() > 0) {
                    result.add(sb.toString());
                    sb = new StringBuffer();
                }
                quoted = !quoted;
            } else {
                sb.append(c);
            }
            escaped = false;
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
        }
        return result;
    }
}

