/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.TreeSet;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.imports.ImportFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomImportList
extends TreeSet<Importer> {
    private JabRefPreferences prefs;

    public CustomImportList(JabRefPreferences prefs) {
        this.prefs = prefs;
        this.readPrefs();
    }

    private void readPrefs() {
        int i = 0;
        String[] s = null;
        while ((s = this.prefs.getStringArray("customImportFormat" + i)) != null) {
            try {
                super.add(new Importer(s));
            }
            catch (Exception e) {
                System.err.println("Warning! Could not load " + s[0] + " from preferences. Will ignore.");
            }
            ++i;
        }
    }

    public void addImporter(Importer customImporter) {
        super.add(customImporter);
    }

    public boolean replaceImporter(Importer customImporter) {
        boolean wasContained = this.remove(customImporter);
        this.addImporter(customImporter);
        return wasContained;
    }

    public void store() {
        this.purgeAll();
        Importer[] importers = this.toArray(new Importer[0]);
        for (int i = 0; i < importers.length; ++i) {
            Globals.prefs.putStringArray("customImportFormat" + i, importers[i].getAsStringArray());
        }
    }

    private void purgeAll() {
        int i = 0;
        while (Globals.prefs.getStringArray("customImportFormat" + i) != null) {
            Globals.prefs.remove("customImportFormat" + i);
            ++i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Importer
    implements Comparable<Importer> {
        private String name;
        private String cliId;
        private String className;
        private String basePath;

        public Importer() {
        }

        public Importer(String[] data) {
            this.name = data[0];
            this.cliId = data[1];
            this.className = data[2];
            this.basePath = data[3];
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getClidId() {
            return this.cliId;
        }

        public void setCliId(String cliId) {
            this.cliId = cliId;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public File getBasePath() {
            return new File(this.basePath);
        }

        public URL getBasePathUrl() throws MalformedURLException {
            return this.getBasePath().toURI().toURL();
        }

        public String[] getAsStringArray() {
            return new String[]{this.name, this.cliId, this.className, this.basePath};
        }

        public boolean equals(Object o) {
            return o != null && o instanceof Importer && this.getName().equals(((Importer)o).getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(Importer o) {
            return this.getName().compareTo(o.getName());
        }

        public String toString() {
            return this.name;
        }

        public ImportFormat getInstance() throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            URLClassLoader cl = new URLClassLoader(new URL[]{this.getBasePathUrl()});
            Class<?> clazz = Class.forName(this.className, true, cl);
            ImportFormat importFormat = (ImportFormat)clazz.newInstance();
            importFormat.setIsCustomImporter(true);
            return importFormat;
        }
    }
}

