/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.imports.BooleanAssign;
import net.sf.jabref.imports.CiteSeerCitationHandler;
import net.sf.jabref.imports.CiteSeerUndoHandler;
import net.sf.jabref.undo.NamedCompound;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CiteSeerFetcher
extends SidePaneComponent {
    static final String CITESEER_HOST = "citeseer.ist.psu.edu";
    static final String PREFIX_URL = "http://citeseer.ist.psu.edu/";
    static final String PREFIX_IDENTIFIER = "oai:CiteSeerPSU:";
    static final String OAI_HOST = "http://cs1.ist.psu.edu/";
    static final String OAI_URL = "http://cs1.ist.psu.edu/cgi-bin/oai.cgi?";
    static final String OAI_ACTION = "verb=GetRecord";
    static final String OAI_METADATAPREFIX = "metadataPrefix=oai_citeseer";
    protected SAXParserFactory parserFactory;
    protected SAXParser saxParser;
    boolean citationFetcherActive;
    boolean importFetcherActive;
    JProgressBar progressBar;
    JProgressBar progressBar2;
    JLabel citeSeerProgress;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    SidePaneManager sidePaneManager;

    public CiteSeerFetcher(SidePaneManager p0) {
        super(p0, GUIGlobals.getIconUrl("citeseer"), Globals.lang("CiteSeer Transfer"));
        this.sidePaneManager = p0;
        this.progressBar = new JProgressBar();
        this.progressBar2 = new JProgressBar();
        this.citeSeerProgress = new JLabel();
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setStringPainted(true);
        this.progressBar2.setValue(0);
        this.progressBar2.setMinimum(0);
        this.progressBar2.setMaximum(100);
        this.progressBar2.setStringPainted(true);
        JPanel main = new JPanel();
        main.setLayout(this.gbl);
        this.con.gridwidth = 0;
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 2;
        this.gbl.setConstraints(this.progressBar, this.con);
        main.add(this.progressBar);
        this.gbl.setConstraints(this.progressBar2, this.con);
        main.add(this.progressBar2);
        this.gbl.setConstraints(this.citeSeerProgress, this.con);
        main.add(this.citeSeerProgress);
        main.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)main, "Center");
        try {
            this.citationFetcherActive = false;
            this.importFetcherActive = false;
            this.parserFactory = SAXParserFactory.newInstance();
            this.saxParser = this.parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public ShowEmptyFetchSetDialog getEmptyFetchSetDialog() {
        return new ShowEmptyFetchSetDialog();
    }

    public synchronized boolean activateCitationFetcher() {
        if (this.citationFetcherActive) {
            return false;
        }
        this.citationFetcherActive = true;
        return true;
    }

    public synchronized void deactivateCitationFetcher() {
        this.citationFetcherActive = false;
    }

    public synchronized boolean activateImportFetcher() {
        if (this.importFetcherActive) {
            return false;
        }
        this.importFetcherActive = true;
        return true;
    }

    public synchronized void deactivateImportFetcher() {
        this.importFetcherActive = false;
    }

    public void beginImportCiteSeerProgress() {
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString("");
        this.progressBar2.setVisible(false);
        this.citeSeerProgress.setText("");
        this.sidePaneManager.show("CiteSeerProgress");
    }

    public void endImportCiteSeerProgress() {
        this.progressBar.setIndeterminate(false);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(100);
        this.progressBar.setValue(100);
    }

    public int populate(BibtexDatabase newDatabase, BibtexDatabase targetDatabase) {
        int errorCode = 0;
        Iterator<String> targetIterator = targetDatabase.getKeySet().iterator();
        boolean abortOperation = false;
        HashMap<String, Boolean> citationHashTable = new HashMap<String, Boolean>();
        Hashtable<Integer, BibtexEntry> rejectedEntries = new Hashtable<Integer, BibtexEntry>();
        InitializeProgressBar initializeProgressBar = new InitializeProgressBar();
        InitializeProgressBarTwo initializeProgressBarTwo = new InitializeProgressBarTwo();
        UpdateProgressBarMaximum updateMaximum = new UpdateProgressBarMaximum(targetDatabase.getEntryCount());
        this.progressBar2.setVisible(true);
        SwingUtilities.invokeLater(initializeProgressBar);
        SwingUtilities.invokeLater(initializeProgressBarTwo);
        SwingUtilities.invokeLater(updateMaximum);
        int identifierCounter = 0;
        UpdateProgressStatus progressStatus = new UpdateProgressStatus(Globals.lang("Fetching Identifiers"));
        SwingUtilities.invokeLater(progressStatus);
        while (targetIterator.hasNext() && !abortOperation) {
            String currentKey = targetIterator.next();
            BibtexEntry currentEntry = targetDatabase.getEntryById(currentKey);
            abortOperation = this.generateIdentifierList(currentEntry, citationHashTable, rejectedEntries);
            UpdateProgressBarValue updateValue = new UpdateProgressBarValue(++identifierCounter);
            SwingUtilities.invokeLater(updateValue);
        }
        if (rejectedEntries.size() > 0) {
            errorCode = -1;
            ShowBadIdentifiersDialog badIdentifiersDialog = new ShowBadIdentifiersDialog(rejectedEntries);
            SwingUtilities.invokeLater(badIdentifiersDialog);
        }
        if (citationHashTable.size() > 0) {
            UpdateProgressBarTwoMaximum update2Maximum = new UpdateProgressBarTwoMaximum(citationHashTable.size());
            SwingUtilities.invokeLater(update2Maximum);
        }
        progressStatus = new UpdateProgressStatus(Globals.lang("Fetching Citations"));
        SwingUtilities.invokeLater(progressStatus);
        this.generateCitationList(citationHashTable, newDatabase);
        progressStatus = new UpdateProgressStatus(Globals.lang("Done"));
        SwingUtilities.invokeLater(progressStatus);
        if (abortOperation) {
            errorCode = -2;
        }
        return errorCode;
    }

    private Map<String, Boolean> generateCitationList(Map<String, Boolean> citationHashTable, BibtexDatabase database) {
        try {
            NamedCompound dummyNamedCompound = new NamedCompound(Globals.lang("Import Data from CiteSeer Database"));
            BooleanAssign dummyBoolean = new BooleanAssign(false);
            if (citationHashTable != null && citationHashTable.size() > 0) {
                int citationCounter = 0;
                for (String key : citationHashTable.keySet()) {
                    String id = Util.createNeutralId();
                    BibtexEntry newEntry = new BibtexEntry(id);
                    StringBuffer citeseerURLString = new StringBuffer();
                    citeseerURLString.append(OAI_URL);
                    citeseerURLString.append(OAI_ACTION);
                    citeseerURLString.append("&metadataPrefix=oai_citeseer");
                    citeseerURLString.append("&identifier=").append(key);
                    URL citeseerUrl = new URL(citeseerURLString.toString());
                    HttpURLConnection citeseerConnection = (HttpURLConnection)citeseerUrl.openConnection();
                    this.saxParser.parse(citeseerConnection.getInputStream(), (DefaultHandler)new CiteSeerUndoHandler(dummyNamedCompound, newEntry, this.panel, dummyBoolean));
                    database.insertEntry(newEntry);
                    UpdateProgressBarTwoValue updateValue = new UpdateProgressBarTwoValue(++citationCounter);
                    SwingUtilities.invokeLater(updateValue);
                }
            }
        }
        catch (SAXException e) {
            System.out.println("SAXException: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            ShowNoConnectionDialog dialog = new ShowNoConnectionDialog(OAI_HOST);
            SwingUtilities.invokeLater(dialog);
        }
        catch (KeyCollisionException e) {
            System.out.println("KeyCollisionException: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        return citationHashTable;
    }

    public static String generateCanonicalNumber(BibtexEntry be) {
        return CiteSeerFetcher.generateCanonicalNumber(be.getField("citeseerurl"));
    }

    public static String generateCanonicalNumber(String link) {
        Pattern pattern;
        Matcher matcher;
        String IDnumber = null;
        if (link != null && (matcher = (pattern = Pattern.compile("[0-9]+")).matcher(link)).find()) {
            IDnumber = matcher.group();
        }
        return IDnumber;
    }

    public String generateCanonicalIdentifier(BibtexEntry be) {
        String canonID = null;
        String IDnumber = CiteSeerFetcher.generateCanonicalNumber(be);
        if (IDnumber != null) {
            canonID = PREFIX_IDENTIFIER + IDnumber;
        }
        return canonID;
    }

    public static String generateCanonicalURL(String link) {
        String canonURL = null;
        String IDnumber = CiteSeerFetcher.generateCanonicalNumber(link);
        if (IDnumber != null) {
            canonURL = PREFIX_URL + IDnumber + ".html";
        }
        return canonURL;
    }

    public static String generateCanonicalURL(BibtexEntry be) {
        return CiteSeerFetcher.generateCanonicalURL(be.getField("citeseerurl"));
    }

    private boolean generateIdentifierList(BibtexEntry currentEntry, Map<String, Boolean> citationHashTable, Hashtable<Integer, BibtexEntry> rejectedEntries) {
        boolean abortOperation = false;
        String identifier = this.generateCanonicalIdentifier(currentEntry);
        try {
            if (identifier != null) {
                StringBuffer citeseerURLString = new StringBuffer();
                citeseerURLString.append(OAI_URL);
                citeseerURLString.append(OAI_ACTION);
                citeseerURLString.append("&metadataPrefix=oai_citeseer");
                citeseerURLString.append("&identifier=").append(identifier);
                URL citeseerUrl = new URL(citeseerURLString.toString());
                HttpURLConnection citeseerConnection = (HttpURLConnection)citeseerUrl.openConnection();
                this.saxParser.parse(citeseerConnection.getInputStream(), (DefaultHandler)new CiteSeerCitationHandler(citationHashTable));
            } else {
                int row = this.panel.mainTable.findEntry(currentEntry);
                rejectedEntries.put(new Integer(row + 1), currentEntry);
            }
        }
        catch (SAXException e) {
            System.out.println("SAXException: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IOException: " + e.getLocalizedMessage());
            ShowNoConnectionDialog dialog = new ShowNoConnectionDialog(OAI_HOST);
            abortOperation = true;
            SwingUtilities.invokeLater(dialog);
        }
        return abortOperation;
    }

    public boolean importCiteSeerEntries(int[] clickedOn, NamedCompound citeseerNamedCompound) {
        boolean newValues = false;
        boolean abortOperation = false;
        Vector<Integer> clickedVector = new Vector<Integer>();
        Hashtable<Integer, BibtexEntry> rejectedEntries = new Hashtable<Integer, BibtexEntry>();
        for (int i = 0; i < clickedOn.length; ++i) {
            clickedVector.add(new Integer(clickedOn[i]));
        }
        Iterator clickedIterator = clickedVector.iterator();
        BooleanAssign overwriteAll = new BooleanAssign(false);
        BooleanAssign overwriteNone = new BooleanAssign(false);
        while (clickedIterator.hasNext() && !abortOperation) {
            int currentIndex = (Integer)clickedIterator.next();
            BooleanAssign newValue = new BooleanAssign(false);
            BibtexEntry be = this.panel.mainTable.getEntryAt(currentIndex);
            abortOperation = this.importCiteSeerEntry(be, citeseerNamedCompound, overwriteAll, overwriteNone, newValue, rejectedEntries);
            if (!newValue.getValue()) continue;
            newValues = true;
        }
        if (rejectedEntries.size() > 0) {
            ShowBadIdentifiersDialog badIdentifiersDialog = new ShowBadIdentifiersDialog(rejectedEntries);
            SwingUtilities.invokeLater(badIdentifiersDialog);
        }
        return newValues;
    }

    public boolean importCiteSeerEntry(BibtexEntry be, NamedCompound citeseerNC, BooleanAssign overwriteAll, BooleanAssign overwriteNone, BooleanAssign newValue, Hashtable<Integer, BibtexEntry> rejectedEntries) {
        boolean abortOperation = false;
        String identifier = this.generateCanonicalIdentifier(be);
        try {
            if (identifier != null) {
                StringBuffer citeseerURLString = new StringBuffer();
                citeseerURLString.append(OAI_URL);
                citeseerURLString.append(OAI_ACTION);
                citeseerURLString.append("&metadataPrefix=oai_citeseer");
                citeseerURLString.append("&identifier=").append(identifier);
                URL citeseerUrl = new URL(citeseerURLString.toString());
                HttpURLConnection citeseerConnection = (HttpURLConnection)citeseerUrl.openConnection();
                InputStream inputStream = citeseerConnection.getInputStream();
                CiteSeerUndoHandler handlerBase = new CiteSeerUndoHandler(citeseerNC, be, this.panel, newValue, overwriteAll, overwriteNone);
                this.saxParser.parse(inputStream, (DefaultHandler)handlerBase);
            } else {
                int row = this.panel.mainTable.findEntry(be);
                rejectedEntries.put(new Integer(row + 1), be);
            }
        }
        catch (IOException e) {
            ShowNoConnectionDialog dialog = new ShowNoConnectionDialog(OAI_HOST);
            SwingUtilities.invokeLater(dialog);
            abortOperation = true;
        }
        catch (SAXException e) {
            System.out.println("SAXException: " + e.getLocalizedMessage());
            e.printStackTrace();
            abortOperation = true;
        }
        return abortOperation;
    }

    class UpdateProgressStatus
    implements Runnable {
        protected String status;

        UpdateProgressStatus(String newStatus) {
            this.status = newStatus;
        }

        public void run() {
            CiteSeerFetcher.this.citeSeerProgress.setText(this.status);
        }
    }

    class UpdateProgressBarTwoValue
    implements Runnable {
        protected int counter;

        UpdateProgressBarTwoValue(int newValue) {
            this.counter = newValue;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar2.setValue(this.counter);
        }
    }

    class UpdateProgressBarValue
    implements Runnable {
        protected int counter;

        UpdateProgressBarValue(int newValue) {
            this.counter = newValue;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar.setValue(this.counter);
        }
    }

    class InitializeProgressBarTwo
    implements Runnable {
        InitializeProgressBarTwo() {
        }

        public void run() {
            CiteSeerFetcher.this.progressBar2.setValue(0);
            CiteSeerFetcher.this.progressBar2.setMinimum(0);
            CiteSeerFetcher.this.progressBar2.setMaximum(100);
            CiteSeerFetcher.this.progressBar2.setString(null);
        }
    }

    class InitializeProgressBar
    implements Runnable {
        InitializeProgressBar() {
        }

        public void run() {
            CiteSeerFetcher.this.progressBar.setValue(0);
            CiteSeerFetcher.this.progressBar.setMinimum(0);
            CiteSeerFetcher.this.progressBar.setMaximum(100);
            CiteSeerFetcher.this.progressBar.setString(null);
        }
    }

    class UpdateProgressBarTwoMaximum
    implements Runnable {
        protected int maximum;

        UpdateProgressBarTwoMaximum(int newValue) {
            this.maximum = newValue;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar2.setMaximum(this.maximum);
        }
    }

    class UpdateProgressBarMaximum
    implements Runnable {
        protected int maximum;

        UpdateProgressBarMaximum(int newValue) {
            this.maximum = newValue;
        }

        public void run() {
            CiteSeerFetcher.this.progressBar.setMaximum(this.maximum);
        }
    }

    class ShowMissingURLDialog
    implements Runnable {
        protected int rowNumber;

        ShowMissingURLDialog(int row) {
            this.rowNumber = row;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("The URL field appears to be empty on entry number ") + (this.rowNumber + 1) + ".  " + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    class ShowBadURLDialog
    implements Runnable {
        protected String badURL = "";
        protected int rowNumber;

        ShowBadURLDialog(String URL2, int row) {
            this.badURL = URL2;
            this.rowNumber = row;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Unable to parse the following URL") + ": \"" + this.badURL + '\"' + Globals.lang(" on entry number ") + (this.rowNumber + 1) + ".  " + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    class ShowBadIdentifierDialog
    implements Runnable {
        protected String badURL = "";
        protected int rowNumber;

        ShowBadIdentifierDialog(String URL2, int row) {
            this.badURL = URL2;
            this.rowNumber = row;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Couldn't find an entry associated with this URL") + ": \"" + this.badURL + '\"' + Globals.lang(" on entry number ") + (this.rowNumber + 1) + ".  " + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowBadIdentifiersDialog
    implements Runnable {
        Hashtable<Integer, BibtexEntry> rejectedEntries;

        ShowBadIdentifiersDialog(Hashtable<Integer, BibtexEntry> entries) {
            this.rejectedEntries = entries;
        }

        @Override
        public void run() {
            if (this.rejectedEntries.size() != 1 && this.rejectedEntries.size() > 1) {
                int i;
                String rowNumbers = "";
                String oneRowOfNumbers = "";
                TreeSet<Integer> rowSet = new TreeSet<Integer>(this.rejectedEntries.keySet());
                int rowSize = rowSet.size();
                for (i = 0; i < rowSize - 1 && i < 100; ++i) {
                    Integer next = rowSet.first();
                    if (oneRowOfNumbers.equals("")) {
                        oneRowOfNumbers = next.toString();
                    } else {
                        if ((oneRowOfNumbers = oneRowOfNumbers + ", ").length() > 50) {
                            oneRowOfNumbers = oneRowOfNumbers + "\n";
                            rowNumbers = rowNumbers + oneRowOfNumbers;
                            oneRowOfNumbers = "";
                        }
                        oneRowOfNumbers = oneRowOfNumbers + next.toString();
                    }
                    rowSet.remove(next);
                }
                rowNumbers = rowNumbers + oneRowOfNumbers;
                rowNumbers = i == 100 ? rowNumbers + ".." : rowNumbers + " " + Globals.lang("and") + " " + rowSet.first().toString();
                JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Couldn't parse the 'citeseerurl' field of the following entries") + ':' + '\n' + rowNumbers + ".\n" + Globals.lang("Please refer to the JabRef help manual on using the CiteSeer tools."), Globals.lang("Warning"), 2);
            }
        }
    }

    class ShowNoConnectionDialog
    implements Runnable {
        protected String targetURL = "";

        ShowNoConnectionDialog(String URL2) {
            this.targetURL = URL2;
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("Could not connect to host") + " " + this.targetURL + ".  " + Globals.lang("Please check your network connection to this machine."), Globals.lang("CiteSeer Error"), 0);
        }
    }

    class ShowEmptyFetchSetDialog
    implements Runnable {
        ShowEmptyFetchSetDialog() {
        }

        public void run() {
            JOptionPane.showMessageDialog(CiteSeerFetcher.this.panel.frame(), Globals.lang("The CiteSeer fetch operation returned zero results."), "CiteSeer", 1);
            CiteSeerFetcher.this.deactivateCitationFetcher();
        }
    }
}

