/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.GridLayout;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;

public class ACMPortalFetcher
implements EntryFetcher {
    ImportInspector dialog = null;
    OutputPrinter status;
    final HTMLConverter htmlConverter = new HTMLConverter();
    private String terms;
    String startUrl = "http://portal.acm.org/";
    String searchUrlPart = "results.cfm?query=";
    String searchUrlPartII = "&dl=";
    String endUrl = "&coll=Portal&short=0";
    private JRadioButton acmButton = new JRadioButton(Globals.lang("The ACM Digital Library"));
    private JRadioButton guideButton = new JRadioButton(Globals.lang("The Guide to Computing Literature"));
    private JCheckBox absCheckBox = new JCheckBox(Globals.lang("Include abstracts"), false);
    private static final int MAX_FETCH = 20;
    private int perPage = 20;
    private int hits = 0;
    private int unparseable = 0;
    private int parsed = 0;
    private boolean shouldContinue = false;
    private boolean fetchAbstract = false;
    private boolean acmOrGuide = false;
    Pattern hitsPattern = Pattern.compile(".*Found <b>(\\d+,*\\d*)</b> of.*");
    Pattern maxHitsPattern = Pattern.compile(".*Results \\d+ - \\d+ of (\\d+,*\\d*).*");
    Pattern bibPattern = Pattern.compile(".*(popBibTex.cfm.*)','BibTex'.*");
    Pattern absPattern = Pattern.compile(".*ABSTRACT</A></span>\\s+<p class=\"abstract\">\\s+(.*)");
    Pattern fullCitationPattern = Pattern.compile("<A HREF=\"(citation.cfm.*)\" class.*");
    int piv = 0;

    public JPanel getOptionsPanel() {
        JPanel pan = new JPanel();
        pan.setLayout(new GridLayout(0, 1));
        this.guideButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.acmButton);
        group.add(this.guideButton);
        pan.add(this.absCheckBox);
        pan.add(this.acmButton);
        pan.add(this.guideButton);
        return pan;
    }

    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter status) {
        this.dialog = dialog;
        this.status = status;
        this.terms = query;
        this.piv = 0;
        this.shouldContinue = true;
        this.parsed = 0;
        this.unparseable = 0;
        this.acmOrGuide = this.acmButton.isSelected();
        String address = this.makeUrl(0);
        try {
            URL url = new URL(address);
            String page = this.getResults(url);
            this.hits = this.getNumberOfHits(page, "Found", this.hitsPattern);
            int index = page.indexOf("Found");
            if (index >= 0 && (index = (page = page.substring(index + 5)).indexOf("Found")) >= 0) {
                page = page.substring(index);
            }
            if (this.hits == 0) {
                status.showMessage(Globals.lang("No entries found for the search string '%0'", this.terms), Globals.lang("Search ACM Portal"), 1);
                return false;
            }
            int maxHits = this.getNumberOfHits(page, "Results", this.maxHitsPattern);
            if (this.hits > maxHits) {
                this.hits = maxHits;
            }
            if (this.hits > 20) {
                status.showMessage(Globals.lang("%0 entries found. To reduce server load, only %1 will be downloaded. It will be very slow, in order to make ACM happy.", new String[]{String.valueOf(this.hits), String.valueOf(20)}), Globals.lang("Search ACM Portal"), 1);
                this.hits = 20;
            }
            this.fetchAbstract = this.absCheckBox.isSelected();
            this.parse(dialog, page, 0, 1);
            for (int firstEntry = this.perPage; this.shouldContinue && firstEntry < this.hits; firstEntry += this.perPage) {
                address = this.makeUrl(firstEntry);
                page = this.getResults(new URL(address));
                if (!this.shouldContinue) break;
                this.parse(dialog, page, 0, 1 + firstEntry);
            }
            return true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (ConnectException e) {
            status.showMessage(Globals.lang("Connection to ACM Portal failed"), Globals.lang("Search ACM Portal"), 0);
        }
        catch (IOException e) {
            status.showMessage(Globals.lang(e.getMessage()), Globals.lang("Search ACM Portal"), 0);
            e.printStackTrace();
        }
        return false;
    }

    private String makeUrl(int startIndex) {
        StringBuffer sb = new StringBuffer(this.startUrl).append(this.searchUrlPart);
        sb.append(this.terms.replaceAll(" ", "%20"));
        sb.append(this.searchUrlPartII);
        if (this.acmOrGuide) {
            sb.append("ACM");
        } else {
            sb.append("GUIDE");
        }
        sb.append(this.endUrl);
        return sb.toString();
    }

    private void parse(ImportInspector dialog, String text, int startIndex, int firstEntryNumber) {
        BibtexEntry entry;
        this.piv = startIndex;
        int entryNumber = firstEntryNumber;
        while ((entry = this.parseNextEntry(text, this.piv, entryNumber)) != null && this.shouldContinue) {
            if (entry.getField("title") != null) {
                dialog.addEntry(entry);
                dialog.setProgress(this.parsed + this.unparseable, this.hits);
                ++this.parsed;
            }
            ++entryNumber;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                System.err.println(e.getStackTrace());
            }
        }
    }

    private BibtexEntry parseEntryBibTeX(String fullCitation, boolean abs) throws IOException {
        try {
            URL url = new URL(this.startUrl + fullCitation);
            String page = this.getResults(url);
            Thread.sleep(10000L);
            Matcher bibtexAddr = this.bibPattern.matcher(page);
            if (bibtexAddr.find()) {
                URL bibtexUrl = new URL(this.startUrl + bibtexAddr.group(1));
                BufferedReader in = new BufferedReader(new InputStreamReader(bibtexUrl.openStream()));
                ParserResult result = BibtexParser.parse(in);
                in.close();
                Collection<BibtexEntry> item = result.getDatabase().getEntries();
                BibtexEntry entry = item.iterator().next();
                if (abs) {
                    Matcher absMatch = this.absPattern.matcher(page);
                    if (absMatch.find()) {
                        String absBlock = absMatch.group(1);
                        entry.setField("abstract", this.convertHTMLChars(absBlock).trim());
                    } else {
                        System.out.println("No abstract matched.");
                    }
                }
                Thread.sleep(10000L);
                return entry;
            }
            return null;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (ConnectException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BibtexEntry parseNextEntry(String allText, int startIndex, int entryNumber) {
        String toFind = new StringBuffer().append("<strong>").append(entryNumber).append("</strong>").toString();
        int index = allText.indexOf(toFind, startIndex);
        int endIndex = allText.indexOf("</table>", index + 1);
        endIndex = allText.length();
        BibtexEntry entry = null;
        if (index >= 0) {
            this.piv = index + 1;
            String text = allText.substring(index, endIndex);
            Matcher fullCitation = this.fullCitationPattern.matcher(text);
            if (fullCitation.find()) {
                try {
                    Thread.sleep(10000L);
                    entry = this.parseEntryBibTeX(fullCitation.group(1), this.fetchAbstract);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                System.out.printf("Citation Unmatched %d\n", entryNumber);
                System.out.printf(text, new Object[0]);
            }
            if (entry != null) {
                return entry;
            }
        }
        return null;
    }

    private String convertHTMLChars(String text) {
        return this.htmlConverter.format(text);
    }

    private int getNumberOfHits(String page, String marker, Pattern pattern) throws IOException {
        int ind = page.indexOf(marker);
        if (ind < 0) {
            System.out.println(page);
            throw new IOException(Globals.lang("Could not parse number of hits"));
        }
        String substring = page.substring(ind, Math.min(ind + 42, page.length()));
        Matcher m = pattern.matcher(substring);
        if (m.find()) {
            try {
                String number = m.group(1);
                number = number.replaceAll(",", "");
                return Integer.parseInt(number);
            }
            catch (NumberFormatException ex) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
            catch (IllegalStateException e) {
                throw new IOException(Globals.lang("Could not parse number of hits"));
            }
        }
        System.out.println("Unmatched!");
        System.out.println(substring);
        throw new IOException(Globals.lang("Could not parse number of hits"));
    }

    public String getResults(URL source) throws IOException {
        int bytesRead;
        InputStream in = source.openStream();
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = in.read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }

    public String getResultsFromFile(File f) throws IOException {
        int bytesRead;
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[256];
        while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
            for (int i = 0; i < bytesRead; ++i) {
                sb.append((char)buffer[i]);
            }
        }
        return sb.toString();
    }

    public String getTitle() {
        return Globals.menuTitle("Search ACM Portal");
    }

    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    public String getHelpPage() {
        return "ACMPortalHelp.html";
    }

    public String getKeyName() {
        return "Search ACM Portal";
    }

    public void cancelled() {
        this.shouldContinue = false;
    }

    public void done(int entriesImported) {
    }

    public void stopFetching() {
        this.shouldContinue = false;
    }
}

