/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

public class UndoableMoveGroup
extends AbstractUndoableEdit {
    private final GroupSelector m_groupSelector;
    private final GroupTreeNode m_groupsRootHandle;
    private final int[] m_pathToNewParent;
    private final int m_newChildIndex;
    private final int[] m_pathToOldParent;
    private final int m_oldChildIndex;

    public UndoableMoveGroup(GroupSelector gs, GroupTreeNode groupsRoot, GroupTreeNode moveNode, GroupTreeNode newParent, int newChildIndex) {
        this.m_groupSelector = gs;
        this.m_groupsRootHandle = groupsRoot;
        this.m_pathToNewParent = newParent.getIndexedPath();
        this.m_newChildIndex = newChildIndex;
        this.m_pathToOldParent = ((GroupTreeNode)moveNode.getParent()).getIndexedPath();
        this.m_oldChildIndex = moveNode.getParent().getIndex(moveNode);
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("move group");
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("move group");
    }

    public void undo() {
        super.undo();
        GroupTreeNode cursor = this.m_groupsRootHandle.getDescendant(this.m_pathToNewParent);
        cursor = (GroupTreeNode)cursor.getChildAt(this.m_newChildIndex);
        this.m_groupsRootHandle.getDescendant(this.m_pathToOldParent).insert(cursor, this.m_oldChildIndex);
        this.m_groupSelector.revalidateGroups();
    }

    public void redo() {
        super.redo();
        GroupTreeNode cursor = this.m_groupsRootHandle.getDescendant(this.m_pathToOldParent);
        cursor = (GroupTreeNode)cursor.getChildAt(this.m_oldChildIndex);
        this.m_groupsRootHandle.getDescendant(this.m_pathToNewParent).insert(cursor, this.m_newChildIndex);
        this.m_groupSelector.revalidateGroups();
    }
}

