/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.external.FullTextFinder;
import net.sf.jabref.external.ScienceDirectPdfDownload;
import net.sf.jabref.external.SpringerLinkPdfDownload;

public class FindFullText {
    public static final int FOUND_PDF = 0;
    public static final int WRONG_MIME_TYPE = 1;
    public static final int UNKNOWN_DOMAIN = 2;
    public static final int LINK_NOT_FOUND = 3;
    public static final int IO_EXCEPTION = 4;
    public static final int NO_URLS_DEFINED = 5;
    List<FullTextFinder> finders = new ArrayList<FullTextFinder>();

    public FindFullText() {
        this.finders.add(new ScienceDirectPdfDownload());
        this.finders.add(new SpringerLinkPdfDownload());
    }

    public FindResult findFullText(BibtexEntry entry) {
        String urlText = entry.getField("url");
        String doiText = entry.getField("doi");
        if (doiText != null && doiText.trim().length() > 0) {
            FindResult resDoi = this.lookForFullTextAtURL("http://dx.doi.org/" + doiText);
            if (resDoi.status == 0) {
                return resDoi;
            }
            if (urlText != null && urlText.trim().length() > 0) {
                FindResult resUrl = this.lookForFullTextAtURL(urlText);
                if (resUrl.status == 0) {
                    return resUrl;
                }
                return resDoi;
            }
            return resDoi;
        }
        if (urlText != null && urlText.trim().length() > 0) {
            return this.lookForFullTextAtURL(urlText);
        }
        return new FindResult(5, null);
    }

    /*
     * Exception decompiling
     */
    private FindResult lookForFullTextAtURL(String urlText) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP], 4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URL resolveRedirects(URL url, int redirectCount) throws IOException {
        URLConnection uc = url.openConnection();
        if (uc instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)uc;
            huc.setInstanceFollowRedirects(false);
            huc.connect();
            int responseCode = huc.getResponseCode();
            String location = huc.getHeaderField("location");
            huc.disconnect();
            if (responseCode == 302 && redirectCount < 5) {
                try {
                    URL newUrl = new URL(location);
                    return this.resolveRedirects(newUrl, redirectCount + 1);
                }
                catch (MalformedURLException ex) {
                    return url;
                }
            }
            return url;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadPage(URL url) throws IOException {
        Reader in = null;
        HttpURLConnection huc = null;
        try {
            URLConnection uc = url.openConnection();
            if (uc instanceof HttpURLConnection) {
                int c;
                huc = (HttpURLConnection)uc;
                huc.setInstanceFollowRedirects(false);
                huc.connect();
                in = new InputStreamReader(huc.getInputStream());
                StringBuilder sb = new StringBuilder();
                while ((c = in.read()) != -1) {
                    sb.append((char)c);
                }
                String string = sb.toString();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (huc != null) {
                    huc.disconnect();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void dumpToFile(String text, File f) {
        try {
            FileWriter fw = new FileWriter(f);
            fw.write(text);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class FindResult {
        public URL url;
        public String host = null;
        public int status;

        public FindResult(URL url, URL originalUrl) {
            this.url = url;
            this.status = 0;
            if (originalUrl != null) {
                this.host = originalUrl.getHost();
            }
        }

        public FindResult(int status, URL originalUrl) {
            this.url = null;
            this.status = status;
            if (originalUrl != null) {
                this.host = originalUrl.getHost();
            }
        }
    }
}

