/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.Util;
import net.sf.jabref.external.ExternalFilePanel;
import net.sf.jabref.gui.AttachFileDialog;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class AutoSetExternalFileForEntries
extends AbstractWorker {
    private String fieldName;
    private BasePanel panel;
    private BibtexEntry[] sel = null;
    private OptionsDialog optDiag = null;
    Object[] brokenLinkOptions = new Object[]{Globals.lang("Ignore"), Globals.lang("Assign new file"), Globals.lang("Clear field"), Globals.lang("Quit synchronization")};
    private boolean goOn = true;
    private boolean autoSet = true;
    private boolean overWriteAllowed = true;
    private boolean checkExisting = true;
    private int entriesChanged = 0;
    private int brokenLinks = 0;

    public AutoSetExternalFileForEntries(BasePanel panel, String fieldName) {
        this.fieldName = fieldName;
        this.panel = panel;
    }

    public void init() {
        Collection<BibtexEntry> col = this.panel.database().getEntries();
        this.sel = col.toArray(new BibtexEntry[col.size()]);
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame(), this.fieldName);
        }
        Util.placeDialog(this.optDiag, this.panel.frame());
        this.optDiag.setVisible(true);
        if (this.optDiag.canceled()) {
            this.goOn = false;
            return;
        }
        this.autoSet = !this.optDiag.autoSetNone.isSelected();
        this.overWriteAllowed = this.optDiag.autoSetAll.isSelected();
        this.checkExisting = this.optDiag.checkLinks.isSelected();
        this.panel.output(Globals.lang("Synchronizing %0 links...", this.fieldName.toUpperCase()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        String old;
        int i;
        if (!this.goOn) {
            this.panel.output(Globals.lang("No entries selected."));
            return;
        }
        this.panel.frame().setProgressBarValue(0);
        this.panel.frame().setProgressBarVisible(true);
        int weightAutoSet = 10;
        int progressBarMax = (this.autoSet ? weightAutoSet * this.sel.length : 0) + (this.checkExisting ? this.sel.length : 0);
        this.panel.frame().setProgressBarMaximum(progressBarMax);
        int progress = 0;
        this.entriesChanged = 0;
        this.brokenLinks = 0;
        NamedCompound ce = new NamedCompound(Globals.lang("Autoset %0 field", this.fieldName));
        OpenFileFilter off = Util.getFileFilterForField(this.fieldName);
        ExternalFilePanel extPan = new ExternalFilePanel(this.fieldName, this.panel.metaData(), null, null, off);
        FieldTextField editor = new FieldTextField(this.fieldName, "", false);
        String dir = this.panel.metaData().getFileDirectory(this.fieldName);
        if (this.autoSet) {
            for (i = 0; i < this.sel.length; ++i) {
                this.panel.frame().setProgressBarValue(progress += weightAutoSet);
                old = this.sel[i].getField(this.fieldName);
                if (old != null && !old.equals("") && !this.overWriteAllowed) continue;
                extPan.setEntry(this.sel[i], this.panel.getDatabase());
                editor.setText(old != null ? old : "");
                Thread t = extPan.autoSetFile(this.fieldName, editor);
                if (t != null) {
                    try {
                        t.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (editor.getText().equals("") || editor.getText().equals(old)) continue;
                ce.addEdit(new UndoableFieldChange(this.sel[i], this.fieldName, old, editor.getText()));
                this.sel[i].setField(this.fieldName, editor.getText());
                ++this.entriesChanged;
            }
        }
        if (this.checkExisting) {
            block8: for (i = 0; i < this.sel.length; ++i) {
                File file;
                this.panel.frame().setProgressBarValue(progress++);
                old = this.sel[i].getField(this.fieldName);
                if (old == null || old.equals("") || (file = Util.expandFilename(old, new String[]{dir, "."})) != null && file.exists()) continue;
                int answer = JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("<HTML>Could not find file '%0'<BR>linked from entry '%1'</HTML>", new String[]{old, this.sel[i].getCiteKey()}), Globals.lang("Broken link"), 1, 3, null, this.brokenLinkOptions, this.brokenLinkOptions[0]);
                switch (answer) {
                    case 1: {
                        AttachFileDialog afd = new AttachFileDialog((Frame)this.panel.frame(), this.panel.metaData(), this.sel[i], this.fieldName);
                        Util.placeDialog(afd, this.panel.frame());
                        afd.setVisible(true);
                        if (afd.cancelled()) break;
                        ce.addEdit(new UndoableFieldChange(this.sel[i], this.fieldName, old, afd.getValue()));
                        this.sel[i].setField(this.fieldName, afd.getValue());
                        ++this.entriesChanged;
                        break;
                    }
                    case 2: {
                        ce.addEdit(new UndoableFieldChange(this.sel[i], this.fieldName, old, null));
                        this.sel[i].setField(this.fieldName, null);
                        ++this.entriesChanged;
                        break;
                    }
                    case 3: {
                        break block8;
                    }
                }
                ++this.brokenLinks;
            }
        }
        if (this.entriesChanged > 0) {
            ce.end();
            this.panel.undoManager.addEdit(ce);
        }
    }

    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Globals.lang("Finished synchronizing %0 links. Entries changed%c %1.", new String[]{this.fieldName.toUpperCase(), String.valueOf(this.entriesChanged)}));
        this.panel.frame().setProgressBarVisible(false);
        if (this.entriesChanged > 0) {
            this.panel.markBaseChanged();
        }
    }

    class OptionsDialog
    extends JDialog {
        JRadioButton autoSetUnset;
        JRadioButton autoSetAll;
        JRadioButton autoSetNone;
        JCheckBox checkLinks;
        JButton ok;
        JButton cancel;
        JLabel description;
        private boolean canceled;
        private String fieldName;

        public OptionsDialog(JFrame parent, String fieldName) {
            super(parent, Globals.lang("Synchronize %0 links", fieldName.toUpperCase()), true);
            this.ok = new JButton(Globals.lang("Ok"));
            this.cancel = new JButton(Globals.lang("Cancel"));
            this.canceled = true;
            String fn = fieldName.toUpperCase();
            this.fieldName = fieldName;
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.canceled = false;
                    OptionsDialog.this.dispose();
                }
            });
            AbstractAction closeAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    OptionsDialog.this.dispose();
                }
            };
            this.cancel.addActionListener(closeAction);
            InputMap im = this.cancel.getInputMap(2);
            ActionMap am = this.cancel.getActionMap();
            im.put(Globals.prefs.getKey("Close dialog"), "close");
            am.put("close", closeAction);
            fieldName = fieldName.toUpperCase();
            this.autoSetUnset = new JRadioButton(Globals.lang("Autoset %0 links. Do not overwrite existing links.", fn), true);
            this.autoSetAll = new JRadioButton(Globals.lang("Autoset %0 links. Allow overwriting existing links.", fn), false);
            this.autoSetNone = new JRadioButton(Globals.lang("Do not autoset"), false);
            this.checkLinks = new JCheckBox(Globals.lang("Check existing %0 links", fn), true);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.autoSetUnset);
            bg.add(this.autoSetNone);
            bg.add(this.autoSetAll);
            FormLayout layout = new FormLayout("fill:pref", "");
            DefaultFormBuilder builder = new DefaultFormBuilder(layout);
            this.description = new JLabel("<HTML>" + Globals.lang("Attempt to autoset %0 links for your entries. Autoset works if a %0 file in your %0 directory or a subdirectory<BR>is named identically to an entry's BibTeX key, plus extension.", fn) + "</HTML>");
            builder.appendSeparator(Globals.lang("Autoset"));
            builder.append(this.description);
            builder.nextLine();
            builder.append(this.autoSetUnset);
            builder.nextLine();
            builder.append(this.autoSetAll);
            builder.nextLine();
            builder.append(this.autoSetNone);
            builder.nextLine();
            builder.appendSeparator(Globals.lang("Check links"));
            this.description = new JLabel("<HTML>" + Globals.lang("This makes JabRef look up each %0 link and check if the file exists. If not, you will be given options<BR>to resolve the problem.", fn) + "</HTML>");
            builder.append(this.description);
            builder.nextLine();
            builder.append(this.checkLinks);
            builder.nextLine();
            builder.appendSeparator();
            JPanel main = builder.getPanel();
            main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ButtonBarBuilder bb = new ButtonBarBuilder();
            bb.addGlue();
            bb.addGridded(this.ok);
            bb.addGridded(this.cancel);
            bb.addGlue();
            this.getContentPane().add((Component)main, "Center");
            this.getContentPane().add((Component)bb.getPanel(), "South");
            this.pack();
        }

        public void setVisible(boolean visible) {
            String dir;
            if (visible) {
                this.canceled = true;
            }
            if ((dir = AutoSetExternalFileForEntries.this.panel.metaData().getFileDirectory(this.fieldName)) == null || dir.trim().length() == 0) {
                this.autoSetNone.setSelected(true);
                this.autoSetNone.setEnabled(false);
                this.autoSetAll.setEnabled(false);
                this.autoSetUnset.setEnabled(false);
            } else {
                this.autoSetNone.setEnabled(true);
                this.autoSetAll.setEnabled(true);
                this.autoSetUnset.setEnabled(true);
            }
            new FocusRequester(this.ok);
            super.setVisible(visible);
        }

        public boolean canceled() {
            return this.canceled;
        }
    }
}

