/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.File;
import java.io.IOException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.CallBack;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.Worker;
import net.sf.jabref.collab.ChangeScanner;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.gui.FileDialogs;

public class SaveDatabaseAction
extends AbstractWorker {
    private BasePanel panel;
    private JabRefFrame frame;
    private boolean success = false;
    private boolean cancelled = false;
    private boolean fileLockedError = false;

    public SaveDatabaseAction(BasePanel panel) {
        this.panel = panel;
        this.frame = panel.frame();
    }

    public void init() throws Throwable {
        this.success = false;
        this.cancelled = false;
        this.fileLockedError = false;
        if (this.panel.getFile() == null) {
            this.saveAs();
        } else {
            if (this.panel.isUpdatedExternally() || Globals.fileUpdateMonitor.hasBeenModified(this.panel.getFileMonitorHandle())) {
                boolean databaseProtectionFlag;
                Object[] opts = new String[]{Globals.lang("Review changes"), Globals.lang("Save"), Globals.lang("Cancel")};
                int answer = JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("File has been updated externally. What do you want to do?"), Globals.lang("File updated externally"), 1, 3, null, opts, opts[0]);
                if (answer == 2) {
                    this.cancelled = true;
                    return;
                }
                if (answer == 0) {
                    this.cancelled = true;
                    new Thread(new Runnable(){

                        public void run() {
                            if (!Util.waitForFileLock(SaveDatabaseAction.this.panel.getFile(), 10)) {
                                System.err.println("File locked, this will be trouble.");
                            }
                            ChangeScanner scanner = new ChangeScanner(SaveDatabaseAction.this.panel.frame(), SaveDatabaseAction.this.panel);
                            scanner.changeScan(SaveDatabaseAction.this.panel.getFile());
                            try {
                                scanner.join();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (scanner.changesFound()) {
                                scanner.displayResult(new ChangeScanner.DisplayResultCallback(){

                                    public void scanResultsResolved(boolean resolved) {
                                        if (!resolved) {
                                            SaveDatabaseAction.this.cancelled = true;
                                        } else {
                                            SaveDatabaseAction.this.panel.setUpdatedExternally(false);
                                            SwingUtilities.invokeLater(new Runnable(){

                                                public void run() {
                                                    SaveDatabaseAction.this.panel.getSidePaneManager().hide("fileUpdate");
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    }).start();
                    return;
                }
                Vector<String> pd = this.panel.metaData().getData("protectedFlag");
                boolean bl = databaseProtectionFlag = pd != null && Boolean.parseBoolean(pd.get(0));
                if (databaseProtectionFlag) {
                    JOptionPane.showMessageDialog(this.frame, Globals.lang("Database is protected. Cannot save until external changes have been reviewed."), Globals.lang("Protected database"), 0);
                    this.cancelled = true;
                } else {
                    this.panel.setUpdatedExternally(false);
                    this.panel.getSidePaneManager().hide("fileUpdate");
                }
            }
            this.panel.frame().output(Globals.lang("Saving database") + "...");
            this.panel.setSaving(true);
        }
    }

    public void update() {
        if (this.success) {
            this.frame.setTabTitle(this.panel, this.panel.getFile().getName(), this.panel.getFile().getAbsolutePath());
            this.frame.output(Globals.lang("Saved database") + " '" + this.panel.getFile().getPath() + "'.");
            this.frame.setWindowTitle();
        } else if (!this.cancelled) {
            if (this.fileLockedError) {
                this.frame.output(Globals.lang("Could not save, file locked by another JabRef instance."));
            } else {
                this.frame.output(Globals.lang("Save failed"));
            }
        }
    }

    public void run() {
        if (this.cancelled || this.panel.getFile() == null) {
            return;
        }
        try {
            this.panel.storeCurrentEdit();
            this.panel.autoGenerateKeysBeforeSaving();
            if (!Util.waitForFileLock(this.panel.getFile(), 10)) {
                this.success = false;
                this.fileLockedError = true;
            } else {
                this.success = this.saveDatabase(this.panel.getFile(), false, this.panel.getEncoding());
                try {
                    Globals.fileUpdateMonitor.updateTimeStamp(this.panel.getFileMonitorHandle());
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
            }
            this.panel.setSaving(false);
            if (this.success) {
                this.panel.undoManager.markUnchanged();
                if (!AutoSaveManager.deleteAutoSaveFile(this.panel)) {
                    // empty if block
                }
                this.panel.setNonUndoableChange(false);
                this.panel.setBaseChanged(false);
                this.panel.setUpdatedExternally(false);
            }
        }
        catch (SaveException ex2) {
            if (ex2 == SaveException.FILE_LOCKED) {
                this.success = false;
                this.fileLockedError = true;
                return;
            }
            ex2.printStackTrace();
        }
    }

    private boolean saveDatabase(File file, boolean selectedOnly, String encoding) throws SaveException {
        SaveSession session;
        this.frame.block();
        try {
            session = !selectedOnly ? FileActions.saveDatabase(this.panel.database(), this.panel.metaData(), file, Globals.prefs, false, false, encoding, false) : FileActions.savePartOfDatabase(this.panel.database(), this.panel.metaData(), file, Globals.prefs, this.panel.getSelectedEntries(), encoding);
        }
        catch (UnsupportedCharsetException ex2) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file. Character encoding '%0' is not supported.", encoding), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        catch (SaveException ex) {
            if (ex == SaveException.FILE_LOCKED) {
                throw ex;
            }
            if (ex.specificEntry()) {
                int row = this.panel.mainTable.findEntry(ex.getEntry());
                int topShow = Math.max(0, row - 3);
                this.panel.mainTable.setRowSelectionInterval(row, row);
                this.panel.mainTable.scrollTo(topShow);
                this.panel.showEntry(ex.getEntry());
            } else {
                ex.printStackTrace();
            }
            JOptionPane.showMessageDialog(this.frame, Globals.lang("Could not save file") + ".\n" + ex.getMessage(), Globals.lang("Save database"), 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean commit = true;
        if (!session.getWriter().couldEncodeAll()) {
            DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref", ""));
            JTextArea ta = new JTextArea(session.getWriter().getProblemCharacters());
            ta.setEditable(false);
            builder.append(Globals.lang("The chosen encoding '%0' could not encode the following characters: ", session.getEncoding()));
            builder.append(ta);
            builder.append(Globals.lang("What do you want to do?"));
            String tryDiff = Globals.lang("Try different encoding");
            int answer = JOptionPane.showOptionDialog(this.frame, builder.getPanel(), Globals.lang("Save database"), 1, 2, null, new String[]{Globals.lang("Save"), tryDiff, Globals.lang("Cancel")}, tryDiff);
            if (answer == 1) {
                Object choice = JOptionPane.showInputDialog(this.frame, Globals.lang("Select encoding"), Globals.lang("Save database"), 3, null, Globals.ENCODINGS, encoding);
                if (choice != null) {
                    String newEncoding = (String)choice;
                    return this.saveDatabase(file, selectedOnly, newEncoding);
                }
                commit = false;
            } else if (answer == 2) {
                commit = false;
            }
        }
        try {
            if (commit) {
                session.commit();
                this.panel.setEncoding(encoding);
            } else {
                session.cancel();
            }
        }
        catch (SaveException e) {
            int ans = JOptionPane.showConfirmDialog(null, Globals.lang("Save failed during backup creation") + ". " + Globals.lang("Save without backup?"), Globals.lang("Unable to create backup"), 0);
            if (ans == 0) {
                session.setUseBackup(false);
                session.commit();
                this.panel.setEncoding(encoding);
            } else {
                commit = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return commit;
    }

    public void runCommand() throws Throwable {
        Worker wrk = this.getWorker();
        CallBack clb = this.getCallBack();
        this.init();
        wrk.run();
        clb.update();
    }

    public void save() throws Throwable {
        this.runCommand();
    }

    public void saveAs() throws Throwable {
        String chosenFile = null;
        File f = null;
        while (f == null) {
            chosenFile = FileDialogs.getNewFile((JFrame)this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", 1, false, null);
            if (chosenFile == null) {
                this.cancelled = true;
                return;
            }
            f = new File(chosenFile);
            if (!f.exists() || JOptionPane.showConfirmDialog(this.frame, "'" + f.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Save database"), 2) == 0) continue;
            f = null;
        }
        if (chosenFile != null) {
            File oldFile = this.panel.metaData().getFile();
            this.panel.metaData().setFile(f);
            Globals.prefs.put("workingDirectory", f.getParent());
            this.runCommand();
            if (!this.success) {
                this.panel.metaData().setFile(oldFile);
                return;
            }
            try {
                this.panel.setFileMonitorHandle(Globals.fileUpdateMonitor.addUpdateListener(this.panel, this.panel.getFile()));
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.frame.getFileHistory().newFile(this.panel.metaData().getFile().getPath());
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

