/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class EntryChange
extends Change {
    BibtexEntry memEntry;
    BibtexEntry tmpEntry;
    BibtexEntry diskEntry;
    boolean isModifiedLocally;
    boolean modificationsAgree;

    public EntryChange(BibtexEntry memEntry, BibtexEntry tmpEntry, BibtexEntry diskEntry) {
        String key = tmpEntry.getCiteKey();
        this.name = key == null ? "Modified entry" : "Modified entry: '" + key + "'";
        this.memEntry = memEntry;
        this.tmpEntry = tmpEntry;
        this.diskEntry = diskEntry;
        this.isModifiedLocally = !(DuplicateCheck.compareEntriesStrictly(memEntry, tmpEntry) > 1.0);
        this.modificationsAgree = DuplicateCheck.compareEntriesStrictly(memEntry, diskEntry) > 1.0;
        TreeSet<String> allFields = new TreeSet<String>();
        allFields.addAll(memEntry.getAllFields());
        allFields.addAll(tmpEntry.getAllFields());
        allFields.addAll(diskEntry.getAllFields());
        for (String field : allFields) {
            String mem = memEntry.getField(field);
            String tmp = tmpEntry.getField(field);
            String disk = diskEntry.getField(field);
            if (tmp != null && disk != null) {
                if (tmp.equals(disk)) continue;
                this.add(new FieldChange(field, memEntry, tmpEntry, mem, tmp, disk));
                continue;
            }
            if (tmp == null && disk != null && !disk.equals("")) {
                this.add(new FieldChange(field, memEntry, tmpEntry, mem, tmp, disk));
                continue;
            }
            if (disk != null || tmp == null || tmp.equals("") || mem == null || mem.equals("")) continue;
            this.add(new FieldChange(field, memEntry, tmpEntry, mem, tmp, disk));
        }
    }

    public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
        boolean allAccepted = true;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            Change c = (Change)e.nextElement();
            if (c.isAcceptable() && c.isAccepted()) {
                c.makeChange(panel, secondary, undoEdit);
                continue;
            }
            allAccepted = false;
        }
        return allAccepted;
    }

    JComponent description() {
        return new JLabel(this.name);
    }

    class FieldChange
    extends Change {
        BibtexEntry entry;
        BibtexEntry tmpEntry;
        String field;
        String inMem;
        String onTmp;
        String onDisk;
        InfoPane tp = new InfoPane();
        JScrollPane sp = new JScrollPane(this.tp);

        public FieldChange(String field, BibtexEntry memEntry, BibtexEntry tmpEntry, String inMem, String onTmp, String onDisk) {
            this.entry = memEntry;
            this.tmpEntry = tmpEntry;
            this.name = field;
            this.field = field;
            this.inMem = inMem;
            this.onTmp = onTmp;
            this.onDisk = onDisk;
            StringBuffer text = new StringBuffer();
            text.append("<FONT SIZE=10>");
            text.append("<H2>").append(Globals.lang("Modification of field")).append(" <I>").append(field).append("</I></H2>");
            if (onDisk != null && !onDisk.equals("")) {
                text.append("<H3>").append(Globals.lang("Value set externally")).append(":</H3> ").append(onDisk);
            } else {
                text.append("<H3>").append(Globals.lang("Value cleared externally")).append("</H3>");
            }
            if (inMem != null && !inMem.equals("")) {
                text.append("<H3>").append(Globals.lang("Current value")).append(":</H3> ").append(inMem);
            }
            if (onTmp != null && !onTmp.equals("")) {
                text.append("<H3>").append(Globals.lang("Current tmp value")).append(":</H3> ").append(onTmp);
            }
            this.tp.setContentType("text/html");
            this.tp.setText(text.toString());
        }

        public boolean makeChange(BasePanel panel, BibtexDatabase secondary, NamedCompound undoEdit) {
            this.entry.setField(this.field, this.onDisk);
            undoEdit.addEdit(new UndoableFieldChange(this.entry, this.field, this.inMem, this.onDisk));
            this.tmpEntry.setField(this.field, this.onDisk);
            return true;
        }

        JComponent description() {
            return this.sp;
        }
    }
}

