/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpContent;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;

public class HelpDialog
extends JDialog
implements HyperlinkListener {
    private JabRefFrame frame;
    private HelpContent content;
    private BackAction back = new BackAction();
    private ForwardAction forward = new ForwardAction();
    private ContentsAction contents = new ContentsAction();

    public HelpDialog(JabRefFrame bf) {
        super(bf, Globals.lang("JabRef help"), false);
        this.frame = bf;
        this.content = new HelpContent(bf.prefs);
        this.content.addHyperlinkListener(this);
        this.setSize(GUIGlobals.helpSize);
        JToolBar tlb = new JToolBar();
        tlb.add(this.back);
        tlb.add(this.forward);
        tlb.addSeparator();
        tlb.add(this.contents);
        tlb.setFloatable(false);
        InputMap im = tlb.getInputMap(2);
        ActionMap am = tlb.getActionMap();
        im.put(bf.prefs.getKey("Close dialog"), "close");
        am.put("close", new CloseAction());
        im.put(bf.prefs.getKey("Back, help dialog"), "left");
        am.put("left", this.back);
        im.put(bf.prefs.getKey("Forward, help dialog"), "right");
        am.put("right", this.forward);
        im = this.content.getInputMap(0);
        am = this.content.getActionMap();
        im.put(bf.prefs.getKey("Back, help dialog"), "left");
        am.put("left", this.back);
        im.put(bf.prefs.getKey("Forward, help dialog"), "right");
        am.put("right", this.forward);
        this.getContentPane().add((Component)tlb, "North");
        this.getContentPane().add(this.content.getPane());
        this.forward.setEnabled(false);
        this.back.setEnabled(false);
    }

    public void showPage(String url) {
        this.showPage(url, JabRef.class);
    }

    public void showPage(String url, Class resourceOwner) {
        if (!this.isVisible()) {
            Util.placeDialog(this, this.frame);
            this.content.reset();
            this.back.setEnabled(false);
            this.setVisible(true);
        } else {
            this.back.setEnabled(true);
        }
        this.forward.setEnabled(false);
        this.content.setPage(url, resourceOwner);
        this.content.requestFocus();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.content.setPage(e.getURL());
            this.back.setEnabled(true);
            this.forward.setEnabled(false);
        }
    }

    class ContentsAction
    extends AbstractAction {
        public ContentsAction() {
            super("Contents", GUIGlobals.getImage("helpContents"));
        }

        public void actionPerformed(ActionEvent e) {
            HelpDialog.this.content.setPage(GUIGlobals.helpContents, JabRef.class);
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            super("Forward", GUIGlobals.getImage("right"));
        }

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(HelpDialog.this.content.forward());
            HelpDialog.this.back.setEnabled(true);
        }
    }

    class BackAction
    extends AbstractAction {
        public BackAction() {
            super("Back", GUIGlobals.getImage("left"));
        }

        public void actionPerformed(ActionEvent e) {
            this.setEnabled(HelpDialog.this.content.back());
            HelpDialog.this.forward.setEnabled(true);
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close"));
            this.putValue("ShortDescription", Globals.lang("Close the help window"));
        }

        public void actionPerformed(ActionEvent e) {
            HelpDialog.this.dispose();
        }
    }
}

