/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.NotifyOption;
import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionEvent;
import gnu.dtools.ritopt.OptionException;
import gnu.dtools.ritopt.OptionListener;
import gnu.dtools.ritopt.OptionModule;
import gnu.dtools.ritopt.OptionModuleRegistrar;
import gnu.dtools.ritopt.OptionProcessingException;
import gnu.dtools.ritopt.OptionRegistrar;
import gnu.dtools.ritopt.Utility;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.jabref.Globals;

public class Options
implements OptionRegistrar,
OptionModuleRegistrar,
OptionListener {
    public static final int DEFAULT_VERBOSITY = 3;
    public static final boolean DEFAULT_DEPRECATED = false;
    public static final String DEFAULT_REASON = "No reason given.";
    public static final String DEFAULT_GENERAL_MODULE_NAME = "General";
    public static final boolean DEFAULT_DISPLAY_USAGE = false;
    public static final boolean DEFAULT_USE_MENU = false;
    public static final String DEFAULT_PROGRAM_NAME = "java program";
    public static final String DEFAULT_OPTION_FILENAME = "default.opt";
    private String usageProgram;
    private String version;
    private String defaultOptionFilename = "default.opt";
    private boolean displayUsage = false;
    private boolean useMenu = false;
    private boolean debugFlag;
    private OptionModule currentModule;
    private OptionModule generalModule;
    private HashMap<String, OptionModule> modules;
    private NotifyOption versionOption;

    public Options() {
        this(DEFAULT_PROGRAM_NAME);
    }

    public Options(String programName) {
        this.usageProgram = programName;
        this.modules = new HashMap();
        this.versionOption = new NotifyOption(this, "version", "");
        this.version = "Version 1.0";
        this.currentModule = this.generalModule = new OptionModule(DEFAULT_GENERAL_MODULE_NAME);
        this.register("version", 'v', "Displays version information.", this.versionOption);
    }

    public String getHelp() {
        String retval = (this.displayUsage ? this.getUsage() + "\n\n" : "") + Option.getHelpHeader() + "\n\n" + this.generalModule.getHelp();
        for (OptionModule module : this.modules.values()) {
            retval = retval + "\n\nOption Listing for " + module.getName() + "\n";
            retval = retval + module.getHelp() + "\n";
        }
        return retval;
    }

    public String getUsage() {
        return this.getUsageProgram() + " @optionfile :module: OPTIONS ... :module: OPTIONS";
    }

    public String getUsageProgram() {
        return this.usageProgram;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDefaultOptionFilename() {
        return this.defaultOptionFilename;
    }

    public boolean getDebugFlag() {
        return this.debugFlag;
    }

    public boolean shouldDisplayUsage() {
        return this.displayUsage;
    }

    public boolean shouldUseMenu() {
        return this.useMenu;
    }

    public void setDisplayUsage(boolean b) {
        this.displayUsage = b;
    }

    public void setUseMenu(boolean b) {
        this.useMenu = b;
    }

    public void setUsageProgram(String program) {
        this.usageProgram = program;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDefaultOptionFilename(String fn) {
        this.defaultOptionFilename = fn;
    }

    public void displayHelp() {
        System.err.println(this.getHelp());
    }

    public void displayVersion() {
        System.err.println(this.getVersion() + " (build " + Globals.BUILD + ")");
    }

    public void register(String longOption, Option option) {
        this.generalModule.register(longOption, option);
    }

    public void register(char shortOption, Option option) {
        this.generalModule.register(shortOption, option);
    }

    public void register(String longOption, char shortOption, Option option) {
        this.generalModule.register(longOption, shortOption, option);
    }

    public void register(String longOption, char shortOption, String description, Option option) {
        this.generalModule.register(longOption, shortOption, description, option);
    }

    public void register(String longOption, char shortOption, String description, Option option, boolean deprecated) {
        this.generalModule.register(longOption, shortOption, description, option, deprecated);
    }

    public void register(OptionModule module) {
        this.register(module.getName(), module);
    }

    public void register(String name, OptionModule module) {
        this.modules.put(name.toLowerCase(), module);
    }

    public String[] process(String[] args) {
        String[] retval = new String[]{};
        try {
            retval = this.processOptions(args);
        }
        catch (OptionException e) {
            System.err.println("Error: " + e.getMessage());
        }
        return retval;
    }

    public OptionModule getModule(String name) {
        return this.modules.get(name.toLowerCase());
    }

    public boolean moduleExists(String name) {
        return this.getModule(name) != null;
    }

    public void optionInvoked(OptionEvent event) {
        if (event.getCommand().equals("help")) {
            this.displayHelp();
        } else if (event.getCommand().equals("version")) {
            this.displayVersion();
        }
    }

    public String[] process(String str) {
        return this.process(this.split(str));
    }

    public String[] split(String str) {
        StringBuffer buf = new StringBuffer(str.length());
        ArrayList<String> l = new ArrayList<String>();
        int scnt = Utility.count(str, '\"');
        boolean q = false;
        if ((double)scnt / 2.0 != (double)(scnt / 2)) {
            throw new OptionProcessingException("Expecting an end quote.");
        }
        for (int n = 0; n < str.length(); ++n) {
            if (str.charAt(n) == '\"') {
                q = !q;
                continue;
            }
            if (str.charAt(n) == ' ' && !q) {
                l.add(buf.toString());
                buf = new StringBuffer(str.length());
                continue;
            }
            buf.append(str.charAt(n));
        }
        if (buf.length() != 0) {
            l.add(buf.toString());
        }
        Iterator it = l.iterator();
        String[] retval = new String[l.size()];
        int n = 0;
        while (it.hasNext()) {
            retval[n++] = (String)it.next();
        }
        return retval;
    }

    public void writeOptionFile(String filename) {
        FilterOutputStream writer = null;
        Iterator<OptionModule> it = null;
        this.currentModule = this.generalModule;
        try {
            writer = new BufferedOutputStream(new FileOutputStream(filename));
            PrintStream ps = new PrintStream(writer);
            this.generalModule.writeFileToPrintStream(ps);
            for (OptionModule module : this.modules.values()) {
                module.writeFileToPrintStream(ps);
            }
        }
        catch (IOException e) {
            throw new OptionProcessingException(e.getMessage());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new OptionProcessingException(e.getMessage());
            }
        }
    }

    public void loadOptionFile(String filename) {
        BufferedReader reader = null;
        String line = null;
        this.currentModule = this.generalModule;
        try {
            reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                line = Utility.stripComments(line, '\"', ';');
                this.process(line);
            }
        }
        catch (IOException e) {
            throw new OptionProcessingException(e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new OptionProcessingException(e.getMessage());
            }
        }
    }

    private String[] processOptions(String[] args) {
        String[] retval = null;
        String moduleName = "general";
        String optionFile = "";
        char shortOption = '\u0000';
        String longOption = "";
        for (int n = 0; n < args.length && retval == null; ++n) {
            boolean moduleInvoked = false;
            boolean shortOptionInvoked = false;
            boolean longOptionInvoked = false;
            boolean readOptionFileInvoked = false;
            boolean writeOptionFileInvoked = false;
            if (args[n].length() >= 1) {
                char fc = args[n].charAt(0);
                moduleInvoked = fc == ':';
                readOptionFileInvoked = fc == '@';
                boolean bl = writeOptionFileInvoked = fc == '%';
            }
            if (args[n].length() >= 2) {
                String s = args[n].substring(0, 2);
                shortOptionInvoked = !s.equals("--") && s.charAt(0) == '-';
                longOptionInvoked = s.equals("--");
            }
            if (this.debugFlag) {
                System.err.println("Short Option: " + shortOptionInvoked);
                System.err.println("Long Option: " + longOptionInvoked);
                System.err.println("Module: " + moduleInvoked);
                System.err.println("Load Option File: " + readOptionFileInvoked);
                System.err.println("Write Option File: " + writeOptionFileInvoked);
            }
            if (moduleInvoked) {
                if (args[n].charAt(args[n].length() - 1) != ':') {
                    System.err.println(args[n]);
                    throw new OptionProcessingException("Module arguments must start with : and end with :.");
                }
                moduleName = args[n].substring(1, args[n].length() - 1).toLowerCase();
                if (moduleName.length() == 0 || moduleName.equals("general")) {
                    moduleName = "general";
                    this.currentModule = this.generalModule;
                } else {
                    this.currentModule = this.getModule(moduleName);
                }
                if (this.currentModule == null) {
                    throw new OptionProcessingException("Module '" + moduleName + "' does not exist.");
                }
                if (this.debugFlag) {
                    System.err.println("Module: " + moduleName);
                }
                moduleInvoked = false;
                continue;
            }
            if (readOptionFileInvoked) {
                optionFile = Utility.trim(args[n].substring(1));
                if (optionFile.equals("@") || optionFile.length() == 0) {
                    optionFile = this.defaultOptionFilename;
                }
                if (this.debugFlag) {
                    System.err.println("Option file: '" + optionFile + "'.");
                }
                this.loadOptionFile(optionFile);
                continue;
            }
            if (shortOptionInvoked) {
                char delim;
                shortOption = args[n].charAt(1);
                if (!Utility.isAlphaNumeric(shortOption)) {
                    throw new OptionProcessingException("A short option must be alphanumeric. -" + shortOption + " is not acceptable.");
                }
                if (this.debugFlag) {
                    System.err.println("Short option text: " + shortOption);
                }
                char c = delim = args[n].length() >= 3 ? args[n].charAt(2) : (char)'\u0000';
                if (delim == '+' || delim == '-') {
                    this.currentModule.action(shortOption, delim);
                    continue;
                }
                if (delim == '=') {
                    this.currentModule.action(shortOption, args[n].substring(3));
                    continue;
                }
                if (delim == '\u0000') {
                    String dtext = "+";
                    if (n < args.length - 1 && !Utility.contains(args[n + 1].charAt(0), "-[@")) {
                        dtext = args[n + 1];
                        ++n;
                    }
                    this.currentModule.action(shortOption, dtext);
                    continue;
                }
                if (!Utility.isAlphaNumeric(delim)) continue;
                for (int j = 1; j < args[n].length(); ++j) {
                    if (!Utility.isAlphaNumeric(args[n].charAt(j))) {
                        throw new OptionProcessingException("A short option must be alphanumeric. -" + shortOption + " is not acceptable.");
                    }
                    this.currentModule.action(shortOption, "+");
                }
                continue;
            }
            if (longOptionInvoked) {
                char lastchar = args[n].charAt(args[n].length() - 1);
                int eqindex = args[n].indexOf("=");
                if (eqindex != -1) {
                    longOption = args[n].substring(2, eqindex);
                    String value = args[n].substring(eqindex + 1);
                    this.currentModule.action(longOption, value);
                } else if (Utility.contains(lastchar, "+-")) {
                    longOption = args[n].substring(2, args[n].length() - 1);
                    this.currentModule.action(longOption, lastchar);
                } else {
                    longOption = args[n].substring(2);
                    String dtext = "+";
                    if (n < args.length - 1 && args[n + 1].length() > 0 && !Utility.contains(args[n + 1].charAt(0), "-[@")) {
                        dtext = args[n + 1];
                        ++n;
                    }
                    this.currentModule.action(longOption, dtext);
                }
                if (!this.debugFlag) continue;
                System.err.println("long option: " + longOption);
                continue;
            }
            if (writeOptionFileInvoked) {
                optionFile = Utility.trim(args[n].substring(1));
                if (optionFile.equals("%") || optionFile.length() == 0) {
                    optionFile = this.defaultOptionFilename;
                }
                if (this.debugFlag) {
                    System.err.println("Option file: '" + optionFile + "'.");
                }
                this.writeOptionFile(optionFile);
                continue;
            }
            retval = new String[args.length - n];
            for (int j = n; j < args.length; ++j) {
                retval[j - n] = args[j];
            }
        }
        if (retval == null) {
            retval = new String[]{};
        }
        return retval;
    }
}

