/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.OptionEvent;
import gnu.dtools.ritopt.OptionListener;
import gnu.dtools.ritopt.Options;
import gnu.dtools.ritopt.SimpleProcess;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class OptionMenu
implements OptionListener {
    public static final String OPTION_COMMAND_CHAR = "-";
    public static final String HELP_COMMAND_CHAR = "?";
    public static final String RUN_COMMAND_CHAR = "=";
    public static final String SHELL_COMMAND_CHAR = "!";
    public static final String EXIT_MENU_COMMAND_CHAR = "$";
    public static final String LIST_MODULES_COMMAND_CHAR = "+";
    public static final String FILE_READ_COMMAND_CHAR = "@";
    public static final String FILE_WRITE_COMMAND_CHAR = "%";
    public static final String FILE_MODULE_COMMAND_CHAR = ":";
    public static final String MENU_PROMPT = "-> ";
    private Options options;
    private BufferedReader reader;

    public OptionMenu(Options options) {
        this.options = options;
        this.reader = new BufferedReader(new InputStreamReader(System.in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMenu() {
        String command = "";
        while (!command.equals(EXIT_MENU_COMMAND_CHAR)) {
            boolean commandEntered;
            System.out.print(MENU_PROMPT);
            try {
                command = this.reader.readLine();
            }
            catch (IOException e) {
                return;
            }
            boolean bl = commandEntered = command != null && command.length() > 0;
            if (commandEntered && command.equals(HELP_COMMAND_CHAR)) {
                System.err.println("\t- Options Delimiter");
                System.err.println("\t? Help");
                System.err.println("\t= Run program and return to menu");
                System.err.println("\t! Shell to Operating System");
                System.err.println("\t$ Exit menu");
                System.err.println("\t+ Additional options");
                System.err.println("\t@<filename> Get options from file [" + this.options.getDefaultOptionFilename() + "]");
                System.err.println("\t@@ Get options from file [" + this.options.getDefaultOptionFilename() + "]");
                System.err.println("\t%<filename> Put options in file");
                System.err.println("\t%% Put options in file [" + this.options.getDefaultOptionFilename() + "]");
                System.err.println("\t. Quit");
                continue;
            }
            if (commandEntered && (command.substring(0, 1).equals(FILE_READ_COMMAND_CHAR) || command.substring(0, 1).equals(FILE_WRITE_COMMAND_CHAR) || command.substring(0, 1).equals(OPTION_COMMAND_CHAR) || command.substring(0, 1).equals(FILE_MODULE_COMMAND_CHAR))) {
                this.options.process(command);
                continue;
            }
            if (commandEntered && command.substring(0, 1).equals(SHELL_COMMAND_CHAR)) continue;
            if (commandEntered && command.substring(0, 1).equals(RUN_COMMAND_CHAR)) {
                try {
                    SimpleProcess p = new SimpleProcess(Runtime.getRuntime().exec(command.substring(1)));
                    System.err.println("Exit status: " + p.waitFor());
                    continue;
                }
                catch (Exception e) {
                    System.err.println("ritopt: An Error Occurred During Process Execution");
                    e.printStackTrace();
                    continue;
                }
                finally {
                    System.out.println("Press enter to continue...");
                    try {
                        this.reader.readLine();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            System.err.println("(Type ? for Help)");
        }
    }

    public void optionInvoked(OptionEvent event) {
        if (event.getCommand().equals("menu")) {
            this.startMenu();
        }
    }
}

