/*
 * Decompiled with CFR 0.152.
 */
package bibtex.dom;

import bibtex.dom.BibtexAbstractEntry;
import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexConcatenatedValue;
import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexMacroDefinition;
import bibtex.dom.BibtexMacroReference;
import bibtex.dom.BibtexMultipleValues;
import bibtex.dom.BibtexNode;
import bibtex.dom.BibtexPerson;
import bibtex.dom.BibtexPersonList;
import bibtex.dom.BibtexPreamble;
import bibtex.dom.BibtexString;
import bibtex.dom.BibtexToplevelComment;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class BibtexFile
extends BibtexNode {
    private final ArrayList entries = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("bibtex.dom.BibtexFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public BibtexFile() {
        super(null);
    }

    public void addEntry(BibtexAbstractEntry entry) {
        if (!$assertionsDisabled && entry == null) {
            throw new AssertionError((Object)"entry parameter may not be null.");
        }
        if (!$assertionsDisabled && this.entries.contains(entry)) {
            throw new AssertionError((Object)"entry parameter is already contained within this BibtexFile object.");
        }
        this.entries.add(entry);
    }

    public void removeEntry(BibtexAbstractEntry entry) {
        if (!$assertionsDisabled && entry == null) {
            throw new AssertionError();
        }
        boolean found = this.entries.remove(entry);
        if (!$assertionsDisabled && !found) {
            throw new AssertionError((Object)"entry parameter was not found.");
        }
    }

    public List getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public BibtexConcatenatedValue makeConcatenatedValue(BibtexAbstractValue left, BibtexAbstractValue right) {
        if (!$assertionsDisabled && left == null) {
            throw new AssertionError((Object)"left parameter may not be null.");
        }
        if (!$assertionsDisabled && right == null) {
            throw new AssertionError((Object)"right parameter may not be null.");
        }
        return new BibtexConcatenatedValue(this, left, right);
    }

    public BibtexEntry makeEntry(String entryType, String entryKey) {
        if (!$assertionsDisabled && entryType == null) {
            throw new AssertionError((Object)"entryType parameter may not be null.");
        }
        return new BibtexEntry(this, entryType, entryKey == null ? "" : entryKey);
    }

    public BibtexPersonList makePersonList() {
        return new BibtexPersonList(this);
    }

    public BibtexPerson makePerson(String first, String preLast, String last, String lineage, boolean isOthers) {
        if (!$assertionsDisabled && !isOthers && last == null) {
            throw new AssertionError((Object)"(isOthers||last!=null) has to be true.");
        }
        return new BibtexPerson(this, first, preLast, last, lineage, isOthers);
    }

    public BibtexPreamble makePreamble(BibtexAbstractValue content) {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError((Object)"content parameter may not be null.");
        }
        return new BibtexPreamble(this, content);
    }

    public BibtexString makeString(String content) {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError((Object)"content parameter may not be null.");
        }
        return new BibtexString(this, content);
    }

    public BibtexMultipleValues makeBibtexMultipleValues() {
        return new BibtexMultipleValues(this);
    }

    public BibtexMacroDefinition makeMacroDefinition(String key, BibtexAbstractValue value) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError((Object)"key parameter may not be null.");
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError((Object)"value parameter may not be null.");
        }
        if (!$assertionsDisabled && value instanceof BibtexMultipleValues) {
            throw new AssertionError((Object)"value parameter may not be an instance of BibtexMultipleValues");
        }
        return new BibtexMacroDefinition(this, key, value);
    }

    public BibtexMacroReference makeMacroReference(String key) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError((Object)"key parameter may not be null.");
        }
        return new BibtexMacroReference(this, key);
    }

    public BibtexToplevelComment makeToplevelComment(String content) {
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError((Object)"content parameter may not be null.");
        }
        return new BibtexToplevelComment(this, content);
    }

    public void printBibtex(PrintWriter writer) {
        if (!$assertionsDisabled && writer == null) {
            throw new AssertionError((Object)"writer parameter may not be null.");
        }
        Iterator iter = this.entries.iterator();
        while (iter.hasNext()) {
            BibtexNode node = (BibtexNode)iter.next();
            node.printBibtex(writer);
        }
        writer.flush();
    }
}

