/*
 * Decompiled with CFR 0.152.
 */
package bibtex.dom;

import bibtex.dom.BibtexAbstractEntry;
import bibtex.dom.BibtexAbstractValue;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexMultipleValues;
import bibtex.dom.BibtexNode;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BibtexEntry
extends BibtexAbstractEntry {
    private String entryType;
    private String entryKey;
    private HashMap fields = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("bibtex.dom.BibtexEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    BibtexEntry(BibtexFile file, String entryType, String entryKey) {
        super(file);
        this.entryKey = entryKey;
        this.entryType = entryType.toLowerCase().intern();
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public BibtexAbstractValue getFieldValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError((Object)"name parameter has to be non null.");
        }
        return (BibtexAbstractValue)this.fields.get(name);
    }

    public List getFieldValuesAsList(String fieldName) {
        if (!$assertionsDisabled && fieldName == null) {
            throw new AssertionError((Object)"fieldName parameter may not be null.");
        }
        Object value = this.fields.get(fieldName);
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof BibtexMultipleValues) {
            return ((BibtexMultipleValues)value).getValues();
        }
        return Collections.singletonList(value);
    }

    public void addFieldValue(String fieldName, BibtexAbstractValue value) {
        if (!$assertionsDisabled && fieldName == null) {
            throw new AssertionError((Object)"fieldName may not be null.");
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError((Object)"value may not be null.");
        }
        if (!$assertionsDisabled && value instanceof BibtexMultipleValues) {
            throw new AssertionError((Object)"value may not be an instance of BibtexMultipleValues.");
        }
        BibtexAbstractValue currentValue = this.getFieldValue(fieldName);
        if (currentValue == null) {
            this.setField(fieldName, value);
        } else if (currentValue instanceof BibtexMultipleValues) {
            BibtexMultipleValues multipleValues = (BibtexMultipleValues)currentValue;
            multipleValues.addValue(value);
        } else {
            BibtexMultipleValues multipleValues = this.getOwnerFile().makeBibtexMultipleValues();
            multipleValues.addValue(currentValue);
            multipleValues.addValue(value);
            this.setField(fieldName, multipleValues);
        }
    }

    public String getEntryType() {
        return this.entryType;
    }

    public Map getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public void setField(String fieldName, BibtexAbstractValue fieldValue) {
        if (!$assertionsDisabled && fieldName == null) {
            throw new AssertionError((Object)"fieldName parameter has to be non null.");
        }
        if (!$assertionsDisabled && fieldValue == null) {
            throw new AssertionError((Object)"fieldValue parameter has to be non null.");
        }
        this.fields.put(fieldName.toLowerCase().intern(), fieldValue);
    }

    public void setEntryKey(String entryKey) {
        if (!$assertionsDisabled && entryKey == null) {
            throw new AssertionError((Object)"BibtexEntry.setEntryKey(String entryKey): encountered entryKey==null.");
        }
        this.entryKey = entryKey.toLowerCase();
    }

    public void setEntryType(String entryType) {
        if (!$assertionsDisabled && entryType == null) {
            throw new AssertionError((Object)"BibtexEntry.setEntryType(String entryType): encountered entryType==null");
        }
        this.entryType = entryType.toLowerCase().intern();
    }

    public void printBibtex(PrintWriter writer) {
        if (!$assertionsDisabled && writer == null) {
            throw new AssertionError((Object)"writer parameter has to be !=null.");
        }
        writer.print('@');
        writer.print(this.entryType);
        writer.print('{');
        writer.print(this.entryKey);
        writer.println(',');
        Object[] keys = new String[this.fields.keySet().size()];
        this.fields.keySet().toArray(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            BibtexNode value = (BibtexNode)this.fields.get(key);
            if (value instanceof BibtexMultipleValues) {
                BibtexMultipleValues values = (BibtexMultipleValues)value;
                Iterator valuesIt = values.getValues().iterator();
                while (valuesIt.hasNext()) {
                    BibtexNode element = (BibtexNode)valuesIt.next();
                    writer.print('\t');
                    writer.print((String)key);
                    writer.print('=');
                    element.printBibtex(writer);
                    writer.println(',');
                }
            } else {
                writer.print('\t');
                writer.print((String)key);
                writer.print('=');
                value.printBibtex(writer);
                writer.println(',');
            }
            ++i;
        }
        writer.println('}');
    }

    public void undefineField(String fieldName) {
        if (!$assertionsDisabled && fieldName == null) {
            throw new AssertionError((Object)"fieldName parameter has to be !=null.");
        }
        this.fields.remove(fieldName);
    }
}

