/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;
import org.sciplore.resources.User;

@Entity
@Table(name="keywords")
public class Keyword
extends Resource {
    public static final short KEYWORD_TYPE_AUTHOR = 1;
    public static final short KEYWORD_TYPE_USER = 2;
    public static final short KEYWORD_TYPE_MINDMAP = 3;
    @ManyToOne
    @JoinColumn(name="document_id", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Document document;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(nullable=false)
    private String keyword;
    @Column(nullable=false)
    private Short type;
    @ManyToOne
    @JoinColumn(name="user_id")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private User user;
    @Column(nullable=false)
    private Short valid = 1;

    public Keyword getKeyword(Keyword k) {
        if (k.getId() != null) {
            return this.getKeyword(k.getId());
        }
        return this.getKeyword(k.getDocument(), k.getKeyword(), k.getType(), k.getUser());
    }

    public Keyword getKeyword(Integer id) {
        return (Keyword)this.getSession().get(Keyword.class, (Serializable)id);
    }

    public Keyword getKeyword(Document d, String k, Short t, User u) {
        return (Keyword)this.getSession().createCriteria(Keyword.class).add((Criterion)Restrictions.eq((String)"document", (Object)d)).add((Criterion)Restrictions.like((String)"keyword", (Object)k)).add((Criterion)Restrictions.eq((String)"type", (Object)t)).add((Criterion)Restrictions.eq((String)"user", (Object)u)).setMaxResults(1).uniqueResult();
    }

    public Keyword() {
    }

    public Keyword(Session s) {
        this.setSession(s);
    }

    public Keyword(Session s, Document doc, String keyword) {
        this.setSession(s);
        this.keyword = keyword;
        this.document = doc;
    }

    public Keyword(Session s, Document doc, String keyword, Short type) {
        this.setSession(s);
        this.keyword = keyword;
        this.type = type;
        this.document = doc;
    }

    public Keyword(Session s, String keyword) {
        this.setSession(s);
        this.keyword = keyword;
    }

    public Keyword(Session s, String keyword, Short type) {
        this.setSession(s);
        this.keyword = keyword;
        this.type = type;
    }

    public Document getDocument() {
        return this.document;
    }

    public Integer getId() {
        return this.id;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public Short getType() {
        return this.type;
    }

    public User getUser() {
        return this.user;
    }

    public Short getValid() {
        return this.valid;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }
}

