/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;

@Entity
@Table(name="institutions")
public class Institution
extends Resource {
    public static final short INSTITUTION_TYPE_MISC = 4;
    public static final short INSTITUTION_TYPE_PUBLISHER = 2;
    public static final short INSTITUTION_TYPE_SCHOOL = 3;
    public static final short INSTITUTION_TYPE_UNIVERSITY = 1;
    private String address;
    @OneToMany
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Institution> children;
    private String city;
    private String country;
    @OneToMany(mappedBy="institution")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Document> documents;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    private String name;
    @ManyToOne
    @JoinColumn(name="parent")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Institution parent;
    private String postalcode;
    private String state;
    private Short type;
    private String url;
    @Column(nullable=false)
    private Short valid = 1;

    public Institution getInstitution(Institution i) {
        if (i.getId() != null) {
            return this.getInstitution(i.getId());
        }
        return this.getInstitution(i.getName());
    }

    public Institution getInstitution(Integer id) {
        return (Institution)this.getSession().get(Institution.class, (Serializable)id);
    }

    public Institution getInstitution(String name) {
        return (Institution)this.getSession().createCriteria(Institution.class).add((Criterion)Restrictions.like((String)"name", (Object)name)).setMaxResults(1).uniqueResult();
    }

    public Institution() {
    }

    public Institution(Session s) {
        this.setSession(s);
    }

    public Institution(Session s, Integer id) {
        this.setSession(s);
        this.id = id;
    }

    public Institution(Session s, String name) {
        this.setSession(s);
        this.name = name;
    }

    public Institution(Session s, String name, Short type) {
        this.setSession(s);
        this.name = name;
        this.type = type;
    }

    public void addChild(Institution c) {
        this.children.add(c);
    }

    public void addDocument(Document d) {
        this.documents.add(d);
    }

    public String getAddress() {
        return this.address;
    }

    public Set<Institution> getChildren() {
        return this.children;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }

    public Set<Document> getDocuments() {
        return this.documents;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Institution getParent() {
        return this.parent;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public String getState() {
        return this.state;
    }

    public Short getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public Short getValid() {
        return this.valid;
    }

    public Institution setAddress(String address) {
        this.address = address;
        return this;
    }

    public void setChildren(Set<Institution> children) {
        this.children = children;
    }

    public Institution setCity(String city) {
        this.city = city;
        return this;
    }

    public Institution setCountry(String country) {
        this.country = country;
        return this;
    }

    public void setDocuments(Set<Document> documents) {
        this.documents = documents;
    }

    public Institution setId(Integer id) {
        this.id = id;
        return this;
    }

    public Institution setName(String name) {
        this.name = name;
        return this;
    }

    public Institution setParent(Institution parent) {
        this.parent = parent;
        return this;
    }

    public Institution setPostalcode(String postalcode) {
        this.postalcode = postalcode;
        return this;
    }

    public Institution setState(String state) {
        this.state = state;
        return this;
    }

    public Institution setType(Short type) {
        this.type = type;
        return this;
    }

    public Institution setUrl(String url) {
        this.url = url;
        return this;
    }

    public Institution setValid(Short valid) {
        this.valid = valid;
        return this;
    }

    public String toString() {
        return this.name;
    }
}

