/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;
import org.sciplore.resources.ResourceException;

@Entity
public class FulltextUrl
extends Resource {
    public static final Short FULLTEXTURL_FILETYPE_PDF = 1;
    public static final Short FULLTEXTURL_FILETYPE_PS = 2;
    public static final Short FULLTEXTURL_FILETYPE_PPT = 3;
    public static final Short FULLTEXTURL_FILETYPE_WORD = 4;
    public static final Short FULLTEXTURL_FILETYPE_HTML = 5;
    public static final Short FULLTEXTURL_LICENCE_WEB = 1;
    public static final Short FULLTEXTURL_STATUS_NEW = 0;
    public static final Short FULLTEXTURL_STATUS_DOWNLOADING = 1;
    public static final Short FULLTEXTURL_STATUS_DOWNLOADED = 2;
    public static final Short FULLTEXTURL_STATUS_WRONG = 3;
    public static final Short FULLTEXTURL_STATUS_ANALYZING = 4;
    public static final Short FULLTEXTURL_STATUS_ERROR = 5;
    public static final Short FULLTEXTURL_STATUS_CORRECT = 100;
    @ManyToOne
    @JoinColumn(name="document_id", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Document document;
    @Column(nullable=false)
    private Short filetype;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    @Column(nullable=false)
    private Short licence;
    private Short status;
    @Column(nullable=false)
    private String url;
    @Column(nullable=false)
    private Short valid;

    public List<FulltextUrl> getDownloaded() {
        return this.getDownloaded(null);
    }

    public List<FulltextUrl> getDownloaded(Short limit) {
        Criteria crit = this.getSession().createCriteria(FulltextUrl.class).add((Criterion)Restrictions.eq((String)"status", (Object)FULLTEXTURL_STATUS_DOWNLOADED));
        if (limit != null) {
            crit.setMaxResults((int)limit.shortValue());
        }
        return crit.list();
    }

    public FulltextUrl getFulltextUrl(FulltextUrl f) {
        if (f.getId() != null) {
            return this.getFulltextUrl(f.getId());
        }
        return this.getFulltextUrl(f.getDocument(), f.getUrl());
    }

    public FulltextUrl getFulltextUrl(Integer id) {
        return (FulltextUrl)this.getSession().get(FulltextUrl.class, (Serializable)id);
    }

    public FulltextUrl getFulltextUrl(Document d, String url) {
        return (FulltextUrl)this.getSession().createCriteria(FulltextUrl.class).add((Criterion)Restrictions.eq((String)"document", (Object)d)).add((Criterion)Restrictions.eq((String)"url", (Object)url)).setMaxResults(1).uniqueResult();
    }

    public FulltextUrl() {
    }

    public FulltextUrl(Session s) {
        this.setSession(s);
    }

    public FulltextUrl(Session s, Integer id, Integer documentId, Short filetype) {
        this.setSession(s);
        this.id = id;
        this.filetype = filetype;
    }

    public FulltextUrl delete() throws ResourceException {
        this.getSession().delete((Object)this);
        return this;
    }

    public void deleteFile() {
        new File("/srv/sciplore/database/" + this.getFilePath()).delete();
    }

    public Document getDocument() {
        return this.document;
    }

    public String getFilePath() {
        String path = "";
        path = String.valueOf(path) + (int)((long)this.document.getId().intValue() % 10000000000L / 1000000000L);
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 1000000000 / 100000000;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 100000000 / 10000000;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 10000000 / 1000000;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 1000000 / 100000;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 100000 / 10000;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 10000 / 1000;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 1000 / 100;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 100 / 10;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.document.getId() % 10;
        path = String.valueOf(path) + File.separator;
        path = String.valueOf(path) + this.id;
        switch (this.filetype) {
            case 1: {
                path = String.valueOf(path) + ".pdf";
                break;
            }
        }
        return path;
    }

    public Short getFiletype() {
        return this.filetype;
    }

    public Integer getId() {
        return this.id;
    }

    public Short getLicence() {
        return this.licence;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getUrl() {
        return this.url;
    }

    public Short getValid() {
        return this.valid;
    }

    public FulltextUrl setDocument(Document document) {
        this.document = document;
        return this;
    }

    public FulltextUrl setFiletype(Short filetype) {
        this.filetype = filetype;
        return this;
    }

    public FulltextUrl setId(Integer id) {
        this.id = id;
        return this;
    }

    public FulltextUrl setLicence(Short licence) {
        this.licence = licence;
        return this;
    }

    public FulltextUrl setStatus(Short status) {
        this.status = status;
        return this;
    }

    public FulltextUrl setUrl(String url) {
        this.url = url;
        return this;
    }

    public FulltextUrl setValid(Short valid) {
        this.valid = valid;
        return this;
    }

    public FulltextUrl updateStatus(Short status) {
        this.setStatus(status);
        this.save();
        return this;
    }
}

