/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Document;
import org.sciplore.resources.Resource;

@Entity
public class DocumentXref
extends Resource {
    @ManyToOne
    @JoinColumn(name="document_id")
    private Document document;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Integer id;
    private Date modified;
    private String source;
    private String sourcesId;

    public DocumentXref getDocumentXref(DocumentXref x) {
        if (x.getId() != null) {
            return this.getDocumentXref(x.getId());
        }
        return this.getDocumentXref(x.getDocument(), x.getSource(), x.getSourcesId());
    }

    public DocumentXref getDocumentXref(Integer id) {
        return (DocumentXref)this.getSession().get(DocumentXref.class, (Serializable)id);
    }

    public DocumentXref getDocumentXref(Document d, String s, String sid) {
        return (DocumentXref)this.getSession().createCriteria(DocumentXref.class).add((Criterion)Restrictions.eq((String)"document", (Object)d)).add((Criterion)Restrictions.eq((String)"source", (Object)s)).add((Criterion)Restrictions.eq((String)"sourcesId", (Object)sid)).setMaxResults(1).uniqueResult();
    }

    public DocumentXref() {
    }

    public DocumentXref(Session s) {
        this.setSession(s);
    }

    public DocumentXref(Session s, String source, String sourcesId) {
        this.setSession(s);
        this.source = source;
        this.sourcesId = sourcesId;
    }

    public Document getDocument() {
        return this.document;
    }

    public Integer getId() {
        return this.id;
    }

    public Date getModified() {
        return this.modified;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourcesId() {
        return this.sourcesId;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSourcesId(String sourcesId) {
        this.sourcesId = sourcesId;
    }
}

