/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Alert;
import org.sciplore.resources.Citation;
import org.sciplore.resources.DocumentFulltext;
import org.sciplore.resources.DocumentPerson;
import org.sciplore.resources.DocumentXref;
import org.sciplore.resources.Feedback;
import org.sciplore.resources.FulltextUrl;
import org.sciplore.resources.Institution;
import org.sciplore.resources.Keyword;
import org.sciplore.resources.Person;
import org.sciplore.resources.Resource;
import org.sciplore.resources.Venue;

@Entity
@Table(name="documents")
@FetchProfile(name="documents-with-persons", fetchOverrides={@FetchProfile.FetchOverride(entity=Document.class, association="persons", mode=FetchMode.JOIN), @FetchProfile.FetchOverride(entity=DocumentPerson.class, association="person", mode=FetchMode.JOIN)})
public class Document
extends Resource {
    @OneToMany(mappedBy="document")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Alert> alerts = new HashSet<Alert>();
    @OneToMany(mappedBy="parent")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Document> children = new HashSet<Document>();
    @OneToMany(mappedBy="citingDocument")
    private Set<Citation> citations = new HashSet<Citation>();
    @Column(nullable=false)
    private String cleantitle;
    @Column(name="abstract")
    private String documentAbstract;
    private String doi;
    private Short edition;
    @OneToMany(mappedBy="document")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Feedback> feedbacks = new HashSet<Feedback>();
    private Integer flags;
    @OneToMany(mappedBy="document")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<DocumentFulltext> fulltexts = new HashSet<DocumentFulltext>();
    @OneToMany(mappedBy="document")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<FulltextUrl> fulltextUrls = new HashSet<FulltextUrl>();
    @Column(nullable=false)
    private String hash = "";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(nullable=false)
    private Integer id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="institution_id")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Institution institution;
    private String isbn;
    private String issn;
    @OneToMany(mappedBy="document")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Set<Keyword> keywords = new HashSet<Keyword>();
    private String language;
    private String number;
    private String pages;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Document parent;
    @OneToMany(mappedBy="document", fetch=FetchType.LAZY)
    private Set<DocumentPerson> persons = new HashSet<DocumentPerson>();
    private Short publishedDay;
    private String publishedMonth;
    private String publishedPlace;
    private Short publishedYear;
    private String publisher;
    @OneToMany(mappedBy="citedDocument")
    private Set<Citation> rcvdCitations = new HashSet<Citation>();
    private String series;
    @Column(nullable=false)
    private String title;
    private String type;
    @Column(nullable=false)
    private Short valid = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="venue_id")
    private Venue venue;
    private String volume;
    @OneToMany(mappedBy="document")
    private Set<DocumentXref> xrefs = new HashSet<DocumentXref>();

    public static String generateCleanTitle(String title) {
        if (title == null) {
            return "";
        }
        if ((title = title.toLowerCase().replaceAll("[^A-Za-z0-9]", "")).length() > 1024) {
            title = title.substring(0, 1023);
        }
        return title;
    }

    public Document getDocument(Document d) {
        Document doc = null;
        String[] sources = new String[]{"dblp"};
        if (d.getId() != null) {
            return this.getDocument(d.getId());
        }
        block0: for (DocumentXref x : d.getXrefs()) {
            String[] stringArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (x.getSource().equals(s)) {
                    doc = this.getDocumentBySourceId(s, x.getSourcesId());
                    break block0;
                }
                ++n2;
            }
        }
        if (doc != null) {
            return doc;
        }
        return this.getDocument(d.getTitle());
    }

    public Document getDocument(Integer id) {
        this.getSession().enableFetchProfile("documents-with-persons");
        Document d = (Document)this.getSession().get(Document.class, (Serializable)id);
        this.getSession().disableFetchProfile("documents-with-persons");
        return d;
    }

    public Document getDocument(String title) {
        return (Document)this.getSession().createCriteria(Document.class).add((Criterion)Restrictions.like((String)"cleantitle", (Object)Document.generateCleanTitle(title))).setMaxResults(1).uniqueResult();
    }

    public Document getDocumentBySourceId(String source, String id) {
        DocumentXref x = (DocumentXref)this.getSession().createCriteria(DocumentXref.class).add((Criterion)Restrictions.like((String)"source", (Object)source)).add((Criterion)Restrictions.like((String)"sourcesId", (Object)id)).setMaxResults(1).uniqueResult();
        if (x != null) {
            return x.getDocument();
        }
        return null;
    }

    public int getDocumentCountBySourceId(String source) {
        Criteria criteria = this.getSession().createCriteria(DocumentXref.class).add((Criterion)Restrictions.like((String)"source", (Object)source));
        criteria.setProjection(Projections.rowCount());
        int result = ((Long)criteria.list().get(0)).intValue();
        return result;
    }

    public List<Document> getDocumentsBySourceId(String source, Short start, Short maxresults) {
        List ds = this.getSession().createCriteria(Document.class).createCriteria("xrefs").add((Criterion)Restrictions.like((String)"source", (Object)source)).setMaxResults((int)maxresults.shortValue()).setFirstResult((int)start.shortValue()).list();
        return ds;
    }

    public List<Document> getDocumentsBySourceID(String source, String search, int maxResult) {
        List ds = this.getSession().createCriteria(Document.class).add((Criterion)Restrictions.or((Criterion)Restrictions.like((String)"cleantitle", (Object)(String.valueOf(Document.generateCleanTitle(search)) + "%")), (Criterion)Restrictions.like((String)"documentAbstract", (Object)(String.valueOf(search) + "%")))).createCriteria("xrefs").add((Criterion)Restrictions.like((String)"source", (Object)source)).setMaxResults(maxResult).list();
        return ds;
    }

    public List<Document> getDocuments() {
        List ds = this.getSession().createCriteria(Document.class).list();
        return ds;
    }

    public List<Document> getDocuments(Short max) {
        List ds = this.getSession().createCriteria(Document.class).setMaxResults((int)max.shortValue()).list();
        return ds;
    }

    public List<Document> getDocuments(Integer start, Short max) {
        List ds = this.getSession().createCriteria(Document.class).setMaxResults((int)max.shortValue()).setFirstResult(start.intValue()).list();
        return ds;
    }

    public List<Document> getDocuments(String search) {
        List ds = this.getSession().createCriteria(Document.class).add((Criterion)Restrictions.like((String)"cleantitle", (Object)(String.valueOf(Document.generateCleanTitle(search)) + "%"))).setMaxResults(10).list();
        return ds;
    }

    public List<Document> getDocuments(String search, Short start, Short maxresults) {
        List ds = this.getSession().createCriteria(Document.class).add((Criterion)Restrictions.like((String)"cleantitle", (Object)(String.valueOf(Document.generateCleanTitle(search)) + "%"))).setMaxResults((int)maxresults.shortValue()).setFirstResult((int)start.shortValue()).list();
        return ds;
    }

    public List<Document> getRecentDocuments(String source, Short maxResults) {
        return this.getSession().createCriteria(Document.class).addOrder(Order.desc((String)"publishedYear")).addOrder(Order.desc((String)"publishedMonth")).addOrder(Order.desc((String)"publishedDay")).createCriteria("xrefs").add((Criterion)Restrictions.like((String)"source", (Object)source)).setMaxResults((int)maxResults.shortValue()).list();
    }

    public Document() {
    }

    public Document(Session s) {
        this.setSession(s);
    }

    public Document(Session s, Integer id, String title) {
        this.setSession(s);
        this.setId(id);
        this.setTitle(title);
    }

    public Document(Session s, Integer id) {
        this.setSession(s);
        this.id = id;
    }

    public Document(Session s, String title) {
        this.setSession(s);
        this.setTitle(title);
    }

    public void addAlert(Alert a) {
        this.alerts.add(a);
    }

    public void addChild(Document c) {
        this.children.add(c);
    }

    public void addCitation(Citation c) {
        this.citations.add(c);
    }

    public void addKeyword(Keyword k) {
        this.keywords.add(k);
    }

    public void addPerson(DocumentPerson p) {
        this.persons.add(p);
    }

    public void addPerson(Person p) {
        this.persons.add(new DocumentPerson(this.getSession(), p));
    }

    public void addRcvdCitation(Citation c) {
        this.rcvdCitations.add(c);
    }

    public void addXref(DocumentXref x) {
        x.setDocument(this);
        this.xrefs.add(x);
    }

    public String getAbstract() {
        return this.documentAbstract;
    }

    public Set<Alert> getAlerts() {
        return this.alerts;
    }

    public Set<Document> getChildren() {
        return this.children;
    }

    public Set<Citation> getCitations() {
        return this.citations;
    }

    public Set<Citation> getCleanCitations() {
        HashSet<Citation> cleanCitations = new HashSet<Citation>();
        boolean isDuplicate = false;
        for (Citation citation : this.citations) {
            for (Citation cleanCitation : cleanCitations) {
                if (citation.getCitedDocument().getId() != cleanCitation.getCitedDocument().getId()) continue;
                isDuplicate = true;
                break;
            }
            if (!isDuplicate) {
                cleanCitations.add(citation);
            }
            isDuplicate = false;
        }
        return cleanCitations;
    }

    public String getCleantitle() {
        return this.cleantitle;
    }

    public String getDoi() {
        return this.doi;
    }

    public Short getEdition() {
        return this.edition;
    }

    public Set<Feedback> getFeedbacks() {
        return this.feedbacks;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public Set<DocumentFulltext> getFulltexts() {
        return this.fulltexts;
    }

    public Set<FulltextUrl> getFulltextUrls() {
        return this.fulltextUrls;
    }

    public String getHash() {
        return this.hash;
    }

    public Integer getId() {
        return this.id;
    }

    public Institution getInstitution() {
        return this.institution;
    }

    public String getIsbn() {
        return this.isbn;
    }

    public String getIssn() {
        return this.issn;
    }

    public Set<Keyword> getKeywords() {
        return this.keywords;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getNumber() {
        return this.number;
    }

    public String getPages() {
        return this.pages;
    }

    public Document getParent() {
        return this.parent;
    }

    public Set<DocumentPerson> getPersons() {
        return this.persons;
    }

    public Short getPublishedDay() {
        return this.publishedDay;
    }

    public String getPublishedMonth() {
        return this.publishedMonth;
    }

    public String getPublishedPlace() {
        return this.publishedPlace;
    }

    public Short getPublishedYear() {
        return this.publishedYear;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public Set<Citation> getRcvdCitations() {
        return this.rcvdCitations;
    }

    public String getSeries() {
        return this.series;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public Short getValid() {
        return this.valid;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public String getVolume() {
        return this.volume;
    }

    public Set<DocumentXref> getXrefs() {
        return this.xrefs;
    }

    public void setAbstract(String documentAbstract) {
        this.documentAbstract = documentAbstract;
    }

    public void setAlerts(Set<Alert> alerts) {
        this.alerts = alerts;
    }

    public void setChildren(Set<Document> children) {
        this.children = children;
    }

    public void setCitations(Set<Citation> citations) {
        this.citations = citations;
    }

    public void setCleantitle(String cleantitle) {
        this.cleantitle = cleantitle;
    }

    public void setDoi(String doi) {
        this.doi = doi;
    }

    public void setEdition(Short edition) {
        this.edition = edition;
    }

    public void setFeedbacks(Set<Feedback> feedbacks) {
        this.feedbacks = feedbacks;
    }

    public void setFlags(Integer flags) {
        this.flags = flags;
    }

    public void setFulltexts(Set<DocumentFulltext> fulltexts) {
        this.fulltexts = fulltexts;
    }

    public void setFulltextUrls(Set<FulltextUrl> fulltextUrls) {
        this.fulltextUrls = fulltextUrls;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInstitution(Institution institution) {
        this.institution = institution;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public void setIssn(String issn) {
        this.issn = issn;
    }

    public void setKeywords(Set<Keyword> keywords) {
        this.keywords = keywords;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public void setPages(String pages) {
        this.pages = pages;
    }

    public void setParent(Document parent) {
        this.parent = parent;
    }

    public void setPersons(Set<DocumentPerson> persons) {
        this.persons = persons;
    }

    public void setPublishedDay(Short publishedDay) {
        this.publishedDay = publishedDay;
    }

    public void setPublishedMonth(String publishedMonth) {
        this.publishedMonth = publishedMonth;
    }

    public void setPublishedPlace(String publishedPlace) {
        this.publishedPlace = publishedPlace;
    }

    public void setPublishedYear(Short publishedYear) {
        this.publishedYear = publishedYear;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setRcvdCitations(Set<Citation> rcvdCitations) {
        this.rcvdCitations = rcvdCitations;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setCleantitle(Document.generateCleanTitle(title));
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }

    public void setVenue(Venue venue) {
        this.venue = venue;
    }

    public void setVolume(String volume) {
        this.volume = volume;
    }

    public void setXrefs(Set<DocumentXref> xrefs) {
        this.xrefs = xrefs;
    }

    public String toString() {
        return this.title;
    }
}

