/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.BezierEdgeView;
import freemind.view.mindmapview.BubbleMainView;
import freemind.view.mindmapview.EdgeView;
import freemind.view.mindmapview.ForkMainView;
import freemind.view.mindmapview.LeftNodeViewLayout;
import freemind.view.mindmapview.LinearEdgeView;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import freemind.view.mindmapview.RightNodeViewLayout;
import freemind.view.mindmapview.RootMainView;
import freemind.view.mindmapview.SharpBezierEdgeView;
import freemind.view.mindmapview.SharpLinearEdgeView;
import freemind.view.mindmapview.VerticalRootNodeViewLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JComponent;

class NodeViewFactory {
    private static NodeViewFactory factory;
    private EdgeView sharpBezierEdgeView;
    private EdgeView sharpLinearEdgeView;
    private EdgeView bezierEdgeView;
    private EdgeView linearEdgeView;

    private NodeViewFactory() {
    }

    static NodeViewFactory getInstance() {
        if (factory == null) {
            factory = new NodeViewFactory();
        }
        return factory;
    }

    EdgeView getEdge(NodeView newView) {
        String edgeStyle = newView.getModel().getEdge().getStyle();
        if (edgeStyle.equals("linear")) {
            return this.getLinearEdgeView();
        }
        if (edgeStyle.equals("bezier")) {
            return this.getBezierEdgeView();
        }
        if (edgeStyle.equals("sharp_linear")) {
            return this.getSharpEdgeView();
        }
        if (edgeStyle.equals("sharp_bezier")) {
            return this.getSharpBezierEdgeView();
        }
        System.err.println("Unknown Edge Type.");
        return this.getLinearEdgeView();
    }

    private EdgeView getSharpBezierEdgeView() {
        if (this.sharpBezierEdgeView == null) {
            this.sharpBezierEdgeView = new SharpBezierEdgeView();
        }
        return this.sharpBezierEdgeView;
    }

    private EdgeView getSharpEdgeView() {
        if (this.sharpLinearEdgeView == null) {
            this.sharpLinearEdgeView = new SharpLinearEdgeView();
        }
        return this.sharpLinearEdgeView;
    }

    private EdgeView getBezierEdgeView() {
        if (this.bezierEdgeView == null) {
            this.bezierEdgeView = new BezierEdgeView();
        }
        return this.bezierEdgeView;
    }

    private EdgeView getLinearEdgeView() {
        if (this.linearEdgeView == null) {
            this.linearEdgeView = new LinearEdgeView();
        }
        return this.linearEdgeView;
    }

    NodeView newNodeView(MindMapNode model, int position, MapView map, Container parent) {
        NodeView newView = new NodeView(model, position, map, parent);
        if (model.isRoot()) {
            RootMainView mainView = new RootMainView();
            newView.setMainView(mainView);
            newView.setLayout(VerticalRootNodeViewLayout.getInstance());
        } else {
            newView.setMainView(this.newMainView(model));
            if (newView.isLeft()) {
                newView.setLayout(LeftNodeViewLayout.getInstance());
            } else {
                newView.setLayout(RightNodeViewLayout.getInstance());
            }
        }
        model.addViewer(newView);
        newView.update();
        this.fireNodeViewCreated(newView);
        return newView;
    }

    MainView newMainView(MindMapNode model) {
        if (model.isRoot()) {
            return new RootMainView();
        }
        if (model.getStyle().equals("fork")) {
            return new ForkMainView();
        }
        if (model.getStyle().equals("bubble")) {
            return new BubbleMainView();
        }
        System.err.println("Tried to create a NodeView of unknown Style.");
        return new ForkMainView();
    }

    private void fireNodeViewCreated(NodeView newView) {
        newView.getMap().getModel().getModeController().onViewCreatedHook(newView);
    }

    JComponent newContentPane(NodeView view) {
        return new ContentPane();
    }

    private static class ContentPaneLayout
    implements LayoutManager {
        private ContentPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int componentCount = parent.getComponentCount();
            int width = parent.getWidth();
            int y = 0;
            for (int i = 0; i < componentCount; ++i) {
                Component component = parent.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension preferredCompSize = component.getPreferredSize();
                if (component instanceof MainView) {
                    component.setBounds(0, y, width, preferredCompSize.height);
                } else {
                    int x = (int)(component.getAlignmentX() * (float)(width - preferredCompSize.width));
                    component.setBounds(x, y, preferredCompSize.width, preferredCompSize.height);
                }
                y += preferredCompSize.height;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension prefSize = new Dimension(0, 0);
            int componentCount = parent.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component component = parent.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension preferredCompSize = component.getPreferredSize();
                prefSize.height += preferredCompSize.height;
                prefSize.width = Math.max(prefSize.width, preferredCompSize.width);
            }
            return prefSize;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static class ContentPane
    extends JComponent {
        private static LayoutManager layoutManager = new ContentPaneLayout();

        ContentPane() {
            this.setLayout(layoutManager);
        }
    }
}

