/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.controller.FreeMindPopupMenu;
import freemind.controller.LastOpenedList;
import freemind.controller.MapModuleManager;
import freemind.controller.StructuredMenuHolder;
import freemind.main.Resources;
import freemind.modes.ModeController;
import freemind.view.MapModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import splmm.Actions.AutoImportActionListener;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;

public class MenuBar
extends JMenuBar {
    private static Logger logger;
    public static final String MENU_BAR_PREFIX = "menu_bar/";
    public static final String GENERAL_POPUP_PREFIX = "popup/";
    public static final String POPUP_MENU = "popup/popup/";
    public static final String INSERT_MENU = "menu_bar/insert/";
    public static final String NAVIGATE_MENU = "menu_bar/navigate/";
    public static final String VIEW_MENU = "menu_bar/view/";
    public static final String HELP_MENU = "menu_bar/help/";
    public static final String MINDMAP_MENU = "menu_bar/mindmaps/";
    private static final String MENU_MINDMAP_CATEGORY = "menu_bar/mindmaps/mindmaps";
    public static final String MODES_MENU = "menu_bar/mindmaps/";
    public static final String EDIT_MENU = "menu_bar/edit/";
    public static final String FILE_MENU = "menu_bar/file/";
    public static final String FORMAT_MENU = "menu_bar/format/";
    public static final String EXTRAS_MENU = "menu_bar/extras/";
    public static final String SCIPLORE_MENU = "menu_bar/sciplore/";
    private StructuredMenuHolder menuHolder;
    JPopupMenu mapsPopupMenu;
    private JMenu filemenu;
    private JMenu editmenu;
    private JMenu mapsmenu;
    Controller c;
    ActionListener mapsMenuActionListener = new MapsMenuActionListener();
    ActionListener lastOpenedActionListener = new LastOpenedActionListener();
    private JMenu formatmenu;

    public MenuBar(Controller controller) {
        this.c = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void updateMenus(ModeController newModeController) {
        this.removeAll();
        this.menuHolder = new StructuredMenuHolder();
        this.filemenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("file")), "menu_bar/file/.");
        this.menuHolder.addCategory("menu_bar/file/open");
        this.menuHolder.addCategory("menu_bar/file/close");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/export");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/import");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/print");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/last");
        this.menuHolder.addSeparator(FILE_MENU);
        this.menuHolder.addCategory("menu_bar/file/quit");
        this.editmenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("edit")), "menu_bar/edit/.");
        this.menuHolder.addCategory("menu_bar/edit/undo");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/select");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/paste");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/edit");
        this.menuHolder.addSeparator(EDIT_MENU);
        this.menuHolder.addCategory("menu_bar/edit/find");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_view")), "menu_bar/view/.");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_insert")), "menu_bar/insert/.");
        this.menuHolder.addCategory("menu_bar/insert/nodes");
        this.menuHolder.addSeparator(INSERT_MENU);
        this.menuHolder.addCategory("menu_bar/insert/icons");
        this.menuHolder.addSeparator(INSERT_MENU);
        this.formatmenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_format")), "menu_bar/format/.");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_navigate")), "menu_bar/navigate/.");
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_extras")), "menu_bar/extras/.");
        this.menuHolder.addCategory("menu_bar/extras/first");
        this.mapsmenu = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("mindmaps")), "menu_bar/mindmaps/.");
        this.menuHolder.addCategory("menu_bar/mindmaps/navigate");
        this.menuHolder.addSeparator("menu_bar/mindmaps/");
        this.menuHolder.addCategory(MENU_MINDMAP_CATEGORY);
        this.menuHolder.addSeparator("menu_bar/mindmaps/");
        this.menuHolder.addCategory("menu_bar/mindmaps/");
        this.mapsPopupMenu = new FreeMindPopupMenu();
        this.mapsPopupMenu.setName(this.c.getResourceString("mindmaps"));
        this.menuHolder.addCategory("popup/popup/navigate");
        JMenu sciploreMenu = new JMenu(LocalizationSupport.message((String)"splmm_menu_name"));
        sciploreMenu.setFont(new Font("sansserif", 1, 13));
        this.menuHolder.addMenu(sciploreMenu, "menu_bar/sciplore/.");
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(LocalizationSupport.message((String)"splmm_menu_autoimport"));
        item.setSelected(SplmmPreferences.getAutoImport());
        item.addActionListener((ActionListener)new AutoImportActionListener());
        this.menuHolder.addMenuItem(item, "menu_bar/sciplore/splmm_menu_autoimport");
        this.menuHolder.addCategory("menu_bar/sciplore/sciplore_sub_menu");
        JMenu view = this.menuHolder.addMenu(new JMenu(LocalizationSupport.message((String)"splmm_menu_submenuView")), "menu_bar/sciplore/view/.");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem itemShowAll = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(new JRadioButtonMenuItem(this.c.showAllAttributes), "menu_bar/sciplore/view/showAllAttributes");
        itemShowAll.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_show_all_attributes")));
        buttonGroup.add(itemShowAll);
        JRadioButtonMenuItem itemShowSelected = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(new JRadioButtonMenuItem(this.c.showSelectedAttributes), "menu_bar/sciplore/view/showSelectedAttributes");
        itemShowSelected.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_show_selected_attributes")));
        buttonGroup.add(itemShowSelected);
        JRadioButtonMenuItem itemHideAll = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(new JRadioButtonMenuItem(this.c.hideAllAttributes), "menu_bar/sciplore/view/hideAllAttributes");
        itemHideAll.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_hide_all_attributes")));
        buttonGroup.add(itemHideAll);
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("help")), "menu_bar/help/.");
        this.menuHolder.addAction(this.c.splmmDocumentation, "menu_bar/help/doc/splmmDocumentation");
        this.menuHolder.addAction(this.c.documentation, "menu_bar/help/doc/documentation");
        this.menuHolder.addAction(this.c.freemindUrl, "menu_bar/help/doc/freemind");
        this.menuHolder.addAction(this.c.faq, "menu_bar/help/doc/faq");
        this.menuHolder.addAction(this.c.keyDocumentation, "menu_bar/help/doc/keyDocumentation");
        this.menuHolder.addSeparator(HELP_MENU);
        this.menuHolder.addAction(this.c.license, "menu_bar/help/about/license");
        this.menuHolder.addAction(this.c.about, "menu_bar/help/about/about");
        this.updateFileMenu();
        this.updateViewMenu();
        this.updateEditMenu();
        this.updateModeMenu();
        this.updateMapsMenu(this.menuHolder, "menu_bar/mindmaps/mindmaps/");
        this.updateMapsMenu(this.menuHolder, POPUP_MENU);
        this.addAdditionalPopupActions();
        newModeController.updateMenus(this.menuHolder);
        this.menuHolder.updateMenus(this, MENU_BAR_PREFIX);
        this.menuHolder.updateMenus(this.mapsPopupMenu, GENERAL_POPUP_PREFIX);
    }

    private void updateModeMenu() {
        ButtonGroup group = new ButtonGroup();
        ModesMenuActionListener modesMenuActionListener = new ModesMenuActionListener();
        LinkedList keys = new LinkedList(this.c.getModes());
        ListIterator i = keys.listIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.c.getResourceString("mode_" + key));
            item.setActionCommand(key);
            JRadioButtonMenuItem newItem = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(item, "menu_bar/mindmaps/" + key);
            group.add(newItem);
            if (this.c.getMode() != null) {
                newItem.setSelected(this.c.getMode().toString().equals(key));
            } else {
                newItem.setSelected(false);
            }
            String keystroke = this.c.getFrame().getAdjustableProperty("keystroke_mode_" + key);
            if (keystroke != null) {
                newItem.setAccelerator(KeyStroke.getKeyStroke(keystroke));
            }
            newItem.addActionListener(modesMenuActionListener);
        }
    }

    private void addAdditionalPopupActions() {
        JMenuItem newPopupItem;
        this.menuHolder.addSeparator(POPUP_MENU);
        if (this.c.getFrame().isApplet()) {
            newPopupItem = this.menuHolder.addAction(this.c.toggleMenubar, "popup/popup/toggleMenubar");
            newPopupItem.setForeground(new Color(100, 80, 80));
        }
        newPopupItem = this.menuHolder.addAction(this.c.toggleToolbar, "popup/popup/toggleToolbar");
        newPopupItem.setForeground(new Color(100, 80, 80));
        newPopupItem = this.menuHolder.addAction(this.c.toggleLeftToolbar, "popup/popup/toggleLeftToolbar");
        newPopupItem.setForeground(new Color(100, 80, 80));
    }

    private void updateMapsMenu(StructuredMenuHolder holder, String basicKey) {
        MapModuleManager mapModuleManager = this.c.getMapModuleManager();
        List mapModuleVector = mapModuleManager.getMapModuleVector();
        if (mapModuleVector == null) {
            return;
        }
        ButtonGroup group = new ButtonGroup();
        for (MapModule mapModule : mapModuleVector) {
            String displayName = mapModule.getDisplayName();
            JRadioButtonMenuItem newItem = new JRadioButtonMenuItem(displayName);
            newItem.setSelected(false);
            group.add(newItem);
            newItem.addActionListener(this.mapsMenuActionListener);
            newItem.setMnemonic(displayName.charAt(0));
            MapModule currentMapModule = mapModuleManager.getMapModule();
            if (currentMapModule != null && mapModule == currentMapModule) {
                newItem.setSelected(true);
            }
            holder.addMenuItem(newItem, basicKey + displayName);
        }
    }

    private void updateFileMenu() {
        this.menuHolder.addAction(this.c.page, "menu_bar/file/print/pageSetup");
        JMenuItem print = this.menuHolder.addAction(this.c.print, "menu_bar/file/print/print");
        print.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_print")));
        JMenuItem printPreview = this.menuHolder.addAction(this.c.printPreview, "menu_bar/file/print/printPreview");
        printPreview.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_print_preview")));
        JMenuItem close = this.menuHolder.addAction(this.c.close, "menu_bar/file/close/close");
        close.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_close")));
        JMenuItem quit = this.menuHolder.addAction(this.c.quit, "menu_bar/file/quit/quit");
        quit.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_quit")));
        this.updateLastOpenedList();
    }

    private void updateLastOpenedList() {
        this.menuHolder.addMenu(new JMenu(this.c.getResourceString("most_recent_files")), "menu_bar/file/last/.");
        boolean firstElement = true;
        LastOpenedList lst = this.c.getLastOpenedList();
        ListIterator it = lst.listIterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            JMenuItem item = new JMenuItem(key);
            if (firstElement) {
                firstElement = false;
                item.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_open_first_in_history")));
            }
            item.addActionListener(this.lastOpenedActionListener);
            this.menuHolder.addMenuItem(item, "menu_bar/file/last/" + key.replace('/', '_'));
        }
    }

    private void updateEditMenu() {
        JMenuItem moveToRoot = this.menuHolder.addAction(this.c.moveToRoot, "menu_bar/navigate/nodes/moveToRoot");
        moveToRoot.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_moveToRoot")));
        JMenuItem previousMap = this.menuHolder.addAction(this.c.navigationPreviousMap, "menu_bar/mindmaps/navigate/navigationPreviousMap");
        previousMap.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_previousMap")));
        JMenuItem nextMap = this.menuHolder.addAction(this.c.navigationNextMap, "menu_bar/mindmaps/navigate/navigationNextMap");
        nextMap.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_nextMap")));
    }

    private void updateViewMenu() {
        JMenuItem toggleToolbar = this.menuHolder.addAction(this.c.toggleToolbar, "menu_bar/view/toolbars/toggleToolbar");
        JMenuItem toggleLeftToolbar = this.menuHolder.addAction(this.c.toggleLeftToolbar, "menu_bar/view/toolbars/toggleLeftToolbar");
        this.menuHolder.addSeparator(VIEW_MENU);
        JMenuItem showSelectionAsRectangle = this.menuHolder.addAction(this.c.showSelectionAsRectangle, "menu_bar/view/general/selectionAsRectangle");
        JMenuItem zoomIn = this.menuHolder.addAction(this.c.zoomIn, "menu_bar/view/zoom/zoomIn");
        zoomIn.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_zoom_in")));
        JMenuItem zoomOut = this.menuHolder.addAction(this.c.zoomOut, "menu_bar/view/zoom/zoomOut");
        zoomOut.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_zoom_out")));
        this.menuHolder.addSeparator(VIEW_MENU);
        this.menuHolder.addCategory("menu_bar/view/note_window");
        this.menuHolder.addSeparator(VIEW_MENU);
        JMenu attributes = this.menuHolder.addMenu(new JMenu(this.c.getResourceString("menu_attributes")), "menu_bar/view/attributes/.");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem itemShowAll = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(new JRadioButtonMenuItem(this.c.showAllAttributes), "menu_bar/view/attributes/showAllAttributes");
        itemShowAll.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_show_all_attributes")));
        buttonGroup.add(itemShowAll);
        JRadioButtonMenuItem itemShowSelected = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(new JRadioButtonMenuItem(this.c.showSelectedAttributes), "menu_bar/view/attributes/showSelectedAttributes");
        itemShowSelected.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_show_selected_attributes")));
        buttonGroup.add(itemShowSelected);
        JRadioButtonMenuItem itemHideAll = (JRadioButtonMenuItem)this.menuHolder.addMenuItem(new JRadioButtonMenuItem(this.c.hideAllAttributes), "menu_bar/view/attributes/hideAllAttributes");
        itemHideAll.setAccelerator(KeyStroke.getKeyStroke(this.c.getFrame().getAdjustableProperty("keystroke_hide_all_attributes")));
        buttonGroup.add(itemHideAll);
    }

    private void addOptionSet(Action action, String[] textIDs, JMenu menu, String selectedTextID) {
        ButtonGroup group = new ButtonGroup();
        for (int optionIdx = 0; optionIdx < textIDs.length; ++optionIdx) {
            String keystroke;
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setText(this.c.getResourceString(textIDs[optionIdx]));
            item.setActionCommand(textIDs[optionIdx]);
            group.add(item);
            menu.add(item);
            if (selectedTextID != null) {
                item.setSelected(selectedTextID.equals(textIDs[optionIdx]));
            }
            if ((keystroke = this.c.getFrame().getAdjustableProperty("keystroke_" + textIDs[optionIdx])) == null) continue;
            item.setAccelerator(KeyStroke.getKeyStroke(keystroke));
        }
    }

    JPopupMenu getMapsPopupMenu() {
        return this.mapsPopupMenu;
    }

    private void copyMenuItems(JMenu source, JMenu dest) {
        Component[] items = source.getMenuComponents();
        for (int i = 0; i < items.length; ++i) {
            dest.add(items[i]);
        }
    }

    public StructuredMenuHolder getMenuHolder() {
        return this.menuHolder;
    }

    @Override
    public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    private class ModesMenuActionListener
    implements ActionListener {
        private ModesMenuActionListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuBar.this.c.createNewMode(e.getActionCommand());
                }
            });
        }
    }

    private class LastOpenedActionListener
    implements ActionListener {
        private LastOpenedActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String restoreable = e.getActionCommand();
            try {
                MenuBar.this.c.getLastOpenedList().open(restoreable);
            }
            catch (Exception ex) {
                MenuBar.this.c.errorMessage("An error occured on opening the file: " + restoreable + ".");
                Resources.getInstance().logException(ex);
            }
        }
    }

    private class MapsMenuActionListener
    implements ActionListener {
        private MapsMenuActionListener() {
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuBar.this.c.getMapModuleManager().changeToMapModule(e.getActionCommand());
                }
            });
        }
    }
}

