/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.controller.FreeMindToolBar;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JToggleButton;

public class MainToolBar
extends FreeMindToolBar {
    private JComboBox zoom;
    Controller controller;
    String userDefinedZoom;
    private static Logger logger = null;

    public MainToolBar(Controller controller) {
        this.setRollover(true);
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
        this.userDefinedZoom = controller.getResourceString("user_defined_zoom");
        this.add(controller.navigationPreviousMap);
        this.add(controller.navigationNextMap);
        this.add(controller.printDirect);
        JToggleButton btnFilter = new JToggleButton(controller.showFilterToolbarAction);
        btnFilter.setMargin(new Insets(0, 0, 0, 0));
        btnFilter.setFocusable(false);
        btnFilter.setContentAreaFilled(false);
        btnFilter.setToolTipText(controller.getResourceString("filter_toolbar"));
        this.add(btnFilter);
        this.zoom = new JComboBox<String>(controller.getZooms());
        this.zoom.setSelectedItem("100%");
        this.zoom.addItem(this.userDefinedZoom);
        this.zoom.setFocusable(false);
        this.add(this.zoom);
        this.zoom.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MainToolBar.this.setZoomByItem(e.getItem());
                }
            }
        });
    }

    private void setZoomByItem(Object item) {
        if (((String)item).equals(this.userDefinedZoom)) {
            return;
        }
        float zoomValue = this.getZoomValue(item);
        this.controller.setZoom(zoomValue);
    }

    private float getZoomValue(Object item) {
        String dirty = (String)item;
        String cleaned = dirty.substring(0, dirty.length() - 1);
        float zoomValue = (float)Integer.parseInt(cleaned, 10) / 100.0f;
        return zoomValue;
    }

    public void zoomOut() {
        float currentZoomIndex = this.getCurrentZoomIndex();
        if (currentZoomIndex > 0.0f) {
            this.setZoomByItem(this.zoom.getItemAt((int)(currentZoomIndex - 0.5f)));
        }
    }

    private float getCurrentZoomIndex() {
        int itemCount;
        int selectedIndex = this.zoom.getSelectedIndex();
        if (selectedIndex != (itemCount = this.zoom.getItemCount()) - 1) {
            return selectedIndex;
        }
        float userZoom = this.controller.getView().getZoom();
        for (int i = 0; i < itemCount - 1; ++i) {
            if (!(userZoom < this.getZoomValue(this.zoom.getItemAt(i)))) continue;
            return (float)i - 0.5f;
        }
        return (float)itemCount - 0.5f;
    }

    public void zoomIn() {
        float currentZoomIndex = this.getCurrentZoomIndex();
        if (currentZoomIndex < (float)(this.zoom.getItemCount() - 1)) {
            this.setZoomByItem(this.zoom.getItemAt((int)(currentZoomIndex + 1.0f)));
        }
    }

    public String getItemForZoom(float f) {
        return (int)(f * 100.0f) + "%";
    }

    public void setZoomComboBox(float f) {
        logger.fine("setZoomComboBox is called with " + f + ".");
        String toBeFound = this.getItemForZoom(f);
        for (int i = 0; i < this.zoom.getItemCount(); ++i) {
            if (!toBeFound.equals((String)this.zoom.getItemAt(i))) continue;
            this.zoom.setSelectedItem(toBeFound);
            return;
        }
        this.zoom.setSelectedItem(this.userDefinedZoom);
    }

    public void setAllActions(boolean enabled) {
        if (this.zoom != null) {
            this.zoom.setEnabled(enabled);
        }
    }
}

