/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.writer.COSWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class STXRefSection {
    public static final COSName DK_XRefStm = COSName.constant("XRefStm");
    private STXRefSubsection xRefSubsection;
    private long offset = -1L;
    private STDocument doc;
    private STXRefSection previous;

    protected STXRefSection(STDocument doc) {
        this(doc, -1L);
    }

    protected STXRefSection(STDocument doc, long offset) {
        this.doc = doc;
        this.offset = offset;
        this.xRefSubsection = new STXRefSubsection(this, 0);
        this.xRefSubsection.addEntry(new STXRefEntryFree(0, 65535, 0));
    }

    public void addEntry(STXRefEntry entry) {
        STXRefSubsection prev = null;
        STXRefSubsection current = this.getXRefSubsection();
        int number = entry.getObjectNumber();
        while (current != null) {
            int start = current.getStart();
            int stop = current.getStop();
            if (number < start) {
                STXRefSubsection newSection = new STXRefSubsection(this, number);
                newSection.setNext(current);
                if (prev != null) {
                    prev.setNext(newSection);
                } else {
                    this.setXRefSubsection(newSection);
                }
                newSection.addEntry(entry);
                return;
            }
            if (start <= number && number <= stop) {
                current.addEntry(entry);
                return;
            }
            prev = current;
            current = current.getNext();
        }
        STXRefSubsection newSection = new STXRefSubsection(this, number);
        newSection.setNext(null);
        if (prev != null) {
            prev.setNext(newSection);
        } else {
            this.setXRefSubsection(newSection);
        }
        newSection.addEntry(entry);
    }

    public boolean contains(int number) {
        STXRefSubsection current = this.getXRefSubsection();
        while (current != null) {
            if (number < current.getStart()) {
                return false;
            }
            if (current.getStart() <= number && number < current.getStop()) {
                return true;
            }
            current = current.getNext();
        }
        return false;
    }

    public abstract COSDictionary cosGetDict();

    public abstract COSObject cosGetObject();

    protected void createNewSubsection(int pStart) {
    }

    public abstract STXRefSection createSuccessor();

    public Iterator entryIterator() {
        return new Iterator(){
            private Iterator currentIterator;
            private STXRefSubsection myNext;
            {
                this.myNext = STXRefSection.this.getXRefSubsection();
            }

            public boolean hasNext() {
                if (this.currentIterator != null && this.currentIterator.hasNext()) {
                    return true;
                }
                if (this.myNext != null) {
                    this.currentIterator = this.myNext.getEntries().iterator();
                    this.myNext = this.myNext.getNext();
                    return this.hasNext();
                }
                return false;
            }

            public Object next() {
                if (this.hasNext()) {
                    return this.currentIterator.next();
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public STDocument getDoc() {
        return this.doc;
    }

    public STXRefEntry getEntry(int number) {
        STXRefSubsection current = this.getXRefSubsection();
        while (current != null) {
            if (number < current.getStart()) {
                return null;
            }
            if (current.getStart() <= number && number < current.getStop()) {
                return current.getEntry(number);
            }
            current = current.getNext();
        }
        return null;
    }

    public COSArray getID() {
        return this.cosGetDict().get(COSTrailer.DK_ID).asArray();
    }

    public int getIncrementalCount() {
        if (this.getPrevious() == null) {
            return 1;
        }
        if (this.cosGetDict().get(COSTrailer.DK_Root).isNull()) {
            return this.getPrevious().getIncrementalCount();
        }
        return this.getPrevious().getIncrementalCount() + 1;
    }

    public int getMaxObjectNumber() {
        for (STXRefSubsection current = this.getXRefSubsection(); current != null; current = current.getNext()) {
            if (current.getNext() != null) {
                continue;
            }
            return current.getStop();
        }
        return 0;
    }

    public long getOffset() {
        return this.offset;
    }

    public STXRefSection getPrevious() {
        return this.previous;
    }

    public int getPreviousOffset() {
        COSInteger value = this.cosGetDict().get(COSTrailer.DK_Prev).asInteger();
        if (value == null) {
            return -1;
        }
        return value.intValue();
    }

    protected int getPreviousXRefStmOffset() {
        COSInteger value = this.cosGetDict().get(DK_XRefStm).asInteger();
        if (value == null) {
            return -1;
        }
        return value.intValue();
    }

    public int getSize() {
        COSInteger value = this.cosGetDict().get(COSTrailer.DK_Size).asInteger();
        if (value == null) {
            return -1;
        }
        return value.intValue();
    }

    public int getStart() {
        return this.getXRefSubsection().getStart();
    }

    public abstract AbstractXRefWriter getWriter(COSWriter var1);

    protected int getXRefStmOffset() {
        COSInteger value = this.cosGetDict().get(DK_XRefStm).asInteger();
        if (value == null) {
            return -1;
        }
        return value.intValue();
    }

    public STXRefSubsection getXRefSubsection() {
        return this.xRefSubsection;
    }

    protected abstract boolean isStreamed();

    public COSObject load(int objectNumber, ISystemSecurityHandler securityHandler) throws IOException, COSLoadException {
        if (this.contains(objectNumber)) {
            return this.getEntry(objectNumber).load(this.getDoc(), securityHandler);
        }
        if (this.getPrevious() != null) {
            return this.getPrevious().load(objectNumber, securityHandler);
        }
        return null;
    }

    protected void setCOSDoc(COSDocument doc) {
        doc.add(this.cosGetObject());
    }

    protected void setID(COSArray id) {
        this.cosGetDict().put(COSTrailer.DK_ID, id);
    }

    protected void setOffset(long offset) {
        this.offset = offset;
    }

    protected void setPrevious(STXRefSection xRefSection) {
        this.previous = xRefSection;
        if ((long)this.getPreviousOffset() != xRefSection.getOffset()) {
            this.setPreviousOffset(xRefSection.getOffset());
        }
    }

    protected void setPreviousOffset(long offset) {
        this.cosGetDict().put(COSTrailer.DK_Prev, COSInteger.create((int)offset));
    }

    protected void setSize(int size) {
        this.cosGetDict().put(COSTrailer.DK_Size, COSInteger.create(size));
    }

    protected void setXRefStmOffset(long xrefStmOffset) {
        this.cosGetDict().put(DK_XRefStm, COSInteger.create((int)xrefStmOffset));
    }

    protected void setXRefSubsection(STXRefSubsection newXRef) {
        this.xRefSubsection = newXRef;
        STXRefSubsection current = this.getXRefSubsection();
        while (current != null) {
            current.setXRefSection(this);
            current = current.getNext();
        }
    }

    public Iterator subsectionIterator() {
        return new Iterator(){
            private STXRefSubsection current;
            {
                this.current = STXRefSection.this.getXRefSubsection();
            }

            public boolean hasNext() {
                return this.current != null;
            }

            public Object next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                STXRefSubsection result = this.current;
                this.current = this.current.getNext();
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

