/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDPageTree
extends PDPageNode {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Kids = COSName.constant("Kids");
    public static final COSName DK_Count = COSName.constant("Count");
    private static final int MAX_KIDS = 1000;
    private SoftReference<List> cachedKids;

    protected PDPageTree(COSObject object) {
        super(object);
    }

    public void addNode(int index, PDPageNode newNode) {
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids == null) {
            cosKids = COSArray.create();
            this.cosSetField(DK_Kids, cosKids);
        }
        if ((index = Math.min(index, cosKids.size())) < 0) {
            index = cosKids.size();
        }
        newNode.setParent(this);
        cosKids.add(index, newNode.cosGetDict());
        this.incrementCount(newNode.getCount());
    }

    public void addNode(PDPageNode newNode) {
        this.addNodeAfter(newNode, null);
    }

    public void addNodeAfter(PDPageNode newNode, PDPageNode destination) {
        int destinationIndex = -1;
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids != null && destination != null) {
            destinationIndex = cosKids.indexOf(destination.cosGetDict());
        }
        int newNodeIndex = -1;
        if (destinationIndex > -1) {
            newNodeIndex = destinationIndex + 1;
        }
        this.addNode(newNodeIndex, newNode);
    }

    protected void collectAnnotations(List annotations) {
        for (PDPageNode childNode : this.getKids()) {
            childNode.collectAnnotations(annotations);
        }
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_Pages;
    }

    protected COSObject cosSetKids(COSArray newKids) {
        this.setCount(newKids.size());
        return this.cosSetField(DK_Kids, newKids);
    }

    protected void exchangeNode(PDPageNode oldNode, PDPageNode newNode) {
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids == null) {
            return;
        }
        int index = cosKids.indexOf(oldNode.cosGetDict());
        if (index >= 0) {
            oldNode.setParent(null);
            newNode.setParent(this);
            cosKids.set(index, newNode.cosGetDict());
        }
    }

    public int getCount() {
        return this.getFieldInt(DK_Count, 0);
    }

    public PDPageNode getFirstNode() {
        if (this.getKids().isEmpty()) {
            return null;
        }
        return (PDPageNode)this.getKids().get(0);
    }

    public PDPage getFirstPage() {
        for (PDPageNode node : this.getKids()) {
            PDPage page = node.getFirstPage();
            if (page == null) continue;
            return page;
        }
        return null;
    }

    public List getGenericChildren() {
        return this.getKids();
    }

    public List getKids() {
        ArrayList<COSBasedObject> kids = null;
        if (this.cachedKids != null) {
            kids = this.cachedKids.get();
        }
        if (kids == null) {
            kids = new ArrayList<COSBasedObject>();
            COSArray cosKids = this.cosGetField(DK_Kids).asArray();
            if (cosKids != null) {
                Iterator i = cosKids.iterator();
                while (i.hasNext()) {
                    COSBasedObject page = PDPageNode.META.createFromCos((COSObject)i.next());
                    if (page == null) continue;
                    kids.add(page);
                }
                cosKids.addObjectListener(this);
            }
            this.cachedKids = new SoftReference(kids);
        }
        return kids;
    }

    public PDPageNode getLastNode() {
        List theKids = this.getKids();
        if (theKids.isEmpty()) {
            return null;
        }
        return (PDPageNode)theKids.get(theKids.size() - 1);
    }

    public PDPage getLastPage() {
        List theKids = this.getKids();
        int i = theKids.size() - 1;
        while (i >= 0) {
            PDPageNode node = (PDPageNode)theKids.get(i);
            PDPage result = node.getLastPage();
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    protected PDPageNode getNextNode(PDPageNode node) {
        List children = this.getKids();
        int index = children.indexOf(node);
        if (index < 0) {
            return null;
        }
        if (index < children.size() - 1) {
            return (PDPageNode)children.get(index + 1);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getNextNode(this);
    }

    protected PDPage getNextPage(PDPage page) {
        PDPage nextPage = null;
        PDPageNode nextNode = this.getNextNode(page);
        while (nextNode != null) {
            nextPage = nextNode.getFirstPage();
            if (nextPage != null) break;
            nextNode = nextNode.getNextNode();
        }
        return nextPage;
    }

    protected int getNodeIndex(PDPageNode node) {
        int nodePos = 0;
        for (PDPageNode child : this.getKids()) {
            if (child == node) break;
            nodePos += child.getCount();
        }
        PDPageTree parent = this.getParent();
        if (parent == null) {
            return nodePos;
        }
        return nodePos + parent.getNodeIndex(this);
    }

    protected PDPageNode getPreviousNode(PDPageNode node) {
        List children = this.getKids();
        int index = children.indexOf(node);
        if (index < 0) {
            return null;
        }
        if (index > 0) {
            return (PDPageNode)children.get(index - 1);
        }
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getPreviousNode(this);
    }

    protected PDPage getPreviousPage(PDPage page) {
        PDPage previousPage = null;
        PDPageNode previousNode = this.getPreviousNode(page);
        while (previousNode != null) {
            previousPage = previousNode.getLastPage();
            if (previousPage != null) break;
            previousNode = previousNode.getPreviousNode();
        }
        return previousPage;
    }

    protected void incrementCount(int delta) {
        int oldValue = this.getCount();
        this.cosSetField(DK_Count, COSInteger.create(oldValue + delta));
        if (this.getParent() != null) {
            this.getParent().incrementCount(delta);
        }
    }

    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_Kids, COSArray.create());
        this.cosSetField(DK_Count, COSInteger.create(0));
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids != null) {
            cosKids.removeObjectListener(this);
        }
        this.cachedKids = null;
    }

    public boolean isPage() {
        return false;
    }

    public boolean isValid() {
        PDPageTree tempParent = this.getParent();
        if (tempParent == null) {
            PDDocument tempDoc = this.getDoc();
            if (tempDoc == null) {
                return false;
            }
            return tempDoc.getPageTree() == this;
        }
        return tempParent.isValid();
    }

    public PDPageTree rebalance() {
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids == null) {
            return null;
        }
        if (cosKids.size() > 1000) {
            PDPageTree newNode = (PDPageTree)META.createNew();
            if (this.getParent() != null) {
                this.getParent().exchangeNode(this, newNode);
            }
            newNode.addNode(this);
            return newNode;
        }
        return null;
    }

    public void removeNode(PDPageNode node) {
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids != null && cosKids.remove(node.cosGetObject())) {
            this.incrementCount(-node.getCount());
            node.setParent(null);
        }
    }

    protected void setCount(int newCount) {
        int oldValue = this.getCount();
        this.setFieldInt(DK_Count, newCount);
        if (this.getParent() != null) {
            this.getParent().incrementCount(newCount - oldValue);
        }
    }

    public static class MetaClass
    extends PDPageNode.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDPageTree(object);
        }
    }
}

