/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.HashSet;
import java.util.Set;

public class PDAFButtonField
extends PDAcroFormField {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Opt = COSName.constant("Opt");

    protected PDAFButtonField(COSObject object) {
        super(object);
    }

    public boolean isCheckbox() {
        return !this.isPushbutton() && !this.isRadio();
    }

    public COSName cosGetExpectedFieldType() {
        return CN_FT_Btn;
    }

    public void setPushbutton(boolean f) {
        this.getFieldFlags().setPushbutton(f);
    }

    public boolean isPushbutton() {
        return this.getFieldFlags().isPushbutton();
    }

    public boolean isRadio() {
        return this.getFieldFlags().isRadio();
    }

    public boolean isTypeBtn() {
        return true;
    }

    public COSObject cosSetValue(COSObject state) {
        if (this.isCheckbox() || this.isRadio()) {
            COSName newState = state instanceof COSName ? (COSName)state : (state == null ? PDWidgetAnnotation.CN_State_Off : COSName.create(state.stringValue()));
            for (PDWidgetAnnotation annot : this.getAnnotations()) {
                Set states = annot.getAppearanceStates();
                if (states.contains(newState)) {
                    annot.setAppearanceState((COSName)newState.copyOptional());
                    continue;
                }
                annot.setAppearanceState(PDWidgetAnnotation.CN_State_Off);
            }
            return super.cosSetValue(newState);
        }
        return COSNull.NULL;
    }

    public void setValueString(String value) {
        if (value == null) {
            super.setValueString(value);
        }
        if (this.isCheckbox() || this.isRadio()) {
            COSName state = COSName.create(value);
            this.cosSetValue(state);
        }
    }

    protected COSName setButtonAppearanceState(PDAnnotation annot, String value) {
        COSName state = COSName.create(value);
        Set states = annot.getAppearanceStates();
        if (!states.contains(state)) {
            COSName offState;
            state = offState = COSName.create("Off");
            if ((value = value.toLowerCase().trim()).equals("1") || value.startsWith("t") || value.startsWith("y") || value.startsWith("w") || value.startsWith("j") || value.startsWith("x")) {
                for (COSName aState : states) {
                    if (aState.equals(offState)) continue;
                    state = (COSName)aState.copyOptional();
                    break;
                }
            }
        }
        annot.setAppearanceState(state);
        return state;
    }

    public Set getAvailableButtonAppearanceStates() {
        HashSet availableStates = new HashSet();
        for (PDAnnotation child : this.getAnnotations()) {
            availableStates.addAll(child.getAppearanceStates());
        }
        return availableStates;
    }

    public Set getAvailableButtonAppearanceStatesNoOff() {
        Set availableStates = this.getAvailableButtonAppearanceStates();
        COSName offState = COSName.create("Off");
        availableStates.remove(offState);
        return availableStates;
    }

    public void reset() {
        COSObject value = this.cosGetDefaultValue();
        value = value.isNull() ? COSString.create("") : value.copyOptional();
        this.cosSetValue(value);
    }

    public boolean isChecked() {
        if (this.isCheckbox()) {
            return !PDWidgetAnnotation.CN_State_Off.equals(this.getAnyAnnotation().getAppearanceState());
        }
        return false;
    }

    public static class MetaClass
    extends PDAcroFormField.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDAFButtonField(object);
        }
    }
}

