/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import java.io.IOException;
import org.jpedal.jbig2.JBIG2Decoder;
import org.jpedal.jbig2.JBIG2Exception;

public class JBIG2Filter
extends Filter {
    public static final COSName DK_JBIG2Globals = COSName.constant("JBIG2Globals");

    public JBIG2Filter(COSDictionary options) {
        super(options);
    }

    protected byte[] decode(byte[] source) throws IOException {
        JBIG2Decoder decoder = new JBIG2Decoder();
        try {
            COSStream globals;
            if (this.getOptions() != null && (globals = this.getOptions().get(DK_JBIG2Globals).asStream()) != null) {
                decoder.setGlobalData(globals.getDecodedBytes());
            }
            decoder.decodeJBIG2(source);
        }
        catch (JBIG2Exception ex) {
            IOException ioException = new IOException();
            ioException.initCause(ex);
            throw ioException;
        }
        return decoder.getPageAsJBIG2Bitmap(1).getData(true);
    }

    protected byte[] encode(byte[] source) throws IOException {
        return null;
    }
}

