/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.crypt.AbstractSecurityHandler;
import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.AccessPermissionsNone;
import de.intarsys.pdf.crypt.AuthenticationHandlerFactory;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.IAccessPermissionsSupport;
import de.intarsys.pdf.crypt.IAuthenticationHandler;
import de.intarsys.pdf.crypt.PermissionFlags;
import de.intarsys.pdf.crypt.StandardSecurityHandlerFactory;
import de.intarsys.pdf.st.STDocument;

public abstract class StandardSecurityHandler
extends AbstractSecurityHandler
implements IAccessPermissionsSupport {
    public static final int DEFAULT_ACCESS_PERMISSIONS = -4;
    public static final COSName DK_EncryptMetadata = COSName.constant("EncryptMetadata");
    public static final COSName DK_O = COSName.constant("O");
    public static final COSName DK_P = COSName.constant("P");
    public static final COSName DK_R = COSName.constant("R");
    public static final COSName DK_U = COSName.constant("U");
    protected static byte[] PADDING;
    protected static byte[] USER_R3_PADDING;
    private IAccessPermissions accessPermissions = AccessPermissionsFull.get();
    private IAuthenticationHandler authenticationHandler;
    private byte[] cryptKey;
    private byte[] owner;
    private byte[] user;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 40;
        byArray[1] = -65;
        byArray[2] = 78;
        byArray[3] = 94;
        byArray[4] = 78;
        byArray[5] = 117;
        byArray[6] = -118;
        byArray[7] = 65;
        byArray[8] = 100;
        byArray[10] = 78;
        byArray[11] = 86;
        byArray[12] = -1;
        byArray[13] = -6;
        byArray[14] = 1;
        byArray[15] = 8;
        byArray[16] = 46;
        byArray[17] = 46;
        byArray[19] = -74;
        byArray[20] = -48;
        byArray[21] = 104;
        byArray[22] = 62;
        byArray[23] = -128;
        byArray[24] = 47;
        byArray[25] = 12;
        byArray[26] = -87;
        byArray[27] = -2;
        byArray[28] = 100;
        byArray[29] = 83;
        byArray[30] = 105;
        byArray[31] = 122;
        PADDING = byArray;
        byte[] byArray2 = new byte[16];
        byArray2[0] = 40;
        byArray2[1] = -65;
        byArray2[2] = 78;
        byArray2[3] = 94;
        byArray2[4] = 78;
        byArray2[5] = 117;
        byArray2[6] = -118;
        byArray2[7] = 65;
        byArray2[8] = 100;
        byArray2[10] = 40;
        byArray2[11] = -65;
        byArray2[12] = 78;
        byArray2[13] = 94;
        byArray2[14] = 78;
        byArray2[15] = 78;
        USER_R3_PADDING = byArray2;
    }

    public void apply() throws COSSecurityException {
        byte[] oPwd = this.createOwnerPassword(this.owner, this.user);
        COSString o = COSString.create(oPwd);
        this.getEncryption().cosSetField(DK_O, o);
        byte[] uPwd = this.createUserPassword(this.user);
        COSString u = COSString.create(uPwd);
        this.getEncryption().cosSetField(DK_U, u);
        this.setCryptKey(this.createCryptKey(this.getUser()));
    }

    public void attach(STDocument doc) {
        super.attach(doc);
        if (doc == null) {
            return;
        }
        COSEncryption encryption = this.getEncryption();
        encryption.cosSetField(COSEncryption.DK_Filter, StandardSecurityHandlerFactory.CN_Standard);
        encryption.cosSetField(DK_R, COSInteger.create(this.getRevision()));
        this.getEncryption().setFieldInt(DK_P, -4);
    }

    public final void authenticate() throws COSSecurityException {
        this.setActiveAccessPermissions(AccessPermissionsNone.get());
        if (this.authenticationHandler == null) {
            this.authenticationHandler = AuthenticationHandlerFactory.get().createAuthenticationHandler(this);
        }
        this.authenticationHandler.authenticate(this);
    }

    public abstract boolean authenticateOwner(byte[] var1) throws COSSecurityException;

    public abstract boolean authenticateUser(byte[] var1) throws COSSecurityException;

    public int basicGetPermissionFlags() {
        return this.getEncryption().getFieldInt(DK_P, -4);
    }

    public void basicSetPermissionFlags(int newValue) throws COSSecurityException {
        if (this.getEncryption().cosGetDoc() == null) {
            throw new COSSecurityException("document missing");
        }
        this.getEncryption().setFieldInt(DK_P, newValue);
    }

    protected abstract IAccessPermissions createAccessPermissions();

    protected abstract byte[] createCryptKey(byte[] var1) throws COSSecurityException;

    protected abstract byte[] createOwnerPassword(byte[] var1, byte[] var2) throws COSSecurityException;

    protected abstract byte[] createUserPassword(byte[] var1) throws COSSecurityException;

    public byte[] decrypt(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        throw new COSSecurityException("pluggable encryption not supported");
    }

    public void detach(STDocument doc) throws COSSecurityException {
        if (doc == null) {
            return;
        }
        COSEncryption encryption = this.getEncryption();
        encryption.cosRemoveField(COSEncryption.DK_Filter);
        encryption.cosRemoveField(DK_R);
        encryption.cosRemoveField(DK_P);
        super.detach(doc);
    }

    public byte[] encrypt(COSObjectKey key, byte[] bytes) throws COSSecurityException {
        throw new COSSecurityException("pluggable encryption not supported");
    }

    public final IAccessPermissions getAccessPermissions() {
        return this.accessPermissions;
    }

    public IAuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public byte[] getCryptKey() {
        return this.cryptKey;
    }

    protected byte[] getO() {
        COSString o = this.getEncryption().cosGetField(DK_O).asString();
        if (o != null) {
            return o.byteValue();
        }
        return null;
    }

    protected byte[] getOwner() {
        return this.owner;
    }

    protected byte[] getPBytes() {
        int pint = this.basicGetPermissionFlags();
        byte[] result = new byte[]{(byte)(pint & 0xFF), (byte)((pint >>= 8) & 0xFF), (byte)((pint >>= 8) & 0xFF), (byte)((pint >>= 8) & 0xFF)};
        return result;
    }

    protected byte[] getPermanentFileID() throws COSSecurityException {
        COSString permanentId;
        STDocument stDoc = this.stGetDoc();
        if (stDoc == null) {
            throw new COSSecurityException("document missing");
        }
        if (stDoc.getTrailer().cosGetPermanentFileID() == null) {
            stDoc.getTrailer().updateFileID();
        }
        if ((permanentId = stDoc.getTrailer().cosGetPermanentFileID()) != null) {
            return permanentId.byteValue();
        }
        return null;
    }

    public PermissionFlags getPermissionFlags() {
        return new PermissionFlags(this);
    }

    public abstract int getRevision();

    protected byte[] getU() {
        COSString u = this.getEncryption().cosGetField(DK_U).asString();
        if (u == null) {
            return null;
        }
        return u.byteValue();
    }

    protected byte[] getUser() {
        return this.user;
    }

    public void initialize(STDocument doc) {
        super.initialize(doc);
        this.setActiveAccessPermissions(AccessPermissionsNone.get());
    }

    public boolean isEncryptMetadata() {
        return this.getEncryption().getFieldBoolean(DK_EncryptMetadata, true);
    }

    protected byte[] prepareBytes(byte[] bytes) {
        byte[] padded = new byte[32];
        if (bytes == null) {
            System.arraycopy(PADDING, 0, padded, 0, 32);
        } else if (bytes.length > 32) {
            System.arraycopy(bytes, 0, padded, 0, 32);
        } else {
            System.arraycopy(bytes, 0, padded, 0, bytes.length);
            System.arraycopy(PADDING, 0, padded, bytes.length, 32 - bytes.length);
        }
        return padded;
    }

    protected void setActiveAccessPermissions(IAccessPermissions accessPermissions) {
        this.accessPermissions = accessPermissions;
    }

    public void setAuthenticationHandler(IAuthenticationHandler authenticationHandler) {
        this.authenticationHandler = authenticationHandler;
    }

    protected void setCryptKey(byte[] key) throws COSSecurityException {
        this.cryptKey = key;
    }

    public void setEncryptMetadata(boolean value) {
        this.getEncryption().setFieldBoolean(DK_EncryptMetadata, value);
    }

    protected void setOwner(byte[] owner) {
        this.owner = owner;
    }

    public void setOwnerPassword(byte[] pOwner) throws COSSecurityException {
        if (this.getEncryption().cosGetDoc() == null) {
            throw new COSSecurityException("document missing");
        }
        this.owner = pOwner;
    }

    protected void setUser(byte[] user) {
        this.user = user;
    }

    public void setUserPassword(byte[] pUser) throws COSSecurityException {
        if (this.getEncryption().cosGetDoc() == null) {
            throw new COSSecurityException("document missing");
        }
        this.user = pUser;
    }
}

