/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.view.mindmapview.NodeView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import splmm.Actions.AddMonitoringDirAction;
import splmm.Actions.AllUpdateMonitoringAction;
import splmm.Actions.EditMonitoringDirAction;
import splmm.Actions.RemoveMonitoringDirAction;
import splmm.Actions.SmartUpdateMonitoringDirAction;
import splmm.Gui.MonDirJTree;
import splmm.Gui.Transferable.NodeTransferable;
import splmm.Listeners.MonDirNodeSelectionListener;
import splmm.Listeners.NodeListener;
import splmm.Localization.LocalizationSupport;
import splmm.SciPloreUtils;

public class WatchFolderPanel
extends JTabbedPane {
    private JPanel panelFolderView;
    private MonDirJTree tree;
    private JScrollPane treePanel;
    private MindMapController controller;
    private JButton buttonNew;
    private JButton buttonEdit;
    private JButton buttonDelete;
    private JButton buttonUpdateSmart;
    private JButton buttonUpdateAll;

    public WatchFolderPanel(ModeController controller) {
        this.controller = (MindMapController)controller;
        this.init();
        this.tree = new MonDirJTree(this.controller.getController());
        this.tree.setModel(new DefaultTreeModel(this.getRootNode(controller)));
        this.tree.setEditable(true);
        this.setListeners();
        this.tree.setDropMode(DropMode.USE_SELECTION);
        this.tree.setTransferHandler(new NodeTransferHandler(this.tree));
        this.treePanel.setViewportView(this.tree);
        this.treePanel.setAutoscrolls(true);
        this.tree.updatePath();
        this.updateIcons();
        this.tree.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                WatchFolderPanel.this.onKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    private void setListeners() {
        MindMapMapModel mapModel = (MindMapMapModel)this.controller.getMap();
        if (mapModel != null) {
            mapModel.addTreeModelListener(new NodeListener(this.tree));
        }
        this.controller.registerNodeSelectionListener(new MonDirNodeSelectionListener(this.tree));
        this.controller.registerNodeSelectionListener(new SelectionListener());
    }

    private void onKeyPressed(KeyEvent keyEvent) {
        MindMapNode node;
        if (keyEvent.getKeyCode() == 127) {
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            for (TreePath path : this.tree.getSelectionModel().getSelectionPaths()) {
                MindMapNode node2 = (MindMapNode)path.getLastPathComponent();
                MindMapNode parent = node2.getParentNode();
                this.controller.deleteNode(node2);
                model.nodeChanged(parent);
            }
            keyEvent.consume();
        }
        if (keyEvent.getKeyCode() == 10) {
            keyEvent.consume();
            node = (MindMapNode)this.tree.getSelectionModel().getLeadSelectionPath().getLastPathComponent();
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            MindMapNode newNode = this.controller.addNewNode(node, node.getChildCount(), node.isLeft());
            model.nodeChanged(node);
            this.tree.startEditingAtPath(newNode.getPath());
        }
        if (keyEvent.getKeyCode() == 113) {
            keyEvent.consume();
            node = (MindMapNode)this.tree.getSelectionModel().getLeadSelectionPath().getLastPathComponent();
            this.tree.startEditingAtPath(node.getPath());
        }
    }

    private void init() {
        this.panelFolderView = new JPanel();
        this.panelFolderView.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.addTab("Incoming Folders", this.panelFolderView);
        JPanel panel3 = new JPanel();
        panel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.panelFolderView.add((Component)panel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        panel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        this.treePanel = new JScrollPane();
        this.treePanel.setBackground(new Color(-1));
        panel3.add((Component)this.treePanel, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.treePanel.add((Component)spacer1, new GridConstraints(0, 0, 1, 1, 0, 1, 4, 1, null, new Dimension(200, -1), null, 0, false));
        JPanel panelToolbar = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setBorderPainted(false);
        toolBar.setMargin(new Insets(0, 0, 0, 0));
        this.buttonNew = new JButton();
        this.buttonNew.setAction(new AddMonitoringDirAction(this.controller));
        this.buttonNew.setText("");
        this.buttonNew.setIcon(new ImageIcon(this.controller.getResource("images/filenew.png")));
        this.buttonNew.setToolTipText(LocalizationSupport.message("splmm_monitoringDir_add"));
        toolBar.add(this.buttonNew);
        this.buttonEdit = new JButton();
        this.buttonEdit.setAction(new EditMonitoringDirAction(this.controller));
        this.buttonEdit.setText("");
        this.buttonEdit.setIcon(new ImageIcon(this.controller.getResource("images/icons/edit.png")));
        this.buttonEdit.setToolTipText(LocalizationSupport.message("splmm_monitoringDir_edit"));
        toolBar.add(this.buttonEdit);
        this.buttonDelete = new JButton();
        this.buttonDelete.setAction(new RemoveMonitoringDirAction(this.controller));
        this.buttonDelete.setText("");
        this.buttonDelete.setIcon(new ImageIcon(this.controller.getResource("images/editdelete.png")));
        this.buttonDelete.setToolTipText(LocalizationSupport.message("splmm_monitoringDir_remove"));
        toolBar.add(this.buttonDelete);
        this.buttonUpdateSmart = new JButton();
        this.buttonUpdateSmart.setAction(new SmartUpdateMonitoringDirAction(this.controller));
        this.buttonUpdateSmart.setText("");
        this.buttonUpdateSmart.setIcon(new ImageIcon(this.controller.getResource("images/icons/wizard.png")));
        this.buttonUpdateSmart.setToolTipText(LocalizationSupport.message("splmm_monitoringDir_update"));
        toolBar.add(this.buttonUpdateSmart);
        this.buttonUpdateAll = new JButton();
        this.buttonUpdateAll.setAction(new AllUpdateMonitoringAction(this.controller));
        this.buttonUpdateAll.setText("");
        this.buttonUpdateAll.setIcon(new ImageIcon(this.controller.getResource("images/redo.png")));
        this.buttonUpdateAll.setToolTipText(LocalizationSupport.message("splmm_monitoringDir_all_update"));
        toolBar.add(this.buttonUpdateAll);
        panelToolbar.add(toolBar);
        panelToolbar.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null));
        this.panelFolderView.add((Component)panelToolbar, new GridConstraints(0, 0, 1, 1, 0, 3, 2, 1, null, null, null, 0, false));
    }

    public void update(ModeController controller) {
        this.controller = (MindMapController)controller;
        this.tree.setModel(new DefaultTreeModel(this.getRootNode(controller)));
        this.setListeners();
        this.tree.updatePath();
        this.updateIcons();
        this.tree.repaint();
    }

    private void updateIcons() {
        if (SciPloreUtils.isMonitoringNode(this.controller.getSelected())) {
            this.buttonNew.setEnabled(false);
            this.buttonEdit.setEnabled(true);
            this.buttonDelete.setEnabled(true);
            this.buttonUpdateAll.setEnabled(true);
            this.buttonUpdateSmart.setEnabled(true);
        } else {
            this.buttonNew.setEnabled(true);
            this.buttonEdit.setEnabled(false);
            this.buttonDelete.setEnabled(false);
            this.buttonUpdateAll.setEnabled(false);
            this.buttonUpdateSmart.setEnabled(false);
        }
    }

    private MindMapNode getRootNode(ModeController controller) {
        MindMapNodeModel root = new MindMapNodeModel(controller.getFrame(), controller.getMap());
        if (controller != null && controller.getMap() != null && controller.getMap().getRootNode() != null) {
            List<MindMapNode> importNodes = SciPloreUtils.getAutoImportNodes(controller.getMap().getRootNode(), false);
            root.setText(controller.getMap().getRootNode().getText());
            for (int i = 0; i < importNodes.size(); ++i) {
                MindMapNode parent = importNodes.get(i).getParentNode();
                root.insert(importNodes.get(i), root.getChildCount());
                importNodes.get(i).setParent(parent);
            }
        }
        return root;
    }

    private class SelectionListener
    implements ModeController.NodeSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void onUpdateNodeHook(MindMapNode node) {
            if (SciPloreUtils.isMonitoringNode(node)) {
                WatchFolderPanel.this.buttonNew.setEnabled(false);
                WatchFolderPanel.this.buttonEdit.setEnabled(true);
                WatchFolderPanel.this.buttonDelete.setEnabled(true);
                WatchFolderPanel.this.buttonUpdateAll.setEnabled(true);
                WatchFolderPanel.this.buttonUpdateSmart.setEnabled(true);
            } else {
                WatchFolderPanel.this.buttonNew.setEnabled(true);
                WatchFolderPanel.this.buttonEdit.setEnabled(false);
                WatchFolderPanel.this.buttonDelete.setEnabled(false);
                WatchFolderPanel.this.buttonUpdateAll.setEnabled(false);
                WatchFolderPanel.this.buttonUpdateSmart.setEnabled(false);
            }
        }

        @Override
        public void onSelectHook(NodeView node) {
            if (SciPloreUtils.isMonitoringNode(node.getModel())) {
                WatchFolderPanel.this.buttonNew.setEnabled(false);
                WatchFolderPanel.this.buttonEdit.setEnabled(true);
                WatchFolderPanel.this.buttonDelete.setEnabled(true);
                WatchFolderPanel.this.buttonUpdateAll.setEnabled(true);
                WatchFolderPanel.this.buttonUpdateSmart.setEnabled(true);
            } else {
                WatchFolderPanel.this.buttonNew.setEnabled(true);
                WatchFolderPanel.this.buttonEdit.setEnabled(false);
                WatchFolderPanel.this.buttonDelete.setEnabled(false);
                WatchFolderPanel.this.buttonUpdateAll.setEnabled(false);
                WatchFolderPanel.this.buttonUpdateSmart.setEnabled(false);
            }
        }

        @Override
        public void onDeselectHook(NodeView node) {
        }

        @Override
        public void onSaveNode(MindMapNode node) {
        }
    }

    private class NodeTransferHandler
    extends TransferHandler {
        JTree tree;

        private NodeTransferHandler(JTree tree) {
            this.tree = tree;
        }

        @Override
        public int getSourceActions(JComponent comp) {
            return 3;
        }

        @Override
        public Transferable createTransferable(JComponent comp) {
            TreePath[] selections = this.tree.getSelectionModel().getSelectionPaths();
            ArrayList<MindMapNode> selectedNodes = new ArrayList<MindMapNode>();
            for (TreePath selection : selections) {
                MindMapNode node = (MindMapNode)selection.getLastPathComponent();
                selectedNodes.add(node);
            }
            return new NodeTransferable(selectedNodes);
        }
    }
}

