/*
 * Decompiled with CFR 0.152.
 */
package splmm.Gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import freemind.controller.Controller;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import splmm.Gui.VerticalButton;
import splmm.Gui.WatchFolderPanel;

public class SplmmToolbar
extends JPanel {
    private VerticalButton buttonShow;
    private Controller controller;
    private boolean isShown = false;
    private WatchFolderPanel watchFolderPanel;

    public SplmmToolbar(Controller controller) {
        this.init();
        this.controller = controller;
        this.buttonShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplmmToolbar.this.onShow();
            }
        });
    }

    public void onShow() {
        if (this.isShown) {
            this.controller.getFrame().removeHorizontalSplitPane();
            this.watchFolderPanel = null;
        } else {
            this.watchFolderPanel = new WatchFolderPanel(this.controller.getModeController());
            this.controller.getFrame().insertComponentIntoHorizontalSplitPane(this.watchFolderPanel);
        }
        this.isShown = !this.isShown;
    }

    public void hideToolbar() {
        this.setVisible(false);
        this.controller.getFrame().removeHorizontalSplitPane();
        this.watchFolderPanel = null;
    }

    public void showToolbar() {
        this.setVisible(true);
        if (this.isShown) {
            this.watchFolderPanel = new WatchFolderPanel(this.controller.getModeController());
            this.controller.getFrame().insertComponentIntoHorizontalSplitPane(this.watchFolderPanel);
        }
    }

    private void init() {
        this.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1));
        JPanel panel5 = new JPanel();
        panel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.add((Component)panel5, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.buttonShow = new VerticalButton("Incoming Folders", true);
        panel5.add((Component)this.buttonShow, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 0, null, null, null, 0, false));
    }

    public void updateTree() {
        if (this.watchFolderPanel != null) {
            this.watchFolderPanel.update(this.controller.getModeController());
        }
    }
}

