/*
 * Decompiled with CFR 0.152.
 */
package spl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.imports.ImportMenuItem;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.util.XMPUtil;
import org.sciplore.xml.XmlDocument;
import org.sciplore.xml.XmlDocuments;
import spl.DocumentWrapper;
import spl.Tools;
import spl.filter.PdfFileFilter;
import spl.gui.ImportDialog;
import spl.gui.MetaDataListDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfImporter {
    private JabRefFrame frame;
    private BasePanel panel;
    private MainTable entryTable;
    private int dropRow;

    public PdfImporter(JabRefFrame frame, BasePanel panel, MainTable entryTable, int dropRow) {
        this.frame = frame;
        this.panel = panel;
        this.entryTable = entryTable;
        this.dropRow = dropRow;
    }

    public String[] importPdfFiles(String[] fileNames) {
        ArrayList<String> files = new ArrayList<String>(Arrays.asList(fileNames));
        ArrayList<String> noPdfFiles = new ArrayList<String>();
        PdfFileFilter pdfFilter = new PdfFileFilter();
        for (String file : files) {
            if (pdfFilter.accept(file)) continue;
            noPdfFiles.add(file);
        }
        files.removeAll(noPdfFiles);
        this.importPdfFiles(files);
        String[] noPdfFilesArray = new String[noPdfFiles.size()];
        noPdfFiles.toArray(noPdfFilesArray);
        return noPdfFilesArray;
    }

    private boolean importPdfFiles(List<String> fileNames) {
        if (this.panel == null) {
            return false;
        }
        for (String fileName : fileNames) {
            XmlDocument document;
            int selected;
            XmlDocuments documents;
            MetaDataListDialog metaDataListDialog;
            List<BibtexEntry> xmpEntriesInFile = this.readXmpEntries(fileName);
            ImportDialog importDialog = new ImportDialog(this.dropRow, fileName);
            if (!this.hasXmpEntries(xmpEntriesInFile)) {
                importDialog.getRadioButtonXmp().setEnabled(false);
            }
            Tools.centerRelativeToWindow(importDialog, this.frame);
            importDialog.showDialog();
            if (importDialog.getResult() != 0) continue;
            if (importDialog.getRadioButtonXmp().isSelected()) {
                ImportMenuItem importer = new ImportMenuItem(this.frame, this.entryTable == null);
                importer.automatedImport(new String[]{fileName});
                continue;
            }
            if (importDialog.getRadioButtonMrDlib().isSelected()) {
                metaDataListDialog = new MetaDataListDialog(fileName, true);
                Tools.centerRelativeToWindow(metaDataListDialog, this.frame);
                metaDataListDialog.showDialog();
                documents = metaDataListDialog.getXmlDocuments();
                if (documents != null && documents.getDocuments() != null && documents.getDocuments().size() > 0 && metaDataListDialog.getResult() == 0) {
                    selected = metaDataListDialog.getTableMetadata().getSelectedRow();
                    if (selected > -1 && selected < documents.getDocuments().size()) {
                        document = (XmlDocument)documents.getDocuments().get(selected);
                        String id = Util.createNeutralId();
                        BibtexEntry entry = new BibtexEntry(id);
                        if (this.fieldExists(document.getType())) {
                            BibtexEntryType type = BibtexEntryType.getStandardType(document.getType());
                            if (type == null) {
                                type = BibtexEntryType.ARTICLE;
                            }
                            entry.setType(type);
                        } else {
                            entry.setType(BibtexEntryType.ARTICLE);
                        }
                        ArrayList<BibtexEntry> list = new ArrayList<BibtexEntry>();
                        list.add(entry);
                        Util.setAutomaticFields(list, true, true, false);
                        this.insertFields(entry.getRequiredFields(), entry, document);
                        this.insertFields(entry.getGeneralFields(), entry, document);
                        this.insertFields(entry.getOptionalFields(), entry, document);
                        this.panel.database().insertEntry(entry);
                        DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                        dfh.linkPdfToEntry(fileName, this.entryTable, entry);
                        LabelPatternUtil.makeLabel(Globals.prefs.getKeyPattern(), this.panel.database(), entry);
                        continue;
                    }
                    this.createNewBlankEntry(fileName);
                    continue;
                }
                if (metaDataListDialog.getResult() == 2) continue;
                if (metaDataListDialog.getResult() == 1) {
                    this.createNewBlankEntry(fileName);
                    continue;
                }
                if (documents != null && documents.getDocuments() != null && (documents.getDocuments().size() > 0 || metaDataListDialog.getResult() != 0)) continue;
                this.createNewBlankEntry(fileName);
                continue;
            }
            if (importDialog.getRadioButtonNoMeta().isSelected()) {
                this.createNewBlankEntry(fileName);
                continue;
            }
            if (importDialog.getRadioButtonUpdateEmptyFields().isSelected()) {
                BibtexEntryType type;
                metaDataListDialog = new MetaDataListDialog(fileName, false);
                Tools.centerRelativeToWindow(metaDataListDialog, this.frame);
                metaDataListDialog.showDialog();
                documents = metaDataListDialog.getXmlDocuments();
                if (documents == null || documents.getDocuments() == null || documents.getDocuments().size() <= 0 || metaDataListDialog.getResult() != 0 || (selected = metaDataListDialog.getTableMetadata().getSelectedRow()) <= -1 || selected >= documents.getDocuments().size()) continue;
                document = (XmlDocument)documents.getDocuments().get(selected);
                BibtexEntry entry = this.entryTable.getEntryAt(this.dropRow);
                if (this.fieldExists(document.getType()) && (type = BibtexEntryType.getStandardType(document.getType())) != null) {
                    entry.setType(type);
                }
                this.insertFields(entry.getRequiredFields(), entry, document);
                this.insertFields(entry.getGeneralFields(), entry, document);
                this.insertFields(entry.getOptionalFields(), entry, document);
                DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
                dfh.linkPdfToEntry(fileName, this.entryTable, this.dropRow);
                continue;
            }
            if (!importDialog.getRadioButtononlyAttachPDF().isSelected()) continue;
            DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
            dfh.linkPdfToEntry(fileName, this.entryTable, this.dropRow);
        }
        return true;
    }

    private void createNewBlankEntry(String fileName) {
        BibtexEntry newEntry = this.createNewEntry();
        if (newEntry != null) {
            DroppedFileHandler dfh = new DroppedFileHandler(this.frame, this.panel);
            dfh.linkPdfToEntry(fileName, this.entryTable, newEntry);
        }
    }

    private void insertFields(String[] fields, BibtexEntry entry, XmlDocument xmlDocument) {
        DocumentWrapper document = new DocumentWrapper(xmlDocument);
        for (String field : fields) {
            if (entry.getField(field) != null) continue;
            if (field.equalsIgnoreCase("author")) {
                entry.setField(field, document.getAuthors("and"));
            }
            if (field.equalsIgnoreCase("title")) {
                entry.setField(field, document.getTitle());
            }
            if (field.equalsIgnoreCase("abstract")) {
                entry.setField(field, document.getAbstract());
            }
            if (field.equalsIgnoreCase("keywords")) {
                entry.setField(field, document.getKeyWords());
            }
            if (field.equalsIgnoreCase("doi")) {
                entry.setField(field, document.getDoi());
            }
            if (field.equalsIgnoreCase("pages")) {
                entry.setField(field, document.getPages());
            }
            if (field.equalsIgnoreCase("volume")) {
                entry.setField(field, document.getVolume());
            }
            if (field.equalsIgnoreCase("number")) {
                entry.setField(field, document.getNumber());
            }
            if (field.equalsIgnoreCase("year")) {
                entry.setField(field, document.getYear());
            }
            if (field.equalsIgnoreCase("month")) {
                entry.setField(field, document.getMonth());
            }
            if (field.equalsIgnoreCase("day")) {
                entry.setField(field, document.getDay());
            }
            if (field.equalsIgnoreCase("booktitle")) {
                entry.setField(field, document.getVenue());
            }
            if (!field.equalsIgnoreCase("journal")) continue;
            entry.setField(field, document.getVenue());
        }
    }

    private boolean fieldExists(String string) {
        return string != null && !string.isEmpty();
    }

    private BibtexEntry createNewEntry() {
        EntryTypeDialog etd = new EntryTypeDialog(this.frame);
        Util.placeDialog(etd, this.frame);
        etd.setVisible(true);
        BibtexEntryType type = etd.getChoice();
        if (type != null) {
            String id = Util.createNeutralId();
            BibtexEntry be = new BibtexEntry(id, type);
            try {
                this.panel.database().insertEntry(be);
                ArrayList<BibtexEntry> list = new ArrayList<BibtexEntry>();
                list.add(be);
                Util.setAutomaticFields(list, true, true, false);
                this.panel.undoManager.addEdit(new UndoableInsertEntry(this.panel.database(), be, this.panel));
                this.panel.output(Globals.lang("Added new") + " '" + type.getName().toLowerCase() + "' " + Globals.lang("entry") + ".");
                if (this.panel.getMode() != 2) {
                    this.panel.setMode(3);
                }
                this.panel.showEntry(be);
                this.panel.markBaseChanged();
                new FocusRequester(this.panel.getEntryEditor(be));
                return be;
            }
            catch (KeyCollisionException ex) {
                Util.pr(ex.getMessage());
            }
        }
        return null;
    }

    private List<BibtexEntry> readXmpEntries(String fileName) {
        List<BibtexEntry> xmpEntriesInFile = null;
        try {
            xmpEntriesInFile = XMPUtil.readXMP(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xmpEntriesInFile;
    }

    private boolean hasXmpEntries(List<BibtexEntry> xmpEntriesInFile) {
        return xmpEntriesInFile != null && xmpEntriesInFile.size() != 0;
    }

    public MainTable getEntryTable() {
        return this.entryTable;
    }

    public void setEntryTable(MainTable entryTable) {
        this.entryTable = entryTable;
    }

    public int getDropRow() {
        return this.dropRow;
    }

    public void setDropRow(int dropRow) {
        this.dropRow = dropRow;
    }
}

