/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import net.sf.jabref.Globals;

public class ErrorConsole {
    ByteArrayOutputStream errByteStream = new ByteArrayOutputStream();
    ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
    private static ErrorConsole instance = null;

    public static ErrorConsole getInstance() {
        if (instance == null) {
            instance = new ErrorConsole();
        }
        return instance;
    }

    private ErrorConsole() {
        PrintStream myErr = new PrintStream(this.errByteStream);
        TeeStream tee = new TeeStream(System.err, myErr);
        System.setErr(tee);
        myErr = new PrintStream(this.outByteStream);
        tee = new TeeStream(System.out, myErr);
        System.setOut(tee);
    }

    public String getErrorMessages() {
        return this.errByteStream.toString();
    }

    public String getOutput() {
        return this.outByteStream.toString();
    }

    public void displayErrorConsole(JFrame parent) {
        JTabbedPane tabbed = new JTabbedPane();
        JTextArea ta = new JTextArea(this.getOutput());
        ta.setEditable(false);
        JScrollPane sp = new JScrollPane(ta);
        tabbed.addTab(Globals.lang("Output"), sp);
        ta = new JTextArea(this.getErrorMessages());
        ta.setEditable(false);
        if (ta.getText().length() == 0) {
            ta.setText(Globals.lang("No exceptions have ocurred."));
        }
        sp = new JScrollPane(ta);
        tabbed.addTab(Globals.lang("Exceptions"), sp);
        tabbed.setPreferredSize(new Dimension(500, 500));
        JOptionPane.showMessageDialog(parent, tabbed, Globals.lang("Program output"), 0);
    }

    public AbstractAction getAction(JFrame parent) {
        return new ErrorConsoleAction(parent);
    }

    public class TeeStream
    extends PrintStream {
        PrintStream out;

        public TeeStream(PrintStream out1, PrintStream out2) {
            super(out1);
            this.out = out2;
        }

        public void write(byte[] buf, int off, int len) {
            try {
                super.write(buf, off, len);
                this.out.write(buf, off, len);
            }
            catch (Exception e) {
                // empty catch block
            }
        }

        public void flush() {
            super.flush();
            this.out.flush();
        }
    }

    class ErrorConsoleAction
    extends AbstractAction {
        JFrame frame;

        public ErrorConsoleAction(JFrame frame) {
            super(Globals.menuTitle("Show error console"));
            this.putValue("ShortDescription", Globals.lang("Display all error messages"));
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            ErrorConsole.this.displayErrorConsole(this.frame);
        }
    }
}

