/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.Globals;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PostOpenAction;

public class FileDirectoryUpgradeWarning
implements PostOpenAction {
    public boolean isActionNecessary(ParserResult pr) {
        if (!Globals.prefs.getBoolean("showFileDirUpgradeWarning")) {
            return false;
        }
        if (pr.getJabrefMajorVersion() < 0) {
            return false;
        }
        if (pr.getJabrefMajorVersion() < 2) {
            return true;
        }
        if (pr.getJabrefMajorVersion() > 2) {
            return false;
        }
        return (float)pr.getJabrefMinorVersion() + (float)pr.getJabrefMinor2Version() / 10.0f < 6.1f;
    }

    public void performAction(BasePanel panel, ParserResult pr) {
        boolean offerSetFileDir;
        boolean bl = offerSetFileDir = panel.metaData().getData("fileDirectory") != null && panel.metaData().getData(Globals.prefs.get("userFileDir")) == null;
        if (!offerSetFileDir) {
            return;
        }
        JCheckBox setFileDir = new JCheckBox(Globals.lang("Set user specific file directory") + ":", offerSetFileDir);
        JTextField fileDir = new JTextField(30);
        JCheckBox retainOldFileDir = new JCheckBox(Globals.lang("Retain legacy file directory setting (for older versions of JabRef)"), false);
        JCheckBox doNotShowDialog = new JCheckBox(Globals.lang("Do not show these options in the future"), false);
        StringBuilder sb = new StringBuilder("<html>");
        sb.append(Globals.lang("This database was written using an older version of JabRef."));
        sb.append("<br>");
        sb.append(Globals.lang("The current version features a new way of storing the file directory setting of<br>a database. This enables multiple users of the same database file to keep their<br>own personal setting for the path to the file directory.<br>To take advantage of this, your file directory setting must be changed into the<br>new format."));
        sb.append("<p>");
        sb.append(Globals.lang("Do you want JabRef to do the following operations?"));
        sb.append("</html>");
        JPanel message = new JPanel();
        DefaultFormBuilder b = new DefaultFormBuilder(new FormLayout("left:pref", ""), message);
        b.append(new JLabel(sb.toString()));
        b.nextLine();
        if (offerSetFileDir) {
            if (panel.metaData().getData("fileDirectory") != null) {
                fileDir.setText(panel.metaData().getData("fileDirectory").firstElement());
            }
            JPanel pan = new JPanel();
            pan.add(setFileDir);
            pan.add(fileDir);
            JButton browse = new JButton(Globals.lang("Browse"));
            browse.addActionListener(new BrowseAction(null, fileDir, true));
            pan.add(browse);
            b.append(pan);
            b.nextLine();
            JPanel pan2 = new JPanel();
            pan2.add(retainOldFileDir);
            b.append(pan2);
            b.nextLine();
        }
        b.append("");
        b.nextLine();
        b.append(doNotShowDialog);
        int answer = JOptionPane.showConfirmDialog(panel.frame(), message, Globals.lang("Upgrade file") + " - " + pr.getFile().getName(), 0);
        if (doNotShowDialog.isSelected()) {
            Globals.prefs.putBoolean("showFileDirUpgradeWarning", false);
        }
        if (answer == 0) {
            this.makeChanges(panel, pr, setFileDir.isSelected() ? fileDir.getText() : null, retainOldFileDir.isSelected());
        }
    }

    public void makeChanges(BasePanel panel, ParserResult pr, String fileDir, boolean retainOldFileLinks) {
        boolean changed = false;
        if (fileDir != null) {
            Vector<String> vec = new Vector<String>(1);
            vec.add(fileDir);
            panel.metaData().putData(Globals.prefs.get("userFileDir"), vec);
            changed = true;
        }
        if (!retainOldFileLinks) {
            panel.metaData().remove("fileDirectory");
            changed = true;
        }
        if (changed) {
            panel.markNonUndoableBaseChanged();
        }
    }
}

