/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.export.layout.AbstractParamLayoutFormatter;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapFileLinks
extends AbstractParamLayoutFormatter {
    private String fileType = null;
    private List<FormatEntry> format = null;
    private Map<String, String> replacements = new HashMap<String, String>();
    public static final int STRING = 0;
    public static final int ITERATION_COUNT = 1;
    public static final int FILE_PATH = 2;
    public static final int FILE_TYPE = 3;
    public static final int FILE_EXTENSION = 4;
    public static final int FILE_DESCRIPTION = 5;
    public static final int RELATIVE_FILE_PATH = 6;
    static final Map<Character, Integer> ESCAPE_SEQ = new HashMap<Character, Integer>();

    @Override
    public void setArgument(String arg) {
        String[] parts = WrapFileLinks.parseArgument(arg);
        this.format = this.parseFormatString(parts[0]);
        if (parts.length > 1 && parts[1].trim().length() > 0) {
            this.fileType = parts[1];
        }
        if (parts.length > 2) {
            for (int i = 2; i < parts.length - 1; i += 2) {
                this.replacements.put(parts[i], parts[i + 1]);
            }
        }
    }

    @Override
    public String format(String field) {
        StringBuilder sb = new StringBuilder();
        FileListTableModel tableModel = new FileListTableModel();
        if (field == null) {
            return "";
        }
        tableModel.setContent(field);
        int piv = 1;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            FileListEntry flEntry = tableModel.getEntry(i);
            if (this.fileType != null && !flEntry.getType().getName().toLowerCase().equals(this.fileType)) continue;
            for (FormatEntry entry : this.format) {
                switch (entry.getType()) {
                    case 0: {
                        sb.append(entry.getString());
                        break;
                    }
                    case 1: {
                        sb.append(String.valueOf(piv));
                        break;
                    }
                    case 2: {
                        if (flEntry.getLink() == null) break;
                        String dir = Globals.prefs.fileDirForDatabase != null ? Globals.prefs.fileDirForDatabase : Globals.prefs.get("fileDirectory");
                        File f = Util.expandFilename(flEntry.getLink(), new String[]{dir});
                        if (f != null) {
                            try {
                                sb.append(this.replaceStrings(f.getCanonicalPath()));
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                sb.append(this.replaceStrings(f.getPath()));
                            }
                            break;
                        }
                        sb.append(this.replaceStrings(flEntry.getLink()));
                        break;
                    }
                    case 6: {
                        if (flEntry.getLink() == null) break;
                        sb.append(this.replaceStrings(flEntry.getLink()));
                        break;
                    }
                    case 4: {
                        int index;
                        if (flEntry.getLink() == null || (index = flEntry.getLink().lastIndexOf(46)) < 0 || index >= flEntry.getLink().length() - 1) break;
                        sb.append(this.replaceStrings(flEntry.getLink().substring(index + 1)));
                        break;
                    }
                    case 3: {
                        sb.append(this.replaceStrings(flEntry.getType().getName()));
                        break;
                    }
                    case 5: {
                        sb.append(this.replaceStrings(flEntry.getDescription()));
                    }
                }
            }
            ++piv;
        }
        return sb.toString();
    }

    protected String replaceStrings(String text) {
        for (String from : this.replacements.keySet()) {
            String to = this.replacements.get(from);
            text = text.replaceAll(from, to);
        }
        return text;
    }

    public List<FormatEntry> parseFormatString(String format) {
        ArrayList<FormatEntry> l = new ArrayList<FormatEntry>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (!escaped) {
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                sb.append(c);
                continue;
            }
            escaped = false;
            if (c == '\\') {
                sb.append(c);
                continue;
            }
            if (ESCAPE_SEQ.containsKey(Character.valueOf(c))) {
                if (sb.length() > 0) {
                    l.add(new FormatEntry(sb.toString()));
                    sb = new StringBuilder();
                }
                l.add(new FormatEntry(ESCAPE_SEQ.get(Character.valueOf(c))));
                continue;
            }
            sb.append('\\');
            sb.append(c);
        }
        if (sb.length() > 0) {
            l.add(new FormatEntry(sb.toString()));
        }
        return l;
    }

    static {
        ESCAPE_SEQ.put(Character.valueOf('i'), 1);
        ESCAPE_SEQ.put(Character.valueOf('p'), 2);
        ESCAPE_SEQ.put(Character.valueOf('r'), 6);
        ESCAPE_SEQ.put(Character.valueOf('f'), 3);
        ESCAPE_SEQ.put(Character.valueOf('x'), 4);
        ESCAPE_SEQ.put(Character.valueOf('d'), 5);
    }

    protected class FormatEntry {
        private int type;
        private String string = null;

        public FormatEntry(int type) {
            this.type = type;
        }

        public FormatEntry(String value) {
            this.type = 0;
            this.string = value;
        }

        public int getType() {
            return this.type;
        }

        public String getString() {
            return this.string;
        }
    }
}

