/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout.format;

import java.util.HashMap;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.LayoutFormatter;

public class FormatChars
implements LayoutFormatter {
    public static HashMap<String, String> CHARS = new HashMap();

    public String format(String field) {
        field = field.replaceAll("&|\\\\&", "&amp;").replaceAll("[\\n]{1,}", "<p>");
        StringBuffer sb = new StringBuffer();
        StringBuffer currentCommand = null;
        boolean escaped = false;
        boolean incommand = false;
        for (int i = 0; i < field.length(); ++i) {
            String result;
            IntAndString part;
            String result2;
            String command;
            char c = field.charAt(i);
            if (escaped && c == '\\') {
                sb.append('\\');
                escaped = false;
                continue;
            }
            if (c == '\\') {
                if (incommand) {
                    command = currentCommand.toString();
                    result2 = CHARS.get(command);
                    if (result2 != null) {
                        sb.append(result2);
                    } else {
                        sb.append(command);
                    }
                }
                escaped = true;
                incommand = true;
                currentCommand = new StringBuffer();
                continue;
            }
            if (!incommand && (c == '{' || c == '}')) continue;
            if (Character.isLetter(c) || c == '%' || Globals.SPECIAL_COMMAND_CHARS.indexOf(String.valueOf(c)) >= 0) {
                escaped = false;
                if (!incommand) {
                    sb.append(c);
                    continue;
                }
                currentCommand.append(c);
                if (currentCommand.length() == 1 && Globals.SPECIAL_COMMAND_CHARS.indexOf(currentCommand.toString()) >= 0) {
                    String combody;
                    if (i >= field.length() - 1) continue;
                    command = currentCommand.toString();
                    if ((c = field.charAt(++i)) == '{') {
                        part = this.getPart(field, i, false);
                        i += part.i;
                        combody = part.s;
                    } else {
                        combody = field.substring(i, i + 1);
                    }
                    result = CHARS.get(command + combody);
                    if (result != null) {
                        sb.append(result);
                    }
                    incommand = false;
                    escaped = false;
                    continue;
                }
                if (i + 1 != field.length()) continue;
                command = currentCommand.toString();
                result2 = CHARS.get(command);
                if (result2 != null) {
                    sb.append(result2);
                    continue;
                }
                sb.append(command);
                continue;
            }
            String argument = null;
            if (!incommand) {
                sb.append(c);
            } else if (Character.isWhitespace(c) || c == '{' || c == '}') {
                String command2 = currentCommand.toString();
                if (c == '{') {
                    part = this.getPart(field, i, true);
                    i += part.i;
                    argument = part.s;
                    if (argument != null) {
                        String result3 = CHARS.get(command2 + argument);
                        if (result3 != null) {
                            sb.append(result3);
                        } else {
                            sb.append(argument);
                        }
                    }
                } else if (c == '}') {
                    result = CHARS.get(command2);
                    if (result != null) {
                        sb.append(result);
                    } else {
                        sb.append(command2);
                    }
                } else {
                    result = CHARS.get(command2);
                    if (result != null) {
                        sb.append(result);
                    } else {
                        sb.append(command2);
                    }
                    sb.append(' ');
                }
            }
            incommand = false;
            escaped = false;
        }
        return sb.toString();
    }

    private IntAndString getPart(String text, int i, boolean terminateOnEndBraceOnly) {
        int count = 0;
        StringBuffer part = new StringBuffer();
        ++i;
        while (i < text.length() && Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!terminateOnEndBraceOnly && count == 0 && Character.isWhitespace(c)) {
                --i;
                break;
            }
            if (c == '}' && --count < 0) break;
            if (c == '{') {
                ++count;
            }
            part.append(c);
            ++i;
        }
        return new IntAndString(part.length(), this.format(part.toString()));
    }

    static {
        CHARS.put("`A", "\u00c3\u20ac");
        CHARS.put("'A", "\u00c3\ufffd");
        CHARS.put("^A", "\u00c3\u201a");
        CHARS.put("~A", "\u00c3\u0192");
        CHARS.put("\"A", "\u00c3\u201e");
        CHARS.put("AA", "\u00c3\u2026");
        CHARS.put("AE", "\u00c3\u2020");
        CHARS.put("cC", "\u00c3\u2021");
        CHARS.put("`E", "\u00c3\u02c6");
        CHARS.put("'E", "\u00c3\u2030");
        CHARS.put("^E", "\u00c3\u0160");
        CHARS.put("\"E", "\u00c3\u2039");
        CHARS.put("`I", "\u00c3\u0152");
        CHARS.put("'I", "\u00c3\ufffd");
        CHARS.put("^I", "\u00c3\u017d");
        CHARS.put("\"I", "\u00c3\ufffd");
        CHARS.put("DH", "\u00c3\ufffd");
        CHARS.put("~N", "\u00c3\u2018");
        CHARS.put("`O", "\u00c3\u2019");
        CHARS.put("'O", "\u00c3\u201c");
        CHARS.put("^O", "\u00c3\u201d");
        CHARS.put("~O", "\u00c3\u2022");
        CHARS.put("\"O", "\u00c3\u2013");
        CHARS.put("O", "\u00c3\u02dc");
        CHARS.put("`U", "\u00c3\u2122");
        CHARS.put("'U", "\u00c3\u0161");
        CHARS.put("^U", "\u00c3\u203a");
        CHARS.put("\"U", "\u00c3\u0153");
        CHARS.put("'Y", "\u00c3\ufffd");
        CHARS.put("TH", "\u00c3\u017e");
        CHARS.put("ss", "\u00c3\u0178");
        CHARS.put("`a", "\u00c3\u00a0");
        CHARS.put("'a", "\u00c3\u00a1");
        CHARS.put("^a", "\u00c3\u00a2");
        CHARS.put("~a", "\u00c3\u00a3");
        CHARS.put("\"a", "\u00c3\u00a4");
        CHARS.put("aa", "\u00c3\u00a5");
        CHARS.put("ae", "\u00c3\u00a6");
        CHARS.put("cc", "\u00c3\u00a7");
        CHARS.put("`e", "\u00c3\u00a8");
        CHARS.put("'e", "\u00c3\u00a9");
        CHARS.put("^e", "\u00c3\u00aa");
        CHARS.put("\"e", "\u00c3\u00ab");
        CHARS.put("`i", "\u00c3\u00ac");
        CHARS.put("'i", "\u00c3\u00ad");
        CHARS.put("^i", "\u00c3\u00ae");
        CHARS.put("\"i", "\u00c3\u00af");
        CHARS.put("dh", "\u00c3\u00b0");
        CHARS.put("~n", "\u00c3\u00b1");
        CHARS.put("`o", "\u00c3\u00b2");
        CHARS.put("'o", "\u00c3\u00b3");
        CHARS.put("^o", "\u00c3\u00b4");
        CHARS.put("~o", "\u00c3\u00b5");
        CHARS.put("\"o", "\u00c3\u00b6");
        CHARS.put("o", "\u00c3\u00b8");
        CHARS.put("`u", "\u00c3\u00b9");
        CHARS.put("'u", "\u00c3\u00ba");
        CHARS.put("^u", "\u00c3\u00bb");
        CHARS.put("\"u", "\u00c3\u00bc");
        CHARS.put("'y", "\u00c3\u00bd");
        CHARS.put("th", "\u00c3\u00be");
        CHARS.put("\"y", "\u00c3\u00bf");
        CHARS.put("=A", "\u00c4\u20ac");
        CHARS.put("=a", "\u00c4\ufffd");
        CHARS.put("uA", "\u00c4\u201a");
        CHARS.put("ua", "\u00c4\u0192");
        CHARS.put("kA", "\u00c4\u201e");
        CHARS.put("ka", "\u00c4\u2026");
        CHARS.put("'C", "\u00c4\u2020");
        CHARS.put("'c", "\u00c4\u2021");
        CHARS.put("^C", "\u00c4\u02c6");
        CHARS.put("^c", "\u00c4\u2030");
        CHARS.put(".C", "\u00c4\u0160");
        CHARS.put(".c", "\u00c4\u2039");
        CHARS.put("vC", "\u00c4\u0152");
        CHARS.put("vc", "\u00c4\ufffd");
        CHARS.put("vD", "\u00c4\u017d");
        CHARS.put("DJ", "\u00c4\ufffd");
        CHARS.put("dj", "\u00c4\u2018");
        CHARS.put("=E", "\u00c4\u2019");
        CHARS.put("=e", "\u00c4\u201c");
        CHARS.put("uE", "\u00c4\u201d");
        CHARS.put("ue", "\u00c4\u2022");
        CHARS.put(".E", "\u00c4\u2013");
        CHARS.put(".e", "\u00c4\u2014");
        CHARS.put("kE", "\u00c4\u02dc");
        CHARS.put("ke", "\u00c4\u2122");
        CHARS.put("vE", "\u00c4\u0161");
        CHARS.put("ve", "\u00c4\u203a");
        CHARS.put("^G", "\u00c4\u0153");
        CHARS.put("^g", "\u00c4\ufffd");
        CHARS.put("uG", "\u00c4\u017e");
        CHARS.put("ug", "\u00c4\u0178");
        CHARS.put(".G", "\u00c4\u00a0");
        CHARS.put(".g", "\u00c4\u00a1");
        CHARS.put("cG", "\u00c4\u00a2");
        CHARS.put("'g", "\u00c4\u00a3");
        CHARS.put("^H", "\u00c4\u00a4");
        CHARS.put("^h", "\u00c4\u00a5");
        CHARS.put("Hstrok", "\u00c4\u00a6");
        CHARS.put("hstrok", "\u00c4\u00a7");
        CHARS.put("~I", "\u00c4\u00a8");
        CHARS.put("~i", "\u00c4\u00a9");
        CHARS.put("=I", "\u00c4\u00aa");
        CHARS.put("=i", "\u00c4\u00ab");
        CHARS.put("uI", "\u00c4\u00ac");
        CHARS.put("ui", "\u00c4\u00ad");
        CHARS.put("kI", "\u00c4\u00ae");
        CHARS.put("ki", "\u00c4\u00af");
        CHARS.put(".I", "\u00c4\u00b0");
        CHARS.put("i", "\u00c4\u00b1");
        CHARS.put("^J", "\u00c4\u00b4");
        CHARS.put("^j", "\u00c4\u00b5");
        CHARS.put("cK", "\u00c4\u00b6");
        CHARS.put("ck", "\u00c4\u00b7");
        CHARS.put("'L", "\u00c4\u00b9");
        CHARS.put("'l", "\u00c4\u00ba");
        CHARS.put("cL", "\u00c4\u00bb");
        CHARS.put("cl", "\u00c4\u00bc");
        CHARS.put("Lmidot", "\u00c4\u00bf");
        CHARS.put("lmidot", "\u00c5\u20ac");
        CHARS.put("L", "\u00c5\ufffd");
        CHARS.put("l", "\u00c5\u201a");
        CHARS.put("'N", "\u00c5\u0192");
        CHARS.put("'n", "\u00c5\u201e");
        CHARS.put("cN", "\u00c5\u2026");
        CHARS.put("cn", "\u00c5\u2020");
        CHARS.put("vN", "\u00c5\u2021");
        CHARS.put("vn", "\u00c5\u02c6");
        CHARS.put("NG", "\u00c5\u0160");
        CHARS.put("ng", "\u00c5\u2039");
        CHARS.put("=O", "\u00c5\u0152");
        CHARS.put("=o", "\u00c5\ufffd");
        CHARS.put("uO", "\u00c5\u017d");
        CHARS.put("uo", "\u00c5\ufffd");
        CHARS.put("HO", "\u00c5\ufffd");
        CHARS.put("Ho", "\u00c5\u2018");
        CHARS.put("OE", "\u00c5\u2019");
        CHARS.put("oe", "\u00c5\u201c");
        CHARS.put("'R", "\u00c5\u201d");
        CHARS.put("'r", "\u00c5\u2022");
        CHARS.put("cR", "\u00c5\u2013");
        CHARS.put("cr", "\u00c5\u2014");
        CHARS.put("vR", "\u00c5\u02dc");
        CHARS.put("vr", "\u00c5\u2122");
        CHARS.put("'S", "\u00c5\u0161");
        CHARS.put("'s", "\u00c5\u203a");
        CHARS.put("^S", "\u00c5\u0153");
        CHARS.put("^s", "\u00c5\ufffd");
        CHARS.put("cS", "\u00c5\u017e");
        CHARS.put("cs", "\u00c5\u0178");
        CHARS.put("vS", "\u00c5\u00a0");
        CHARS.put("vs", "\u00c5\u00a1");
        CHARS.put("cT", "\u00c5\u00a2");
        CHARS.put("ct", "\u00c5\u00a3");
        CHARS.put("vT", "\u00c5\u00a4");
        CHARS.put("Tstrok", "\u00c5\u00a6");
        CHARS.put("tstrok", "\u00c5\u00a7");
        CHARS.put("~U", "\u00c5\u00a8");
        CHARS.put("~u", "\u00c5\u00a9");
        CHARS.put("=U", "\u00c5\u00aa");
        CHARS.put("=u", "\u00c5\u00ab");
        CHARS.put("uU", "\u00c5\u00ac");
        CHARS.put("uu", "\u00c5\u00ad");
        CHARS.put("rU", "\u00c5\u00ae");
        CHARS.put("ru", "\u00c5\u00af");
        CHARS.put("HU", "\u00c5\u00af");
        CHARS.put("Hu", "\u00c5\u00b1");
        CHARS.put("kU", "\u00c5\u00b2");
        CHARS.put("ku", "\u00c5\u00b3");
        CHARS.put("^W", "\u00c5\u00b4");
        CHARS.put("^w", "\u00c5\u00b5");
        CHARS.put("^Y", "\u00c5\u00b6");
        CHARS.put("^y", "\u00c5\u00b7");
        CHARS.put("\"Y", "\u00c5\u00b8");
        CHARS.put("'Z", "\u00c5\u00b9");
        CHARS.put("'z", "\u00c5\u00ba");
        CHARS.put(".Z", "\u00c5\u00bb");
        CHARS.put(".z", "\u00c5\u00bc");
        CHARS.put("vZ", "\u00c5\u00bd");
        CHARS.put("vz", "\u00c5\u00be");
        CHARS.put("%", "%");
    }

    private class IntAndString {
        public int i;
        String s;

        public IntAndString(int i, String s) {
            this.i = i;
            this.s = s;
        }
    }
}

