/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.util.TXMLReader;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BibtexFields {
    public static final String KEY_FIELD = "bibtexkey";
    public static final String SEARCH = "__search";
    public static final String GROUPSEARCH = "__groupsearch";
    public static final String MARKED = "__markedentry";
    public static final String OWNER = "owner";
    public static final String TIMESTAMP = "timestamp";
    public static final String ENTRYTYPE = "entrytype";
    public static final String DEFAULT_BIBTEXENTRY_ID = "__ID";
    public static final String[] DEFAULT_INSPECTION_FIELDS = new String[]{"author", "title", "year", "bibtexkey"};
    private static final BibtexFields runtime = new BibtexFields();
    private HashMap<String, BibtexSingleField> fieldSet = new HashMap();
    private String[] PUBLIC_FIELDS = null;

    private BibtexFields() {
        BibtexSingleField dummy = null;
        this.add(new BibtexSingleField("address", true, 0.3));
        this.add(new BibtexSingleField("annote", true, 1.5));
        this.add(new BibtexSingleField("author", true, 0.5, 280));
        this.add(new BibtexSingleField("booktitle", true, 175));
        this.add(new BibtexSingleField("chapter", true, 0.3));
        this.add(new BibtexSingleField("crossref", true, 0.3));
        this.add(new BibtexSingleField("edition", true, 0.3));
        this.add(new BibtexSingleField("editor", true, 0.5, 280));
        this.add(new BibtexSingleField("howpublished", true, 0.5));
        this.add(new BibtexSingleField("institution", true, 0.5));
        dummy = new BibtexSingleField("journal", true, 0.3);
        dummy.setExtras("journalNames");
        this.add(dummy);
        this.add(new BibtexSingleField("key", true));
        this.add(new BibtexSingleField("month", true, 0.3));
        this.add(new BibtexSingleField("note", true, 0.5));
        this.add(new BibtexSingleField("number", true, 0.3, 60).setNumeric(true));
        this.add(new BibtexSingleField("organization", true, 0.5));
        this.add(new BibtexSingleField("pages", true, 0.3));
        this.add(new BibtexSingleField("publisher", true, 0.5));
        this.add(new BibtexSingleField("school", true, 0.5));
        this.add(new BibtexSingleField("series", true, 0.3));
        this.add(new BibtexSingleField("title", true, 400));
        this.add(new BibtexSingleField("type", true, 0.3));
        this.add(new BibtexSingleField("language", true, 0.3));
        this.add(new BibtexSingleField("volume", true, 0.3, 60).setNumeric(true));
        this.add(new BibtexSingleField("year", true, 0.3, 60).setNumeric(true));
        dummy = new BibtexSingleField(KEY_FIELD, true);
        dummy.setPrivate();
        this.add(dummy);
        dummy = new BibtexSingleField("doi", true, 0.3);
        dummy.setExtras("external");
        this.add(dummy);
        this.add(new BibtexSingleField("eid", true, 0.3));
        dummy = new BibtexSingleField("date", true);
        dummy.setPrivate();
        this.add(dummy);
        this.add(new BibtexSingleField("pmid", false, 0.3, 60).setNumeric(true));
        dummy = new BibtexSingleField("citeseercitationcount", false, 0.3, 75);
        dummy.setNumeric(true);
        dummy.setAlternativeDisplayName("Popularity");
        this.add(dummy);
        this.add(new BibtexSingleField("location", false));
        this.add(new BibtexSingleField("abstract", false, 1.5, 400));
        dummy = new BibtexSingleField("url", false, 0.3);
        dummy.setExtras("external");
        this.add(dummy);
        dummy = new BibtexSingleField("citeseerurl", false, 0.3);
        dummy.setExtras("external");
        this.add(dummy);
        dummy = new BibtexSingleField("pdf", false, 0.3);
        dummy.setExtras("browseDoc");
        this.add(dummy);
        dummy = new BibtexSingleField("ps", false, 0.3);
        dummy.setExtras("browseDocZip");
        this.add(dummy);
        this.add(new BibtexSingleField("comment", false, 0.5));
        this.add(new BibtexSingleField("keywords", false, 0.3));
        dummy = new BibtexSingleField("file", false);
        dummy.setEditorType(2);
        this.add(dummy);
        this.add(new BibtexSingleField("search", false, 75));
        dummy = new BibtexSingleField(GUIGlobals.NUMBER_COL, false, 32);
        dummy.setPrivate();
        dummy.setWriteable(false);
        dummy.setDisplayable(false);
        this.add(dummy);
        dummy = new BibtexSingleField(OWNER, false, 0.3);
        dummy.setExtras("setOwner");
        dummy.setPrivate();
        this.add(dummy);
        dummy = new BibtexSingleField(TIMESTAMP, false, 0.3);
        dummy.setExtras("datepicker");
        dummy.setPrivate();
        this.add(dummy);
        dummy = new BibtexSingleField(ENTRYTYPE, false, 75);
        dummy.setPrivate();
        this.add(dummy);
        dummy = new BibtexSingleField(SEARCH, false);
        dummy.setPrivate();
        dummy.setWriteable(false);
        dummy.setDisplayable(false);
        this.add(dummy);
        dummy = new BibtexSingleField(GROUPSEARCH, false);
        dummy.setPrivate();
        dummy.setWriteable(false);
        dummy.setDisplayable(false);
        this.add(dummy);
        dummy = new BibtexSingleField(MARKED, false);
        dummy.setPrivate();
        dummy.setWriteable(true);
        dummy.setDisplayable(false);
        this.add(dummy);
        this.readXML("/resource/fields/fields.xml");
        Vector<String> pFields = new Vector<String>(this.fieldSet.size());
        for (BibtexSingleField sField : this.fieldSet.values()) {
            if (!sField.isPublic()) continue;
            pFields.add(sField.getFieldName());
        }
        this.PUBLIC_FIELDS = pFields.toArray(new String[pFields.size()]);
        Arrays.sort(this.PUBLIC_FIELDS);
    }

    public static void setNumericFieldsFromPrefs() {
        BibtexSingleField field;
        String[] numFields = Globals.prefs.getStringArray("numericFields");
        if (numFields == null) {
            return;
        }
        HashSet<String> nF = new HashSet<String>();
        for (int i = 0; i < numFields.length; ++i) {
            nF.add(numFields[i]);
        }
        for (String fieldName : BibtexFields.runtime.fieldSet.keySet()) {
            field = BibtexFields.runtime.fieldSet.get(fieldName);
            if (!field.isNumeric() && nF.contains(fieldName)) {
                field.setNumeric(nF.contains(fieldName));
            }
            nF.remove(fieldName);
        }
        for (String fieldName : nF) {
            field = new BibtexSingleField(fieldName, false);
            field.setNumeric(true);
            BibtexFields.runtime.fieldSet.put(fieldName, field);
        }
    }

    private void add(BibtexSingleField field) {
        String key = field.name;
        this.fieldSet.put(key, field);
    }

    private void readXML(String resName) {
        TXMLReader reader = new TXMLReader(resName);
        if (reader.isReady()) {
            NodeList fieldNodes = reader.getNodes("field");
            int tagsCount = fieldNodes.getLength();
            for (int t = 0; t < tagsCount; ++t) {
                BibtexSingleField dummy;
                Element entry = (Element)fieldNodes.item(t);
                String fName = reader.readStringAttribute(entry, "name", null);
                if (fName == null || (dummy = this.fieldSet.get(fName = fName.toLowerCase())) != null) continue;
                dummy = new BibtexSingleField(reader, entry);
                this.fieldSet.put(fName, dummy);
            }
        }
    }

    private static final BibtexSingleField getField(String name) {
        if (name != null) {
            return BibtexFields.runtime.fieldSet.get(name.toLowerCase());
        }
        return null;
    }

    public static String getFieldExtras(String name) {
        BibtexSingleField sField = BibtexFields.getField(name);
        if (sField != null) {
            return sField.getExtras();
        }
        return null;
    }

    public static int getEditorType(String name) {
        BibtexSingleField sField = BibtexFields.getField(name);
        if (sField != null) {
            return sField.getEditorType();
        }
        return 1;
    }

    public static double getFieldWeight(String name) {
        BibtexSingleField sField = BibtexFields.getField(name);
        if (sField != null) {
            return sField.getWeight();
        }
        return 1.0;
    }

    public static void setFieldWeight(String fieldName, double weight) {
        BibtexSingleField sField = BibtexFields.getField(fieldName);
        if (sField != null) {
            sField.setWeight(weight);
        }
    }

    public static int getFieldLength(String name) {
        BibtexSingleField sField = BibtexFields.getField(name);
        if (sField != null) {
            return sField.getLength();
        }
        return GUIGlobals.DEFAULT_FIELD_LENGTH;
    }

    public static String getFieldDisplayName(String fieldName) {
        BibtexSingleField sField = BibtexFields.getField(fieldName);
        if (sField != null) {
            return sField.getAlternativeDisplayName();
        }
        return null;
    }

    public static boolean isWriteableField(String field) {
        BibtexSingleField sField = BibtexFields.getField(field);
        if (sField != null) {
            return sField.isWriteable();
        }
        return true;
    }

    public static boolean isDisplayableField(String field) {
        BibtexSingleField sField = BibtexFields.getField(field);
        if (sField != null) {
            return sField.isDisplayable();
        }
        return true;
    }

    public static boolean isStandardField(String field) {
        BibtexSingleField sField = BibtexFields.getField(field);
        if (sField != null) {
            return sField.isStandard();
        }
        return false;
    }

    public static boolean isNumeric(String field) {
        BibtexSingleField sField = BibtexFields.getField(field);
        if (sField != null) {
            return sField.isNumeric();
        }
        return false;
    }

    public static String[] getAllFieldNames() {
        return BibtexFields.runtime.PUBLIC_FIELDS;
    }

    public static String getFieldName(int t) {
        return BibtexFields.runtime.PUBLIC_FIELDS[t];
    }

    public static int numberOfPublicFields() {
        return BibtexFields.runtime.PUBLIC_FIELDS.length;
    }

    private static class BibtexSingleField {
        private static final int STANDARD = 1;
        private static final int PRIVATE = 2;
        private static final int DISPLAYABLE = 4;
        private static final int WRITEABLE = 8;
        private String name;
        private int flag = 12;
        private int length = GUIGlobals.DEFAULT_FIELD_LENGTH;
        private double weight = 1.0;
        private int editorType = 1;
        private String alternativeDisplayName = null;
        private String extras = null;
        private boolean numeric = false;

        public BibtexSingleField(String fieldName) {
            this.name = fieldName;
        }

        public BibtexSingleField(String fieldName, boolean pStandard) {
            this.name = fieldName;
            this.setFlag(pStandard, 1);
        }

        public BibtexSingleField(String fieldName, boolean pStandard, double pWeight) {
            this.name = fieldName;
            this.setFlag(pStandard, 1);
            this.weight = pWeight;
        }

        public BibtexSingleField(String fieldName, boolean pStandard, int pLength) {
            this.name = fieldName;
            this.setFlag(pStandard, 1);
            this.length = pLength;
        }

        public BibtexSingleField(String fieldName, boolean pStandard, double pWeight, int pLength) {
            this.name = fieldName;
            this.setFlag(pStandard, 1);
            this.weight = pWeight;
            this.length = pLength;
        }

        public BibtexSingleField(TXMLReader reader, Element node) {
            this.flag = 12;
            this.name = reader.readStringAttribute(node, "name", "field");
            this.name = this.name.toLowerCase();
            String wStr = reader.readStringAttribute(node, "weight", null);
            if (wStr != null) {
                int hCode = wStr.toLowerCase().hashCode();
                if (hCode == "small".hashCode()) {
                    this.weight = 0.3;
                } else if (hCode == "medium".hashCode()) {
                    this.weight = 0.5;
                } else if (hCode == "large".hashCode()) {
                    this.weight = 1.5;
                } else {
                    try {
                        this.weight = Double.parseDouble(wStr);
                        if (this.weight < 0.0 || this.weight > 2.0) {
                            this.weight = 1.0;
                        }
                    }
                    catch (Exception e) {
                        this.weight = 1.0;
                    }
                }
            }
            this.length = reader.readIntegerAttribute(node, "length", GUIGlobals.DEFAULT_FIELD_LENGTH);
            this.extras = reader.readStringAttribute(node, "extras", null);
        }

        private void setFlag(boolean onOff, int flagID) {
            this.flag = onOff ? (this.flag |= flagID) : (this.flag &= 0xFF ^ flagID);
        }

        private boolean isSet(int flagID) {
            return (this.flag & flagID) == flagID;
        }

        public boolean isStandard() {
            return this.isSet(1);
        }

        public void setPrivate() {
            this.flag |= 2;
        }

        public boolean isPrivate() {
            return this.isSet(2);
        }

        public void setPublic() {
            this.setFlag(false, 2);
        }

        public boolean isPublic() {
            return !this.isSet(2);
        }

        public void setDisplayable(boolean value) {
            this.setFlag(value, 4);
        }

        public boolean isDisplayable() {
            return this.isSet(4);
        }

        public void setWriteable(boolean value) {
            this.setFlag(value, 8);
        }

        public boolean isWriteable() {
            return this.isSet(8);
        }

        public void setAlternativeDisplayName(String aName) {
            this.alternativeDisplayName = aName;
        }

        public String getAlternativeDisplayName() {
            return this.alternativeDisplayName;
        }

        public void setExtras(String pExtras) {
            this.extras = pExtras;
        }

        public String getExtras() {
            return this.extras;
        }

        public void setEditorType(int type) {
            this.editorType = type;
        }

        public int getEditorType() {
            return this.editorType;
        }

        public void setWeight(double value) {
            this.weight = value;
        }

        public double getWeight() {
            return this.weight;
        }

        public int getLength() {
            return this.length;
        }

        public String getFieldName() {
            return this.name;
        }

        public BibtexSingleField setNumeric(boolean numeric) {
            this.numeric = numeric;
            return this;
        }

        public boolean isNumeric() {
            return this.numeric;
        }
    }
}

