/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

public class FontStyle {
    public static final int COUNT = 4;
    public static final FontStyle UNDEFINED = new FontStyle("?", -1);
    public static final FontStyle REGULAR = new FontStyle("Regular", 0);
    public static final FontStyle ITALIC = new FontStyle("Italic", 1);
    public static final FontStyle BOLD = new FontStyle("Bold", 2);
    public static final FontStyle BOLD_ITALIC = new FontStyle("BoldItalic", 3);
    private final String id;
    private final int index;

    public static FontStyle getFontStyle(String name) {
        if (name == null) {
            return REGULAR;
        }
        name = name.trim().toLowerCase();
        boolean bold = false;
        boolean italic = false;
        if (name.indexOf("bold") >= 0) {
            bold = true;
        }
        if (name.indexOf("italic") >= 0) {
            italic = true;
        }
        if (name.indexOf("oblique") >= 0) {
            italic = true;
        }
        if (bold) {
            if (italic) {
                return BOLD_ITALIC;
            }
            return BOLD;
        }
        if (italic) {
            return ITALIC;
        }
        return REGULAR;
    }

    private FontStyle(String label, int index) {
        this.id = label;
        this.index = index;
    }

    public FontStyle getBoldFlavor() {
        if (this == ITALIC) {
            return BOLD_ITALIC;
        }
        return BOLD;
    }

    public String getId() {
        return this.id;
    }

    protected int getIndex() {
        return this.index;
    }

    public FontStyle getItalicFlavor() {
        if (this == BOLD) {
            return BOLD_ITALIC;
        }
        return ITALIC;
    }

    public String toString() {
        return this.getId();
    }
}

